/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.AdobeCharacterCollection;
import com.inet.pdfview.font.PDFFontEncoding;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;

public class CidMapFactory {
    private static final String RESOURCE_PATH = "resources/";
    private static final int GB1 = 1;
    private static final int CNS1 = 2;
    private static final int JAPAN1 = 3;
    private static final int KS = 4;

    static PDFFontToUnicodeMap getToUnicodeMap(AdobeCharacterCollection charCollection) {
        byte[] arr = CidMapFactory.getResourceAsByteArray(RESOURCE_PATH + charCollection.getResourceName());
        return new PDFFontToUnicodeMap(arr);
    }

    public static PDFFontToUnicodeMap getUnicodeMapping(@Nonnull PDFObject encodingObj, @Nonnull PDFFontEncoding encoding) {
        PDFFontToUnicodeMap toUnicodeMap = null;
        int mappingType = 0;
        try {
            PDFObject systemInfo = encodingObj.getDictRef("CIDSystemInfo");
            String registry = null;
            String ordering = null;
            int supplement = 0;
            if (systemInfo != null) {
                PDFObject suppl;
                PDFObject order;
                PDFObject reg = systemInfo.getDictRef("Registry");
                if (reg != null) {
                    registry = reg.getStringValue();
                }
                if ((order = systemInfo.getDictRef("Ordering")) != null) {
                    ordering = order.getStringValue();
                }
                if ((suppl = systemInfo.getDictRef("Supplement")) != null) {
                    supplement = suppl.getIntValue();
                }
                if (reg != null && "Adobe".equals(registry) && order != null) {
                    if ("Japan1".equals(ordering)) {
                        mappingType = 3;
                    } else if ("CNS1".equals(ordering)) {
                        mappingType = 2;
                    } else if ("GB1".equals(ordering)) {
                        mappingType = 1;
                    }
                }
                String mappingName = null;
                PDFObject mappingNameObj = encodingObj.getDictRef("CMapName");
                if (mappingNameObj != null) {
                    mappingName = mappingNameObj.getStringValue();
                    switch (mappingType) {
                        case 3: {
                            if (!mappingName.startsWith("UniJIS-") || !CidMapFactory.hasValidType(mappingName.substring("UniJIS\u2212".length()), true)) break;
                            return PDFFontToUnicodeMap.getNamedMapping("Identity-H");
                        }
                        case 1: {
                            if (!mappingName.startsWith("UniGB-") || !CidMapFactory.hasValidType(mappingName.substring("UniGB-".length()), false)) break;
                            return PDFFontToUnicodeMap.getNamedMapping("Identity-H");
                        }
                        case 2: {
                            if (!mappingName.startsWith("UniCNS\u2212") || !CidMapFactory.hasValidType(mappingName.substring("UniCNS-".length()), false)) break;
                            return PDFFontToUnicodeMap.getNamedMapping("Identity-H");
                        }
                        case 4: {
                            if (!mappingName.startsWith("UniKS-") || !CidMapFactory.hasValidType(mappingName.substring("UniKS-".length()), false)) break;
                            return PDFFontToUnicodeMap.getNamedMapping("Identity-H");
                        }
                    }
                    String charCollection = registry + "-" + ordering + "-" + supplement;
                    PDFFontToUnicodeMap cidToUnicode = null;
                    AdobeCharacterCollection acc = AdobeCharacterCollection.fromName(charCollection);
                    if (acc != null) {
                        cidToUnicode = acc.getToUnicodeMap();
                    }
                    if ("Identity-H".equals(mappingName) || "Identity-V".equals(mappingName)) {
                        return cidToUnicode;
                    }
                    return cidToUnicode;
                }
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        return toUnicodeMap;
    }

    private static byte[] getResourceAsByteArray(String resourceName) {
        byte[] arr = null;
        InputStream in = CidMapFactory.class.getResourceAsStream(resourceName);
        if (in != null) {
            try {
                int len;
                ByteArrayOutputStream bos = new ByteArrayOutputStream(in.available());
                byte[] buf = new byte[4096];
                while ((len = in.read(buf)) > 0) {
                    bos.write(buf, 0, len);
                }
                in.close();
                bos.flush();
                arr = bos.toByteArray();
            }
            catch (Exception ex) {
                PDFParser.LOGGER.error((Throwable)ex);
            }
        } else {
            PDFParser.LOGGER.warn((Object)("resource: " + resourceName + " not found"));
        }
        return arr;
    }

    private static boolean hasValidType(String encodingstr, boolean testHalfWidth) {
        if ("UCS2-H".equals(encodingstr) || "UCS2-V".equals(encodingstr) || "UTF16-H".equals(encodingstr) || "UTF16-V".equals(encodingstr)) {
            return true;
        }
        return testHalfWidth && ("UCS2-HW-H".equals(encodingstr) || "UCS2_HW-V".equals(encodingstr));
    }
}

