/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import java.util.Arrays;

public class CharCharMap {
    private static final long serialVersionUID = 1444595945391913849L;
    public static final char NULL_VAL = '\uffff';
    private static final char REMOVED = '\ufffe';
    private char[] keys;
    private int maxKey;
    private float maxLoad;
    private int minKey;
    private int size;
    private char[] values;

    public CharCharMap() {
        this(15, 0.75f);
    }

    public CharCharMap(int initialSize, float maxLoad) {
        if (maxLoad < 0.01f || maxLoad > 1.0f) {
            throw new IllegalArgumentException("maxLoad out of range");
        }
        if (initialSize < 1) {
            throw new IllegalArgumentException("initial size out of range");
        }
        this.keys = new char[initialSize |= 0xF];
        this.values = new char[initialSize];
        this.refreshValues();
        this.maxLoad = maxLoad;
    }

    private void refreshValues() {
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = 65535;
            }
        }
    }

    private void add(char[] keys2, char[] values2) {
        for (int i = 0; i < keys2.length; ++i) {
            char k = keys2[i];
            char v = values2[i];
            if (v == '\uffff' || v == '\ufffe') continue;
            this.put(k, v);
        }
    }

    public final void clear() {
        Arrays.fill(this.values, '\uffff');
        this.maxKey = 0;
        this.minKey = 0;
        this.size = 0;
    }

    public final char get(char key) {
        if (key < this.minKey || key > this.maxKey) {
            return '\uffff';
        }
        int idx = key % this.keys.length;
        int i = idx;
        for (int c = 0; c < this.keys.length; ++c) {
            char v = this.values[i];
            if (v == '\uffff') {
                return '\uffff';
            }
            if (this.keys[i] == key) {
                return v == '\ufffe' ? (char)'\uffff' : v;
            }
            i = (i + 1) % this.keys.length;
        }
        return '\uffff';
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int maxKey() {
        return this.maxKey;
    }

    public final int minKey() {
        return this.minKey;
    }

    public final int put(char key, char value) {
        if (value < '\u0000') {
            throw new IllegalArgumentException("negative values are not allowed: " + value);
        }
        if (this.size >= (int)(this.maxLoad * (float)this.keys.length)) {
            this.rehash();
        }
        int idx = key % this.keys.length;
        if (key < this.minKey) {
            if (key < '\u0000') {
                throw new IllegalArgumentException("negative keys are not allowed: " + key);
            }
            this.minKey = key;
        }
        if (key > this.maxKey) {
            this.maxKey = key;
        }
        int i = idx;
        for (int c = 0; c < this.keys.length; ++c) {
            char v = this.values[i];
            if (v == '\uffff' || v == '\ufffe') {
                this.keys[i] = key;
                this.values[i] = value;
                ++this.size;
                return 65535;
            }
            if (this.keys[i] == key) {
                char oldValue = v;
                this.values[i] = value;
                return oldValue;
            }
            i = (i + 1) % this.keys.length;
        }
        throw new IllegalStateException("put " + key + ":" + value + " failed");
    }

    private void recomputeMinMax() {
        if (this.size == 0) {
            this.maxKey = 0;
            this.minKey = 0;
        } else {
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                int k = this.keys[i];
                char v = this.values[i];
                if (v == '\uffff' || v == '\ufffe') continue;
                if (first) {
                    first = false;
                    this.minKey = this.maxKey = k;
                    continue;
                }
                if (k < this.minKey) {
                    k = this.minKey;
                }
                if (k <= this.maxKey) continue;
                int n = this.maxKey;
            }
        }
    }

    private final void rehash() {
        char[] keysOld = this.keys;
        char[] valuesOld = this.values;
        int newSize = this.keys.length * 2 | 0xF;
        this.size = 0;
        this.keys = new char[newSize];
        this.values = new char[newSize];
        this.refreshValues();
        this.add(keysOld, valuesOld);
    }

    public final int remove(int key) {
        if (key < this.minKey || key > this.maxKey) {
            return 65535;
        }
        int i = key % this.keys.length;
        for (int c = 0; c < this.keys.length; ++c) {
            int v = this.values[i];
            if (v == 65535) {
                return 65535;
            }
            if (this.keys[i] == key) {
                int nextIdx = (i + 1) % this.keys.length;
                this.values[i] = this.values[nextIdx] == '\uffff' ? 65535 : 65534;
                --this.size;
                if (key == this.minKey || key == this.maxKey) {
                    this.recomputeMinMax();
                }
                return v == 65534 ? 65535 : v;
            }
            i = (i + 1) % this.keys.length;
        }
        return 65535;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            char v = this.values[i];
            if (v == '\uffff' || v == '\ufffe') continue;
            if (first) {
                first = false;
            } else {
                sb.append(",\n");
            }
            sb.append(this.keys[i]).append('=').append((int)v);
        }
        sb.append("]");
        return sb.toString();
    }

    public int size() {
        return this.size;
    }

    public char[] getKeys() {
        return this.keys;
    }

    public boolean contains(char ch) {
        return this.get(ch) != '\uffff';
    }

    public char[] getValues() {
        return this.values;
    }
}

