/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.font.CidMapFactory;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import javax.annotation.Nullable;

public enum AdobeCharacterCollection {
    ADOBE_CNS1("Adobe-CNS1", "adobe-CNS1-UCS2.txt"),
    ADOBE_GB1("Adobe-GB1", "adobe-GB1-UCS2.txt"),
    ADOBE_JAPAN1("Adobe-Japan1", "adobe-Japan1-UCS2.txt"),
    ADOBE_KOREA1("Adobe-Korea1", "adobe-Korea1-UCS2.txt");

    private String name;
    private String resourceName;
    private boolean cidMapAlreadyCalculated;
    private PDFFontToUnicodeMap cid2Unicode;

    private AdobeCharacterCollection(String name, String resourceName) {
        this.name = name;
        this.resourceName = resourceName;
    }

    @Nullable
    public static AdobeCharacterCollection fromName(@Nullable String name) {
        if (name != null) {
            for (AdobeCharacterCollection acc : AdobeCharacterCollection.values()) {
                if (!name.startsWith(acc.name)) continue;
                return acc;
            }
        }
        return null;
    }

    public PDFFontToUnicodeMap getToUnicodeMap() {
        if (!this.cidMapAlreadyCalculated) {
            this.cidMapAlreadyCalculated = true;
            this.cid2Unicode = CidMapFactory.getToUnicodeMap(this);
        }
        return this.cid2Unicode;
    }

    String getResourceName() {
        return this.resourceName;
    }
}

