/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import java.util.HashMap;
import java.util.Map;

public class AdobeCharNames {
    private static Map<String, Character> nameToUnicode;
    private static final char[] unicode;
    private static String[] charNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Character getCharBasedOnAdobeName(String adobeName) {
        Character res;
        if (nameToUnicode == null) {
            char[] cArray = unicode;
            // MONITORENTER : unicode
            if (nameToUnicode == null) {
                HashMap<String, Character> nameToUnicodeTemp = new HashMap<String, Character>();
                for (int i = 0; i < unicode.length; ++i) {
                    nameToUnicodeTemp.put(charNames[i], Character.valueOf(unicode[i]));
                }
                nameToUnicode = nameToUnicodeTemp;
            }
            // MONITOREXIT : cArray
        }
        if ((res = nameToUnicode.get(adobeName)) != null) return res;
        if (nameToUnicode.containsKey(adobeName)) return res;
        res = AdobeCharNames.parseUnicodeFromGlyphName(adobeName);
        nameToUnicode.put(adobeName, res);
        return res;
    }

    static Character parseUnicodeFromGlyphName(String glyphName) {
        Character unicode = null;
        boolean conttainsUnicodePrefix = false;
        if (glyphName.startsWith("uni") || glyphName.startsWith("UNI")) {
            glyphName = glyphName.substring("uni".length());
            conttainsUnicodePrefix = true;
        } else if (glyphName.startsWith("u") || glyphName.startsWith("U")) {
            glyphName = glyphName.substring("u".length());
            conttainsUnicodePrefix = true;
        }
        if (conttainsUnicodePrefix) {
            try {
                int ival = Integer.parseInt(glyphName, 16);
                if (ival != 0 && ival < 65535) {
                    unicode = Character.valueOf((char)ival);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return unicode;
    }

    static {
        unicode = new char[]{'A', '\u00c6', '\u01fc', '\uf7e6', '\u00c1', '\uf7e1', '\u0102', '\u00c2', '\uf7e2', '\uf6c9', '\uf7b4', '\u00c4', '\uf7e4', '\u00c0', '\uf7e0', '\u0391', '\u0386', '\u0100', '\u0104', '\u00c5', '\u01fa', '\uf7e5', '\uf761', '\u00c3', '\uf7e3', 'B', '\u0392', '\uf6f4', '\uf762', 'C', '\u0106', '\uf6ca', '\uf6f5', '\u010c', '\u00c7', '\uf7e7', '\u0108', '\u010a', '\uf7b8', '\u03a7', '\uf6f6', '\uf763', 'D', '\u010e', '\u0110', '\u2206', '\u0394', '\uf6cb', '\uf6cc', '\uf6cd', '\uf7a8', '\uf6f7', '\uf764', 'E', '\u00c9', '\uf7e9', '\u0114', '\u011a', '\u00ca', '\uf7ea', '\u00cb', '\uf7eb', '\u0116', '\u00c8', '\uf7e8', '\u0112', '\u014a', '\u0118', '\u0395', '\u0388', '\uf765', '\u0397', '\u0389', '\u00d0', '\uf7f0', '\u20ac', 'F', '\uf766', 'G', '\u0393', '\u011e', '\u01e6', '\u011c', '\u0122', '\u0120', '\uf6ce', '\uf760', '\uf767', 'H', '\u25cf', '\u25aa', '\u25ab', '\u25a1', '\u0126', '\u0124', '\uf768', '\uf6cf', '\uf6f8', 'I', '\u0132', '\u00cd', '\uf7ed', '\u012c', '\u00ce', '\uf7ee', '\u00cf', '\uf7ef', '\u0130', '\u2111', '\u00cc', '\uf7ec', '\u012a', '\u012e', '\u0399', '\u03aa', '\u038a', '\uf769', '\u0128', 'J', '\u0134', '\uf76a', 'K', '\u039a', '\u0136', '\uf76b', 'L', '\uf6bf', '\u0139', '\u039b', '\u013d', '\u013b', '\u013f', '\u0141', '\uf6f9', '\uf76c', 'M', '\uf6d0', '\uf7af', '\uf76d', '\u039c', 'N', '\u0143', '\u0147', '\u0145', '\uf76e', '\u00d1', '\uf7f1', '\u039d', 'O', '\u0152', '\uf6fa', '\u00d3', '\uf7f3', '\u014e', '\u00d4', '\uf7f4', '\u00d6', '\uf7f6', '\uf6fb', '\u00d2', '\uf7f2', '\u01a0', '\u0150', '\u014c', '\u2126', '\u03a9', '\u038f', '\u039f', '\u038c', '\u00d8', '\u01fe', '\uf7f8', '\uf76f', '\u00d5', '\uf7f5', 'P', '\u03a6', '\u03a0', '\u03a8', '\uf770', 'Q', '\uf771', 'R', '\u0154', '\u0158', '\u0156', '\u211c', '\u03a1', '\uf6fc', '\uf772', 'S', '\u250c', '\u2514', '\u2510', '\u2518', '\u253c', '\u252c', '\u2534', '\u251c', '\u2524', '\u2500', '\u2502', '\u2561', '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255d', '\u255c', '\u255b', '\u255e', '\u255f', '\u255a', '\u2554', '\u2569', '\u2566', '\u2560', '\u2550', '\u256c', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553', '\u256b', '\u256a', '\u015a', '\u0160', '\uf6fd', '\u015e', '\uf6c1', '\u015c', '\u0218', '\u03a3', '\uf773', 'T', '\u03a4', '\u0166', '\u0164', '\u0162', '\u021a', '\u0398', '\u00de', '\uf7fe', '\uf6fe', '\uf774', 'U', '\u00da', '\uf7fa', '\u016c', '\u00db', '\uf7fb', '\u00dc', '\uf7fc', '\u00d9', '\uf7f9', '\u01af', '\u0170', '\u016a', '\u0172', '\u03a5', '\u03d2', '\u03ab', '\u038e', '\u016e', '\uf775', '\u0168', 'V', '\uf776', 'W', '\u1e82', '\u0174', '\u1e84', '\u1e80', '\uf777', 'X', '\u039e', '\uf778', 'Y', '\u00dd', '\uf7fd', '\u0176', '\u0178', '\uf7ff', '\u1ef2', '\uf779', 'Z', '\u0179', '\u017d', '\uf6ff', '\u017b', '\u0396', '\uf77a', 'a', '\u00e1', '\u0103', '\u00e2', '\u00b4', '\u0301', '\u00e4', '\u00e6', '\u01fd', '\u2015', '\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0401', '\u0416', '\u0417', '\u0418', '\u0419', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042a', '\u042b', '\u042c', '\u042d', '\u042e', '\u042f', '\u0490', '\u0402', '\u0403', '\u0404', '\u0405', '\u0406', '\u0407', '\u0408', '\u0409', '\u040a', '\u040b', '\u040c', '\u040e', '\uf6c4', '\uf6c5', '\u0430', '\u0431', '\u0432', '\u0433', '\u0434', '\u0435', '\u0451', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043e', '\u043f', '\u0440', '\u0441', '\u0442', '\u0443', '\u0444', '\u0445', '\u0446', '\u0447', '\u0448', '\u0449', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f', '\u0491', '\u0452', '\u0453', '\u0454', '\u0455', '\u0456', '\u0457', '\u0458', '\u0459', '\u045a', '\u045b', '\u045c', '\u045e', '\u040f', '\u0462', '\u0472', '\u0474', '\uf6c6', '\u045f', '\u0463', '\u0473', '\u0475', '\uf6c7', '\uf6c8', '\u04d9', '\u200e', '\u200f', '\u200d', '\u066a', '\u060c', '\u0660', '\u0661', '\u0662', '\u0663', '\u0664', '\u0665', '\u0666', '\u0667', '\u0668', '\u0669', '\u061b', '\u061f', '\u0621', '\u0622', '\u0623', '\u0624', '\u0625', '\u0626', '\u0627', '\u0628', '\u0629', '\u062a', '\u062b', '\u062c', '\u062d', '\u062e', '\u062f', '\u0630', '\u0631', '\u0632', '\u0633', '\u0634', '\u0635', '\u0636', '\u0637', '\u0638', '\u0639', '\u063a', '\u0640', '\u0641', '\u0642', '\u0643', '\u0644', '\u0645', '\u0646', '\u0648', '\u0649', '\u064a', '\u064b', '\u064c', '\u064d', '\u064e', '\u064f', '\u0650', '\u0651', '\u0652', '\u0647', '\u06a4', '\u067e', '\u0686', '\u0698', '\u06af', '\u0679', '\u0688', '\u0691', '\u06ba', '\u06d2', '\u06d5', '\u20aa', '\u05be', '\u05c3', '\u05d0', '\u05d1', '\u05d2', '\u05d3', '\u05d4', '\u05d5', '\u05d6', '\u05d7', '\u05d8', '\u05d9', '\u05da', '\u05db', '\u05dc', '\u05dd', '\u05de', '\u05df', '\u05e0', '\u05e1', '\u05e2', '\u05e3', '\u05e4', '\u05e5', '\u05e6', '\u05e7', '\u05e8', '\u05e9', '\u05ea', '\ufb2a', '\ufb2b', '\ufb4b', '\ufb1f', '\u05f0', '\u05f1', '\u05f2', '\ufb35', '\u05b4', '\u05b5', '\u05b6', '\u05bb', '\u05b8', '\u05b7', '\u05b0', '\u05b2', '\u05b1', '\u05b3', '\u05c2', '\u05c1', '\u05b9', '\u05bc', '\u05bd', '\u05bf', '\u05c0', '\u02bc', '\u2105', '\u2113', '\u2116', '\u202c', '\u202d', '\u202e', '\u200c', '\u066d', '\u02bd', '\u00e0', '\u2135', '\u03b1', '\u03ac', '\u0101', '&', '\uf726', '\u2220', '\u2329', '\u232a', '\u0387', '\u0105', '\u2248', '\u00e5', '\u01fb', '\u2194', '\u21d4', '\u21d3', '\u21d0', '\u21d2', '\u21d1', '\u2193', '\uf8e7', '\u2190', '\u2192', '\u2191', '\u2195', '\u21a8', '\uf8e6', '^', '~', '*', '\u2217', '\uf6e9', '@', '\u00e3', 'b', '\\', '|', '\u03b2', '\u2588', '\uf8f4', '{', '\uf8f3', '\uf8f2', '\uf8f1', '}', '\uf8fe', '\uf8fd', '\uf8fc', '[', '\uf8f0', '\uf8ef', '\uf8ee', ']', '\uf8fb', '\uf8fa', '\uf8f9', '\u02d8', '\u00a6', '\uf6ea', '\u2022', 'c', '\u0107', '\u02c7', '\u21b5', '\u010d', '\u00e7', '\u0109', '\u010b', '\u00b8', '\u00a2', '\uf6df', '\uf7a2', '\uf6e0', '\u03c7', '\u25cb', '\u2297', '\u2295', '\u02c6', '\u2663', ':', '\u20a1', ',', '\uf6c3', '\uf6e1', '\uf6e2', '\u2245', '\u00a9', '\uf8e9', '\uf6d9', '\u00a4', '\uf6d1', '\uf6d2', '\uf6d4', '\uf6d5', 'd', '\u2020', '\u2021', '\uf6d3', '\uf6d6', '\u010f', '\u0111', '\u00b0', '\u03b4', '\u2666', '\u00a8', '\uf6d7', '\uf6d8', '\u0385', '\u00f7', '\u2593', '\u2584', '$', '\uf6e3', '\uf724', '\uf6e4', '\u20ab', '\u02d9', '\u0323', '\u0131', '\uf6be', '\u22c5', '\uf6eb', 'e', '\u00e9', '\u0115', '\u011b', '\u00ea', '\u00eb', '\u0117', '\u00e8', '8', '\u2088', '\uf738', '\u2078', '\u2208', '\u2026', '\u0113', '\u2014', '\u2205', '\u2013', '\u014b', '\u0119', '\u03b5', '\u03ad', '=', '\u2261', '\u212e', '\uf6ec', '\u03b7', '\u03ae', '\u00f0', '!', '\u203c', '\u00a1', '\uf7a1', '\uf721', '\u2203', 'f', '\u2640', '\ufb00', '\ufb03', '\ufb04', '\ufb01', '\u2012', '\u25a0', '\u25ac', '5', '\u215d', '\u2085', '\uf735', '\u2075', '\ufb02', '\u0192', '4', '\u2084', '\uf734', '\u2074', '\u2044', '\u2215', '\u20a3', 'g', '\u03b3', '\u011f', '\u01e7', '\u011d', '\u0123', '\u0121', '\u00df', '\u2207', '`', '\u0300', '>', '\u2265', '\u00ab', '\u00bb', '\u2039', '\u203a', 'h', '\u0127', '\u0125', '\u2665', '\u0309', '\u2302', '\u02dd', '-', '\u00ad', '\u2010', '\uf6e5', '\uf6e6', 'i', '\u00ed', '\u012d', '\u00ee', '\u00ef', '\u00ec', '\u0133', '\u012b', '\u221e', '\u222b', '\u2321', '\uf8f5', '\u2320', '\u2229', '\u25d8', '\u25d9', '\u263b', '\u012f', '\u03b9', '\u03ca', '\u0390', '\u03af', '\uf6ed', '\u0129', 'j', '\u0135', 'k', '\u03ba', '\u0137', '\u0138', 'l', '\u013a', '\u03bb', '\u013e', '\u013c', '\u0140', '<', '\u2264', '\u258c', '\u20a4', '\uf6c0', '\u2227', '\u00ac', '\u2228', '\u017f', '\u25ca', '\u0142', '\uf6ee', '\u2591', 'm', '\u00af', '\u02c9', '\u2642', '\u2212', '\u2032', '\uf6ef', '\u00b5', '\u03bc', '\u00d7', '\u266a', '\u266b', 'n', '\u0144', '\u0149', '\u0148', '\u0146', '9', '\u2089', '\uf739', '\u2079', '\u2209', '\u2260', '\u2284', '\u207f', '\u00f1', '\u03bd', '#', 'o', '\u00f3', '\u014f', '\u00f4', '\u00f6', '\u0153', '\u02db', '\u00f2', '\u01a1', '\u0151', '\u014d', '\u03c9', '\u03d6', '\u03ce', '\u03bf', '\u03cc', '1', '\u2024', '\u215b', '\uf6dc', '\u00bd', '\u2081', '\uf731', '\u00bc', '\u00b9', '\u2153', '\u25e6', '\u00aa', '\u00ba', '\u221f', '\u00f8', '\u01ff', '\uf6f0', '\u00f5', 'p', '\u00b6', '(', '\uf8ed', '\uf8ec', '\u208d', '\u207d', '\uf8eb', ')', '\uf8f8', '\uf8f7', '\u208e', '\u207e', '\uf8f6', '\u2202', '%', '.', '\u00b7', '\u2219', '\uf6e7', '\uf6e8', '\u22a5', '\u2030', '\u20a7', '\u03c6', '\u03d5', '\u03c0', '+', '\u00b1', '\u211e', '\u220f', '\u2282', '\u2283', '\u221d', '\u03c8', 'q', '?', '\u00bf', '\uf7bf', '\uf73f', '\"', '\u201e', '\u201c', '\u201d', '\u2018', '\u201b', '\u2019', '\u201a', '\'', 'r', '\u0155', '\u221a', '\uf8e5', '\u0159', '\u0157', '\u2286', '\u2287', '\u00ae', '\uf8e8', '\uf6da', '\u2310', '\u03c1', '\u02da', '\uf6f1', '\u2590', '\uf6dd', 's', '\u015b', '\u0161', '\u015f', '\uf6c2', '\u015d', '\u0219', '\u2033', '\u00a7', ';', '7', '\u215e', '\u2087', '\uf737', '\u2077', '\u2592', '\u03c3', '\u03c2', '\u223c', '6', '\u2086', '\uf736', '\u2076', '/', '\u263a', '\u00a0', ' ', '\u2660', '\uf6f2', '\u00a3', '\u220b', '\u2211', '\u263c', 't', '\u03c4', '\u0167', '\u0165', '\u0163', '\u021b', '\u2234', '\u03b8', '\u03d1', '\u00fe', '3', '\u215c', '\u2083', '\uf733', '\u00be', '\uf6de', '\u00b3', '\u02dc', '\u0303', '\u0384', '\u2122', '\uf8ea', '\uf6db', '\u25bc', '\u25c4', '\u25ba', '\u25b2', '\uf6f3', '2', '\u2025', '\u2082', '\uf732', '\u00b2', '\u2154', 'u', '\u00fa', '\u016d', '\u00fb', '\u00fc', '\u00f9', '\u01b0', '\u0171', '\u016b', '_', '\u2017', '\u222a', '\u2200', '\u0173', '\u2580', '\u03c5', '\u03cb', '\u03b0', '\u03cd', '\u016f', '\u0169', 'v', 'w', '\u1e83', '\u0175', '\u1e85', '\u2118', '\u1e81', 'x', '\u03be', 'y', '\u00fd', '\u0177', '\u00ff', '\u00a5', '\u1ef3', 'z', '\u017a', '\u017e', '\u017c', '0', '\u2080', '\uf730', '\u2070', '\u03b6'};
        charNames = new String[]{"A", "AE", "AEacute", "AEsmall", "Aacute", "Aacutesmall", "Abreve", "Acircumflex", "Acircumflexsmall", "Acute", "Acutesmall", "Adieresis", "Adieresissmall", "Agrave", "Agravesmall", "Alpha", "Alphatonos", "Amacron", "Aogonek", "Aring", "Aringacute", "Aringsmall", "Asmall", "Atilde", "Atildesmall", "B", "Beta", "Brevesmall", "Bsmall", "C", "Cacute", "Caron", "Caronsmall", "Ccaron", "Ccedilla", "Ccedillasmall", "Ccircumflex", "Cdotaccent", "Cedillasmall", "Chi", "Circumflexsmall", "Csmall", "D", "Dcaron", "Dcroat", "Delta", "Delta", "Dieresis", "DieresisAcute", "DieresisGrave", "Dieresissmall", "Dotaccentsmall", "Dsmall", "E", "Eacute", "Eacutesmall", "Ebreve", "Ecaron", "Ecircumflex", "Ecircumflexsmall", "Edieresis", "Edieresissmall", "Edotaccent", "Egrave", "Egravesmall", "Emacron", "Eng", "Eogonek", "Epsilon", "Epsilontonos", "Esmall", "Eta", "Etatonos", "Eth", "Ethsmall", "Euro", "F", "Fsmall", "G", "Gamma", "Gbreve", "Gcaron", "Gcircumflex", "Gcommaaccent", "Gdotaccent", "Grave", "Gravesmall", "Gsmall", "H", "H18533", "H18543", "H18551", "H22073", "Hbar", "Hcircumflex", "Hsmall", "Hungarumlaut", "Hungarumlautsmall", "I", "IJ", "Iacute", "Iacutesmall", "Ibreve", "Icircumflex", "Icircumflexsmall", "Idieresis", "Idieresissmall", "Idotaccent", "Ifraktur", "Igrave", "Igravesmall", "Imacron", "Iogonek", "Iota", "Iotadieresis", "Iotatonos", "Ismall", "Itilde", "J", "Jcircumflex", "Jsmall", "K", "Kappa", "Kcommaaccent", "Ksmall", "L", "LL", "Lacute", "Lambda", "Lcaron", "Lcommaaccent", "Ldot", "Lslash", "Lslashsmall", "Lsmall", "M", "Macron", "Macronsmall", "Msmall", "Mu", "N", "Nacute", "Ncaron", "Ncommaaccent", "Nsmall", "Ntilde", "Ntildesmall", "Nu", "O", "OE", "OEsmall", "Oacute", "Oacutesmall", "Obreve", "Ocircumflex", "Ocircumflexsmall", "Odieresis", "Odieresissmall", "Ogoneksmall", "Ograve", "Ogravesmall", "Ohorn", "Ohungarumlaut", "Omacron", "Omega", "Omega", "Omegatonos", "Omicron", "Omicrontonos", "Oslash", "Oslashacute", "Oslashsmall", "Osmall", "Otilde", "Otildesmall", "P", "Phi", "Pi", "Psi", "Psmall", "Q", "Qsmall", "R", "Racute", "Rcaron", "Rcommaaccent", "Rfraktur", "Rho", "Ringsmall", "Rsmall", "S", "SF010000", "SF020000", "SF030000", "SF040000", "SF050000", "SF060000", "SF070000", "SF080000", "SF090000", "SF100000", "SF110000", "SF190000", "SF200000", "SF210000", "SF220000", "SF230000", "SF240000", "SF250000", "SF260000", "SF270000", "SF280000", "SF360000", "SF370000", "SF380000", "SF390000", "SF400000", "SF410000", "SF420000", "SF430000", "SF440000", "SF450000", "SF460000", "SF470000", "SF480000", "SF490000", "SF500000", "SF510000", "SF520000", "SF530000", "SF540000", "Sacute", "Scaron", "Scaronsmall", "Scedilla", "Scedilla", "Scircumflex", "Scommaaccent", "Sigma", "Ssmall", "T", "Tau", "Tbar", "Tcaron", "Tcommaaccent", "Tcommaaccent", "Theta", "Thorn", "Thornsmall", "Tildesmall", "Tsmall", "U", "Uacute", "Uacutesmall", "Ubreve", "Ucircumflex", "Ucircumflexsmall", "Udieresis", "Udieresissmall", "Ugrave", "Ugravesmall", "Uhorn", "Uhungarumlaut", "Umacron", "Uogonek", "Upsilon", "Upsilon1", "Upsilondieresis", "Upsilontonos", "Uring", "Usmall", "Utilde", "V", "Vsmall", "W", "Wacute", "Wcircumflex", "Wdieresis", "Wgrave", "Wsmall", "X", "Xi", "Xsmall", "Y", "Yacute", "Yacutesmall", "Ycircumflex", "Ydieresis", "Ydieresissmall", "Ygrave", "Ysmall", "Z", "Zacute", "Zcaron", "Zcaronsmall", "Zdotaccent", "Zeta", "Zsmall", "a", "aacute", "abreve", "acircumflex", "acute", "acutecomb", "adieresis", "ae", "aeacute", "afii00208", "afii10017", "afii10018", "afii10019", "afii10020", "afii10021", "afii10022", "afii10023", "afii10024", "afii10025", "afii10026", "afii10027", "afii10028", "afii10029", "afii10030", "afii10031", "afii10032", "afii10033", "afii10034", "afii10035", "afii10036", "afii10037", "afii10038", "afii10039", "afii10040", "afii10041", "afii10042", "afii10043", "afii10044", "afii10045", "afii10046", "afii10047", "afii10048", "afii10049", "afii10050", "afii10051", "afii10052", "afii10053", "afii10054", "afii10055", "afii10056", "afii10057", "afii10058", "afii10059", "afii10060", "afii10061", "afii10062", "afii10063", "afii10064", "afii10065", "afii10066", "afii10067", "afii10068", "afii10069", "afii10070", "afii10071", "afii10072", "afii10073", "afii10074", "afii10075", "afii10076", "afii10077", "afii10078", "afii10079", "afii10080", "afii10081", "afii10082", "afii10083", "afii10084", "afii10085", "afii10086", "afii10087", "afii10088", "afii10089", "afii10090", "afii10091", "afii10092", "afii10093", "afii10094", "afii10095", "afii10096", "afii10097", "afii10098", "afii10099", "afii10100", "afii10101", "afii10102", "afii10103", "afii10104", "afii10105", "afii10106", "afii10107", "afii10108", "afii10109", "afii10110", "afii10145", "afii10146", "afii10147", "afii10148", "afii10192", "afii10193", "afii10194", "afii10195", "afii10196", "afii10831", "afii10832", "afii10846", "afii299", "afii300", "afii301", "afii57381", "afii57388", "afii57392", "afii57393", "afii57394", "afii57395", "afii57396", "afii57397", "afii57398", "afii57399", "afii57400", "afii57401", "afii57403", "afii57407", "afii57409", "afii57410", "afii57411", "afii57412", "afii57413", "afii57414", "afii57415", "afii57416", "afii57417", "afii57418", "afii57419", "afii57420", "afii57421", "afii57422", "afii57423", "afii57424", "afii57425", "afii57426", "afii57427", "afii57428", "afii57429", "afii57430", "afii57431", "afii57432", "afii57433", "afii57434", "afii57440", "afii57441", "afii57442", "afii57443", "afii57444", "afii57445", "afii57446", "afii57448", "afii57449", "afii57450", "afii57451", "afii57452", "afii57453", "afii57454", "afii57455", "afii57456", "afii57457", "afii57458", "afii57470", "afii57505", "afii57506", "afii57507", "afii57508", "afii57509", "afii57511", "afii57512", "afii57513", "afii57514", "afii57519", "afii57534", "afii57636", "afii57645", "afii57658", "afii57664", "afii57665", "afii57666", "afii57667", "afii57668", "afii57669", "afii57670", "afii57671", "afii57672", "afii57673", "afii57674", "afii57675", "afii57676", "afii57677", "afii57678", "afii57679", "afii57680", "afii57681", "afii57682", "afii57683", "afii57684", "afii57685", "afii57686", "afii57687", "afii57688", "afii57689", "afii57690", "afii57694", "afii57695", "afii57700", "afii57705", "afii57716", "afii57717", "afii57718", "afii57723", "afii57793", "afii57794", "afii57795", "afii57796", "afii57797", "afii57798", "afii57799", "afii57800", "afii57801", "afii57802", "afii57803", "afii57804", "afii57806", "afii57807", "afii57839", "afii57841", "afii57842", "afii57929", "afii61248", "afii61289", "afii61352", "afii61573", "afii61574", "afii61575", "afii61664", "afii63167", "afii64937", "agrave", "aleph", "alpha", "alphatonos", "amacron", "ampersand", "ampersandsmall", "angle", "angleleft", "angleright", "anoteleia", "aogonek", "approxequal", "aring", "aringacute", "arrowboth", "arrowdblboth", "arrowdbldown", "arrowdblleft", "arrowdblright", "arrowdblup", "arrowdown", "arrowhorizex", "arrowleft", "arrowright", "arrowup", "arrowupdn", "arrowupdnbse", "arrowvertex", "asciicircum", "asciitilde", "asterisk", "asteriskmath", "asuperior", "at", "atilde", "b", "backslash", "bar", "beta", "block", "braceex", "braceleft", "braceleftbt", "braceleftmid", "bracelefttp", "braceright", "bracerightbt", "bracerightmid", "bracerighttp", "bracketleft", "bracketleftbt", "bracketleftex", "bracketlefttp", "bracketright", "bracketrightbt", "bracketrightex", "bracketrighttp", "breve", "brokenbar", "bsuperior", "bullet", "c", "cacute", "caron", "carriagereturn", "ccaron", "ccedilla", "ccircumflex", "cdotaccent", "cedilla", "cent", "centinferior", "centoldstyle", "centsuperior", "chi", "circle", "circlemultiply", "circleplus", "circumflex", "club", "colon", "colonmonetary", "comma", "commaaccent", "commainferior", "commasuperior", "congruent", "copyright", "copyrightsans", "copyrightserif", "currency", "cyrBreve", "cyrFlex", "cyrbreve", "cyrflex", "d", "dagger", "daggerdbl", "dblGrave", "dblgrave", "dcaron", "dcroat", "degree", "delta", "diamond", "dieresis", "dieresisacute", "dieresisgrave", "dieresistonos", "divide", "dkshade", "dnblock", "dollar", "dollarinferior", "dollaroldstyle", "dollarsuperior", "dong", "dotaccent", "dotbelowcomb", "dotlessi", "dotlessj", "dotmath", "dsuperior", "e", "eacute", "ebreve", "ecaron", "ecircumflex", "edieresis", "edotaccent", "egrave", "eight", "eightinferior", "eightoldstyle", "eightsuperior", "element", "ellipsis", "emacron", "emdash", "emptyset", "endash", "eng", "eogonek", "epsilon", "epsilontonos", "equal", "equivalence", "estimated", "esuperior", "eta", "etatonos", "eth", "exclam", "exclamdbl", "exclamdown", "exclamdownsmall", "exclamsmall", "existential", "f", "female", "ff", "ffi", "ffl", "fi", "figuredash", "filledbox", "filledrect", "five", "fiveeighths", "fiveinferior", "fiveoldstyle", "fivesuperior", "fl", "florin", "four", "fourinferior", "fouroldstyle", "foursuperior", "fraction", "fraction", "franc", "g", "gamma", "gbreve", "gcaron", "gcircumflex", "gcommaaccent", "gdotaccent", "germandbls", "gradient", "grave", "gravecomb", "greater", "greaterequal", "guillemotleft", "guillemotright", "guilsinglleft", "guilsinglright", "h", "hbar", "hcircumflex", "heart", "hookabovecomb", "house", "hungarumlaut", "hyphen", "softhyphen", "hyphentwo", "hypheninferior", "hyphensuperior", "i", "iacute", "ibreve", "icircumflex", "idieresis", "igrave", "ij", "imacron", "infinity", "integral", "integralbt", "integralex", "integraltp", "intersection", "invbullet", "invcircle", "invsmileface", "iogonek", "iota", "iotadieresis", "iotadieresistonos", "iotatonos", "isuperior", "itilde", "j", "jcircumflex", "k", "kappa", "kcommaaccent", "kgreenlandic", "l", "lacute", "lambda", "lcaron", "lcommaaccent", "ldot", "less", "lessequal", "lfblock", "lira", "ll", "logicaland", "logicalnot", "logicalor", "longs", "lozenge", "lslash", "lsuperior", "ltshade", "m", "macron", "macron", "male", "minus", "minute", "msuperior", "mu", "mu", "multiply", "musicalnote", "musicalnotedbl", "n", "nacute", "napostrophe", "ncaron", "ncommaaccent", "nine", "nineinferior", "nineoldstyle", "ninesuperior", "notelement", "notequal", "notsubset", "nsuperior", "ntilde", "nu", "numbersign", "o", "oacute", "obreve", "ocircumflex", "odieresis", "oe", "ogonek", "ograve", "ohorn", "ohungarumlaut", "omacron", "omega", "omega1", "omegatonos", "omicron", "omicrontonos", "one", "onedotenleader", "oneeighth", "onefitted", "onehalf", "oneinferior", "oneoldstyle", "onequarter", "onesuperior", "onethird", "openbullet", "ordfeminine", "ordmasculine", "orthogonal", "oslash", "oslashacute", "osuperior", "otilde", "p", "paragraph", "parenleft", "parenleftbt", "parenleftex", "parenleftinferior", "parenleftsuperior", "parenlefttp", "parenright", "parenrightbt", "parenrightex", "parenrightinferior", "parenrightsuperior", "parenrighttp", "partialdiff", "percent", "period", "middot", "periodcentered", "periodinferior", "periodsuperior", "perpendicular", "perthousand", "peseta", "phi", "phi1", "pi", "plus", "plusminus", "prescription", "product", "propersubset", "propersuperset", "proportional", "psi", "q", "question", "questiondown", "questiondownsmall", "questionsmall", "quotedbl", "quotedblbase", "quotedblleft", "quotedblright", "quoteleft", "quotereversed", "quoteright", "quotesinglbase", "quotesingle", "r", "racute", "radical", "radicalex", "rcaron", "rcommaaccent", "reflexsubset", "reflexsuperset", "registered", "registersans", "registerserif", "revlogicalnot", "rho", "ring", "rsuperior", "rtblock", "rupiah", "s", "sacute", "scaron", "scedilla", "scedilla", "scircumflex", "scommaaccent", "second", "section", "semicolon", "seven", "seveneighths", "seveninferior", "sevenoldstyle", "sevensuperior", "shade", "sigma", "sigma1", "similar", "six", "sixinferior", "sixoldstyle", "sixsuperior", "slash", "smileface", "space", "space", "spade", "ssuperior", "sterling", "suchthat", "summation", "sun", "t", "tau", "tbar", "tcaron", "tcommaaccent", "tcommaaccent", "therefore", "theta", "theta1", "thorn", "three", "threeeighths", "threeinferior", "threeoldstyle", "threequarters", "threequartersemdash", "threesuperior", "tilde", "tildecomb", "tonos", "trademark", "trademarksans", "trademarkserif", "triagdn", "triaglf", "triagrt", "triagup", "tsuperior", "two", "twodotenleader", "twoinferior", "twooldstyle", "twosuperior", "twothirds", "u", "uacute", "ubreve", "ucircumflex", "udieresis", "ugrave", "uhorn", "uhungarumlaut", "umacron", "underscore", "underscoredbl", "union", "universal", "uogonek", "upblock", "upsilon", "upsilondieresis", "upsilondieresistonos", "upsilontonos", "uring", "utilde", "v", "w", "wacute", "wcircumflex", "wdieresis", "weierstrass", "wgrave", "x", "xi", "y", "yacute", "ycircumflex", "ydieresis", "yen", "ygrave", "z", "zacute", "zcaron", "zdotaccent", "zero", "zeroinferior", "zerooldstyle", "zerosuperior", "zeta"};
    }
}

