/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decrypt;

import com.inet.pdfview.decrypt.PDFDecrypter;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.util.Arrays;
import javax.annotation.SuppressFBWarnings;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DecrypterAES256_Rev5and6
extends PDFDecrypter {
    private static final Charset ENC = StandardCharsets.ISO_8859_1;
    private String userPassword;
    private String uValue;
    private String ueValue;
    private String oeValue;
    private String oValue;
    private byte[] decrypKey;
    private int handlerRevision;

    DecrypterAES256_Rev5and6(String userPassword, String ownerValue, String userValue, String userEntryValue, String ownerEntryValue, int permission, byte[] docIdData, int keyLength, int handlerRevision, boolean isMetadataEncrypted) {
        super(userPassword, ownerValue.getBytes(), permission, docIdData, keyLength, 5, handlerRevision, isMetadataEncrypted);
        this.userPassword = userPassword;
        this.oValue = ownerValue;
        this.uValue = userValue;
        this.ueValue = userEntryValue;
        this.oeValue = ownerEntryValue;
        this.handlerRevision = handlerRevision;
        try {
            this.decrypKey = this.checkPassword();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (this.decrypKey == null) {
            throw new PDFDecrypter.DecryptionExcpetion(null, true);
        }
    }

    @SuppressFBWarnings(value={"CIPHER_INTEGRITY", "UNSAFE_HASH_EQUALS"}, justification="reading existing files")
    private byte[] checkPassword() throws Exception {
        byte[] password;
        byte[] hash;
        if (this.oValue.length() < 48) {
            return null;
        }
        byte[] oAsBytes = this.oValue.getBytes(ENC);
        byte[] oHashValue = Arrays.copyOf(oAsBytes, 32);
        byte[] oValidationSalt = Arrays.copyOfRange(oAsBytes, 32, 40);
        byte[] oKeySalt = Arrays.copyOfRange(oAsBytes, 40, 48);
        byte[] uAsBytes = this.uValue.getBytes(ENC);
        byte[] uHashValue = Arrays.copyOf(uAsBytes, 32);
        byte[] uValidationSalt = Arrays.copyOfRange(uAsBytes, 32, 40);
        byte[] uKeySalt = Arrays.copyOfRange(uAsBytes, 40, 48);
        String normPW = Normalizer.normalize(this.userPassword, Normalizer.Form.NFKC);
        if (normPW.length() > 127) {
            normPW.substring(0, 127);
        }
        if (Arrays.equals(hash = this.createPasswordHash(password = normPW.getBytes(), oValidationSalt, uAsBytes), oHashValue)) {
            hash = this.createPasswordHash(password, oKeySalt, uAsBytes);
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(hash, "AES"), new IvParameterSpec(new byte[16]));
            return cipher.doFinal(this.oeValue.getBytes(ENC));
        }
        hash = this.createPasswordHash(password, uValidationSalt, null);
        if (Arrays.equals(hash, uHashValue)) {
            hash = this.createPasswordHash(password, uKeySalt, null);
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(hash, "AES"), new IvParameterSpec(new byte[16]));
            return cipher.doFinal(this.ueValue.getBytes(ENC));
        }
        return null;
    }

    private byte[] createPasswordHash(byte[] password, byte[] salt, byte[] userKey) throws Exception {
        if (this.handlerRevision == 5) {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(this.concat(password, salt, userKey));
        }
        return this.algorithm2B(password, salt, userKey);
    }

    private byte[] concat(byte[] ... parts) {
        int len = 0;
        for (byte[] part : parts) {
            if (part == null) continue;
            len += part.length;
        }
        byte[] result = new byte[len];
        int offset = 0;
        for (byte[] part : parts) {
            if (part == null) continue;
            System.arraycopy(part, 0, result, offset, part.length);
            offset += part.length;
        }
        return result;
    }

    @SuppressFBWarnings(value={"CIPHER_INTEGRITY", "STATIC_IV"}, justification="reading existing files")
    private byte[] algorithm2B(byte[] password, byte[] salt, byte[] userKey) throws Exception {
        BigInteger three = new BigInteger("3");
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] k = digest.digest(this.concat(password, salt, userKey));
        if (userKey != null && userKey.length > 48) {
            userKey = Arrays.copyOf(userKey, 48);
        }
        byte[] e = null;
        for (int i = 0; i < 64 || (e[e.length - 1] & 0xFF) > i - 32; ++i) {
            int singleLength = password.length + k.length + (userKey != null ? userKey.length : 0);
            byte[] k1 = new byte[64 * singleLength];
            for (int j = 0; j < 64; ++j) {
                System.arraycopy(password, 0, k1, singleLength * j, password.length);
                System.arraycopy(k, 0, k1, singleLength * j + password.length, k.length);
                if (userKey == null) continue;
                System.arraycopy(userKey, 0, k1, singleLength * j + password.length + k.length, userKey.length);
            }
            Cipher aes = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key = new SecretKeySpec(Arrays.copyOf(k, 16), "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(k, 16, 32));
            aes.init(1, (Key)key, iv);
            e = aes.doFinal(k1);
            BigInteger bi = new BigInteger(1, Arrays.copyOf(e, 16));
            int remainder = bi.mod(three).intValue();
            String shaType = remainder == 0 ? "SHA-256" : (remainder == 1 ? "SHA-384" : "SHA-512");
            digest = MessageDigest.getInstance(shaType);
            k = digest.digest(e);
        }
        return Arrays.copyOf(k, 32);
    }

    @Override
    public byte[] decrypt(byte[] bytes, int length, int objNum, int revNum) throws RuntimeException {
        byte[] currentKey = this.decrypKey;
        try {
            return this.decrypt(bytes, length, currentKey, false);
        }
        catch (IllegalBlockSizeException e) {
            try {
                return this.decrypt(bytes, length, currentKey, true);
            }
            catch (Exception e1) {
                throw new PDFDecrypter.DecryptionExcpetion(e1, this.userPassword != null && !this.userPassword.isEmpty());
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException e) {
            throw new PDFDecrypter.DecryptionExcpetion(e, this.userPassword != null && !this.userPassword.isEmpty());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    byte[] decrypt(byte[] initVectorAndEncryptedData, int length, byte[] currentKey, boolean noPadding) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher mainCipher = Cipher.getInstance("AES/CBC/" + (noPadding ? "NoPadding" : "PKCS5Padding"));
        byte[] iv = new byte[16];
        System.arraycopy(initVectorAndEncryptedData, 0, iv, 0, iv.length);
        int copyLength = initVectorAndEncryptedData.length - iv.length;
        int arrayLength = noPadding ? (copyLength + 15) / 16 * 16 : copyLength;
        byte[] encrypted = new byte[arrayLength];
        System.arraycopy(initVectorAndEncryptedData, iv.length, encrypted, 0, copyLength);
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        SecretKeySpec fileDecryptionKey = new SecretKeySpec(currentKey, "AES");
        mainCipher.init(2, (Key)fileDecryptionKey, paramSpec);
        byte[] res = mainCipher.doFinal(encrypted);
        return res;
    }

    @Override
    byte[] computeObjectEncryptionKey(int objNum, int revNum) {
        return this.decrypKey;
    }
}

