/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode;

import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.Predictor;
import com.inet.pdfview.error.PDFParseException;

public class TIFFPredictor
extends Predictor {
    public TIFFPredictor() {
        super(0);
    }

    @Override
    public IDataBuffer unpredict(IDataBuffer imageData) throws PDFParseException {
        if (this.getBitsPerComponent() != 8) {
            throw new PDFParseException("TIFF Predictor supported with 8 bits-per-component only");
        }
        int columnCount = this.getColumns();
        int componentCount = this.getColors();
        int rowSize = columnCount * componentCount;
        byte[] rowBuffer = new byte[rowSize];
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        while (imageData.remaining() >= rowSize) {
            imageData.get(rowBuffer);
            for (int i = 1; i < columnCount; ++i) {
                for (int k = 0; k < componentCount; ++k) {
                    int n = i * componentCount + k;
                    rowBuffer[n] = (byte)(rowBuffer[n] + rowBuffer[(i - 1) * componentCount + k]);
                }
            }
            bos.write(rowBuffer);
        }
        return ArrayBuffer.wrap(bos.toByteArray());
    }
}

