/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode;

import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.error.PDFParseException;
import java.io.ByteArrayOutputStream;

public class RLDecode {
    private IDataBuffer buf;

    private RLDecode(IDataBuffer buf) {
        this.buf = buf;
    }

    public static IDataBuffer decode(IDataBuffer buf) throws PDFParseException {
        RLDecode dec = new RLDecode(buf);
        return dec.decode();
    }

    private IDataBuffer decode() throws PDFParseException {
        int count;
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        this.buf.rewind();
        while (this.buf.remaining() > 0 && (count = this.buf.get() & 0xFF) != 128) {
            if (count < 128) {
                if (this.buf.remaining() < count + 1) {
                    throw new PDFParseException("Invalid parameter in Run Length Compression: " + count + " >= " + this.buf.remaining());
                }
                for (int i = 0; i <= count; ++i) {
                    res.write(this.buf.get());
                }
                continue;
            }
            count = 257 - count;
            byte b = this.buf.get();
            for (int i = 0; i < count; ++i) {
                res.write(b);
            }
        }
        IDataBuffer resBuf = ArrayBuffer.wrap(res.toByteArray());
        return resBuf;
    }
}

