/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.Predictor;
import com.inet.pdfview.error.PDFParseException;
import java.io.ByteArrayOutputStream;

public class LZWDecode {
    private IDataBuffer buf;
    private int bytepos;
    private int bitpos;
    private byte[][] dict = new byte[4096][];
    private int dictlen = 0;
    private int bitspercode = 9;
    private static int STOP = 257;
    private static int CLEARDICT = 256;

    public LZWDecode(IDataBuffer buf) {
        this.buf = buf;
        for (int i = 0; i < 256; ++i) {
            this.dict[i] = new byte[1];
            this.dict[i][0] = (byte)i;
        }
        this.dictlen = 258;
        this.bitspercode = 9;
        this.bytepos = 0;
        this.bitpos = 0;
    }

    private void resetDict() {
        this.dictlen = 258;
        this.bitspercode = 9;
    }

    private void increaseDict() {
        byte[][] dictBuff = new byte[this.dict.length * 4][];
        System.arraycopy(this.dict, 0, dictBuff, 0, this.dict.length);
        this.dict = dictBuff;
    }

    private int nextCode() {
        int fillbits = this.bitspercode;
        int value = 0;
        if (this.bytepos >= this.buf.limit() - 1) {
            return -1;
        }
        while (fillbits > 0) {
            byte nextbits = this.buf.get(this.bytepos);
            int bitsfromhere = 8 - this.bitpos;
            if (bitsfromhere > fillbits) {
                bitsfromhere = fillbits;
            }
            value |= (nextbits >> 8 - this.bitpos - bitsfromhere & 255 >> 8 - bitsfromhere) << fillbits - bitsfromhere;
            fillbits -= bitsfromhere;
            this.bitpos += bitsfromhere;
            if (this.bitpos < 8) continue;
            this.bitpos = 0;
            ++this.bytepos;
        }
        return value;
    }

    public IDataBuffer decode(int earlyChange) throws PDFParseException {
        int cW = CLEARDICT;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean ec = earlyChange == 0;
        while (true) {
            int pW = cW;
            cW = this.nextCode();
            if (ec && this.dictlen >= (1 << this.bitspercode) - 1 && this.bitspercode < 12) {
                ++this.bitspercode;
            }
            if (cW == -1 || cW == STOP) break;
            if (cW == CLEARDICT) {
                this.resetDict();
                continue;
            }
            if (pW == CLEARDICT) {
                baos.write(this.dict[cW], 0, this.dict[cW].length);
                continue;
            }
            if (pW >= this.dictlen) {
                throw new PDFParseException("Attempt to access a point outside the image raster");
            }
            byte[] p = new byte[this.dict[pW].length + 1];
            if (cW < this.dictlen) {
                baos.write(this.dict[cW], 0, this.dict[cW].length);
                System.arraycopy(this.dict[pW], 0, p, 0, this.dict[pW].length);
                p[this.dict[pW].length] = this.dict[cW][0];
            } else {
                System.arraycopy(this.dict[pW], 0, p, 0, this.dict[pW].length);
                p[this.dict[pW].length] = p[0];
                baos.write(p, 0, p.length);
            }
            if (this.dictlen + 1 > this.dict.length) {
                this.increaseDict();
            }
            this.dict[this.dictlen++] = p;
            if (ec || this.dictlen < (1 << this.bitspercode) - 1 || this.bitspercode >= 12) continue;
            ++this.bitspercode;
        }
        return ArrayBuffer.wrap(baos.toByteArray());
    }

    public static IDataBuffer decode(IDataBuffer buf, PDFObject params) throws PDFParseException {
        Predictor predictor;
        PDFObject ec;
        LZWDecode me = new LZWDecode(buf);
        int earlyChange = 1;
        if (params != null && (ec = params.getDictRef("EarlyChange")) != null && ec.getType() == 2) {
            earlyChange = ec.getIntValue();
        }
        IDataBuffer outBytes = me.decode(earlyChange);
        if (params != null && params.getDictionary().containsKey("Predictor") && (predictor = Predictor.getPredictor(params)) != null) {
            outBytes = predictor.unpredict(outBytes);
        }
        return outBytes;
    }
}

