/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode;

import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.Predictor;
import com.inet.pdfview.error.PDFParseException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;

public class FlateDecode {
    private static final int SHORTENING_CAP = 8;

    public static IDataBuffer decode(IDataBuffer buf, PDFObject params) throws PDFParseException {
        Predictor predictor;
        boolean hasPredictor;
        buf = buf.duplicate();
        int limit = buf.limit();
        FastByteArrayOutputStream baos = null;
        int shortening = 0;
        do {
            try {
                buf.limit(limit - shortening);
                baos = FlateDecode.inflate(buf, false);
            }
            catch (PDFParseException e) {
                buf.rewind();
                if (++shortening <= 8) continue;
                throw e;
            }
        } while (baos == null && shortening <= 8);
        if (baos == null) {
            buf.limit(limit);
            baos = FlateDecode.inflate(buf, true);
        }
        IDataBuffer outBytes = ArrayBuffer.wrap(baos.toByteArray());
        boolean bl = hasPredictor = params != null && params.getDictionary().containsKey("Predictor");
        if (hasPredictor && (predictor = Predictor.getPredictor(params)) != null) {
            outBytes = predictor.unpredict(outBytes);
        }
        return outBytes;
    }

    protected static FastByteArrayOutputStream inflate(IDataBuffer buf, boolean allowPartial) throws PDFParseException {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        FastByteArrayOutputStream baos2 = null;
        Inflater inf = new Inflater(true);
        InflaterOutputStream infOut = new InflaterOutputStream((OutputStream)baos, inf);
        try {
            byte[] buffer = new byte[16384];
            buf.getShort();
            while (buf.remaining() > buffer.length) {
                buf.get(buffer);
                infOut.write(buffer);
            }
            if (buf.remaining() > 0) {
                buffer = new byte[buf.remaining()];
                buf.get(buffer);
                infOut.write(buffer);
            }
            if (inf.needsDictionary()) {
                throw new PDFParseException("Don't know how to ask for a dictionary in FlateDecode");
            }
        }
        catch (IOException dfe) {
            buf.rewind();
            buf.getShort();
            baos2 = new FastByteArrayOutputStream();
            inf = new Inflater(false);
            infOut = new InflaterOutputStream((OutputStream)baos2, inf);
            try {
                byte[] buffer = new byte[16384];
                while (buf.remaining() > buffer.length) {
                    buf.get(buffer);
                    infOut.write(buffer);
                }
                if (buf.remaining() > 0) {
                    buffer = new byte[buf.remaining()];
                    buf.get(buffer);
                    infOut.write(buffer);
                }
                if (inf.needsDictionary()) {
                    throw new PDFParseException("Don't know how to ask for a dictionary in FlateDecode");
                }
            }
            catch (IOException dfe2) {
                buf.rewind();
                byte[] data = new byte[Math.min(100, buf.remaining())];
                buf.get(data);
                if (!allowPartial || baos.size() == 0 && baos2.size() == 0) {
                    throw new PDFParseException(dfe.getMessage() + ", debug Data: " + Arrays.toString(data), dfe);
                }
                PDFParser.LOGGER.warn((Object)dfe);
            }
        }
        return baos.size() > 0 || baos2 == null ? baos : baos2;
    }
}

