/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode;

import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.ccitt.CCITTFaxG31DDecodeInputStream;
import com.inet.pdfview.decode.ccitt.FillOrderChangeInputStream;
import com.inet.pdfview.decode.ccitt.TIFFFaxDecoder;
import com.inet.pdfview.error.PDFParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CCITTDecode {
    private IDataBuffer buf;

    public CCITTDecode(IDataBuffer buf) {
        this.buf = buf;
    }

    protected static IDataBuffer decode(PDFObject dict, IDataBuffer buf, PDFObject params) throws PDFParseException {
        PDFObject encodedByteAlignObj;
        PDFObject obj;
        PDFObject height;
        PDFObject cols;
        CCITTDecode me = new CCITTDecode(buf);
        int len = 1728;
        int rows = -1;
        PDFObject pDFObject = cols = params != null ? params.getDictRef("Columns") : null;
        if (cols != null) {
            len = cols.getIntValue();
        }
        if ((height = dict.getDictRef("Height")) != null) {
            rows = height.getIntValue();
        }
        boolean blackIs1 = false;
        PDFObject pDFObject2 = obj = params != null ? params.getDictRef("BlackIs1") : null;
        if (obj != null) {
            blackIs1 = obj.getBooleanValue();
        }
        boolean encodedByteAlign = false;
        PDFObject pDFObject3 = encodedByteAlignObj = params != null ? params.getDictRef("EncodedByteAlign") : null;
        if (encodedByteAlignObj != null) {
            encodedByteAlign = encodedByteAlignObj.getBooleanValue();
        }
        int k = 0;
        if (params != null && (obj = params.getDictRef("K")) != null) {
            k = obj.getIntValue();
        }
        return me.doDecode(len, rows, k, encodedByteAlign, blackIs1);
    }

    private IDataBuffer doDecode(int cols, int rows, int k, boolean encodedByteAlign, boolean blackis1) throws PDFParseException {
        int arraySize = (cols + 7) / 8 * rows;
        TIFFFaxDecoder faxDecoder = new TIFFFaxDecoder(1, cols, rows);
        long tiffOptions = 0L;
        byte[] compressed = new byte[this.buf.limit()];
        this.buf.get(compressed);
        byte[] decompressed = null;
        if (k == 0) {
            try {
                InputStream in = new CCITTFaxG31DDecodeInputStream((InputStream)new FastByteArrayInputStream(compressed), cols, rows, encodedByteAlign);
                in = new FillOrderChangeInputStream(in);
                decompressed = this.toByteArray(in);
                in.close();
            }
            catch (IOException ex) {
                throw PDFParseException.create(ex);
            }
        } else if (k > 0) {
            decompressed = new byte[arraySize];
            faxDecoder.decode2D(decompressed, compressed, 0, rows, tiffOptions);
        } else if (k < 0) {
            decompressed = new byte[arraySize];
            faxDecoder.decodeT6(decompressed, compressed, 0, rows, tiffOptions, encodedByteAlign);
        }
        if (!blackis1) {
            CCITTDecode.invertBitmap(decompressed);
        }
        return ArrayBuffer.wrap(decompressed);
    }

    private static void invertBitmap(byte[] bufferData) {
        int c = bufferData.length;
        for (int i = 0; i < c; ++i) {
            bufferData[i] = (byte)(~bufferData[i] & 0xFF);
        }
    }

    private byte[] toByteArray(InputStream in) throws IOException {
        return IOFunctions.readBytes((InputStream)in);
    }

    private long copy(InputStream input, OutputStream output) throws IOException {
        return IOFunctions.copyData((InputStream)input, (OutputStream)output);
    }
}

