/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.data;

import com.inet.pdfview.data.IDataBuffer;
import java.nio.ByteBuffer;

public class ArrayBuffer
implements IDataBuffer {
    private ByteBuffer buffer;

    private ArrayBuffer(byte[] data) {
        this.buffer = ByteBuffer.wrap(data);
    }

    private ArrayBuffer(byte[] data, int offset, int length) {
        this.buffer = ByteBuffer.wrap(data, offset, length);
    }

    private ArrayBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public static IDataBuffer wrap(byte[] data, int offset, int length) {
        return new ArrayBuffer(data, offset, length);
    }

    public static IDataBuffer wrap(byte[] data) {
        return new ArrayBuffer(data);
    }

    public static IDataBuffer allocate(int size) {
        return new ArrayBuffer(new byte[size]);
    }

    @Override
    public final IDataBuffer rewind() {
        this.buffer.rewind();
        return this;
    }

    @Override
    public final int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public final int position() {
        return this.buffer.position();
    }

    @Override
    public final IDataBuffer position(int newPosition) {
        this.buffer.position(newPosition);
        return this;
    }

    @Override
    public IDataBuffer get(byte[] dst) {
        this.buffer.get(dst);
        return this;
    }

    @Override
    public final int limit() {
        return this.buffer.limit();
    }

    @Override
    public byte get() {
        return this.buffer.get();
    }

    @Override
    public byte get(int index) {
        return this.buffer.get(index);
    }

    @Override
    public final IDataBuffer limit(int newLimit) {
        this.buffer.limit(newLimit);
        return this;
    }

    @Override
    public IDataBuffer duplicate() {
        return new ArrayBuffer(this.buffer.duplicate());
    }

    @Override
    public short getShort() {
        return this.buffer.getShort();
    }

    @Override
    public final int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public final IDataBuffer mark() {
        this.buffer.mark();
        return this;
    }

    @Override
    public final IDataBuffer reset() {
        this.buffer.reset();
        return this;
    }

    @Override
    public ArrayBuffer slice() {
        return new ArrayBuffer(this.buffer.slice());
    }

    @Override
    public int getInt() {
        return this.buffer.getInt();
    }

    @Override
    public long getLong() {
        return this.buffer.getLong();
    }

    @Override
    public final boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @Override
    public final byte[] array() {
        return this.buffer.array();
    }

    @Override
    public final int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final IDataBuffer flip() {
        this.buffer.flip();
        return this;
    }

    @Override
    public IDataBuffer put(byte[] src) {
        this.buffer.put(src);
        return this;
    }

    @Override
    public char getChar(int index) {
        return this.buffer.getChar(index);
    }

    public ByteBuffer getInternalBuffer() {
        return this.buffer;
    }

    @Override
    public char getChar() {
        return this.buffer.getChar();
    }

    @Override
    public void close() {
        this.buffer = null;
    }
}

