/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.command;

import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.PDFTextFormat;
import com.inet.pdfview.ParserListener;
import com.inet.pdfview.command.PDFCmd;
import com.inet.pdfview.command.PDFCompositeCmd;
import com.inet.pdfview.command.PDFDrawTextCmds;
import com.inet.pdfview.font.CharCharMap;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class PDFDrawTextCmd
extends PDFCmd {
    private PDFTextFormat textFormat;
    private String text;
    private AffineTransform textTransform;
    private double[] charWidths;
    private double[] kerning;
    private boolean isTwoBytes;
    private boolean isAlreadyTwoBytePerChars;
    private boolean rendering;
    private ParserListener listener;

    public PDFDrawTextCmd(PDFTextFormat textFormat, PDFTextFormat.TextWrapper textWrapper, boolean isHexadezimal, double[] charWidths, double[] kerning, boolean rendering) {
        this.textFormat = textFormat;
        this.rendering = rendering;
        this.text = textWrapper.getText();
        this.isTwoBytes = isHexadezimal;
        this.textTransform = (AffineTransform)textFormat.getTransform().clone();
        this.charWidths = charWidths;
        this.kerning = kerning;
        this.isAlreadyTwoBytePerChars = textWrapper.isTwoByteChars();
        this.listener = textWrapper.getListener();
    }

    @Override
    public String toString() {
        PDFFont font = this.textFormat.getFont();
        return "DrawText{ text=" + font.decodeText((String)this.text, (boolean)this.isAlreadyTwoBytePerChars, (boolean)false).content + ", font=" + String.valueOf(this.textFormat.getFont()) + " }";
    }

    @Override
    public void execute(PDFRenderer renderer) {
        PDFFont font = this.textFormat.getFont();
        if (font.getAWTFont() == null) {
            return;
        }
        String decoded = font.decodeText((String)this.text, (boolean)this.isAlreadyTwoBytePerChars, (boolean)true).content;
        if (!this.rendering) {
            renderer.push();
            PDFCompositeCmd cmd = new PDFCompositeCmd("drawText");
            cmd.setAlphaFill(0.0f);
            cmd.setAlphaStroke(0.0f);
            cmd.execute(renderer);
        }
        renderer.drawString(font, decoded, this.textFormat.getExtendedMatrix(), this.textFormat.getCharSpacing() / this.textFormat.getFontSize(), this.isTwoBytes ? 0.0f : this.textFormat.getWordSpacing() / this.textFormat.getFontSize(), this.isVisible());
        if (!this.rendering) {
            renderer.pop();
        }
    }

    public static String getUnicodeString(PDFFontToUnicodeMap map, String string, boolean bigendian, boolean isAlreadyTwoByteChars, CharCharMap extraCharacters, @Nullable PDFFont font) {
        return PDFDrawTextCmd.getUnicodeStringDiff((PDFFontToUnicodeMap)map, (String)string, (boolean)bigendian, (boolean)isAlreadyTwoByteChars, (CharCharMap)extraCharacters, (PDFFont)font).content;
    }

    public static UnicodeConvertResult getUnicodeStringDiff(PDFFontToUnicodeMap map, String string, boolean bigendian, boolean isAlreadyTwoByteChars, CharCharMap extraCharacters, @Nullable PDFFont font) {
        if (map == null) {
            if (extraCharacters != null) {
                char[] chars = string.toCharArray();
                boolean change = false;
                for (int i = 0; i < chars.length; ++i) {
                    char replacement = extraCharacters.get(chars[i]);
                    if (replacement == '\uffff') continue;
                    chars[i] = replacement;
                    change = true;
                }
                if (change) {
                    string = new String(chars);
                }
            }
            return new UnicodeConvertResult(string, null);
        }
        if (map.getType() == 0) {
            boolean valid = true;
            ArrayList<PDFDrawTextCmds.ContentModification> changes = null;
            StringBuilder strBuilder = new StringBuilder(string.length());
            int[][] spaceRanges = map.getSpaceRanges();
            if (spaceRanges == null) {
                throw new IllegalArgumentException("space ranges not defined");
            }
            boolean isOneByteCode = map.hasCharacterCodes(1);
            boolean isTwoByteCode = map.hasCharacterCodes(2);
            if (isTwoByteCode && isOneByteCode) {
                isTwoByteCode = false;
                isOneByteCode = false;
            }
            if (isOneByteCode && isAlreadyTwoByteChars) {
                PDFParser.LOGGER.warn((Object)"Invalid character code byte count: 1");
            }
            for (int i = 0; i < string.length(); ++i) {
                char extra;
                char ch = string.charAt(i);
                if (extraCharacters != null && (extra = extraCharacters.get(ch)) != '\uffff') {
                    strBuilder.append(extra);
                    continue;
                }
                int adds = map.addUnicodeValues(ch, strBuilder, font);
                valid &= adds >= 0;
                if (Math.abs(adds) == 1) continue;
                if (changes == null) {
                    changes = new ArrayList<PDFDrawTextCmds.ContentModification>();
                }
                changes.add(new PDFDrawTextCmds.ContentModification(i, Math.abs(adds)));
            }
            if (changes != null) {
                Collections.sort(changes);
            }
            return new UnicodeConvertResult(strBuilder.toString(), changes, valid);
        }
        if (map.getType() == 4) {
            List<PDFDrawTextCmds.ContentModification> changes = null;
            StringBuilder strBuilder = new StringBuilder(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char ch = string.charAt(i);
                map.addUnicodeValues(ch, strBuilder, font);
            }
            return new UnicodeConvertResult(strBuilder.toString(), changes);
        }
        return new UnicodeConvertResult(string, null);
    }

    public String getText() {
        return this.text;
    }

    public PDFTextFormat getTextFormat() {
        return this.textFormat;
    }

    public boolean isAlreadyTwoBytePerChars() {
        return this.isAlreadyTwoBytePerChars;
    }

    public double[] getKerning() {
        return this.kerning;
    }

    public ParserListener getListener() {
        return this.listener;
    }

    public double[] getCharWidths() {
        return this.charWidths;
    }

    public boolean isTwoBytes() {
        return this.isTwoBytes;
    }

    public AffineTransform getTextTransform(PDFRenderer renderer) {
        AffineTransform at = new AffineTransform(this.textTransform);
        at.preConcatenate(renderer.getTransform());
        return at;
    }

    public static class UnicodeConvertResult {
        private final String content;
        private final List<PDFDrawTextCmds.ContentModification> changes;
        private final boolean isValidMapping;

        public UnicodeConvertResult(String content, List<PDFDrawTextCmds.ContentModification> changes) {
            this(content, changes, true);
        }

        public UnicodeConvertResult(String content, List<PDFDrawTextCmds.ContentModification> changes, boolean isValidMapping) {
            this.content = content;
            this.changes = changes;
            this.isValidMapping = isValidMapping;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isValidMapping() {
            return this.isValidMapping;
        }

        public List<PDFDrawTextCmds.ContentModification> getChanges() {
            return this.changes;
        }
    }
}

