/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.action;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.action.GoToAction;
import com.inet.pdfview.action.UriAction;
import com.inet.pdfview.error.PDFParseException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class PDFAction {
    private static final Set<String> KNOWN_ACTIONS = new HashSet<String>();
    private final String type;
    private PDFObject next;

    public PDFAction(String type) {
        this.type = type;
    }

    @Nullable
    public static PDFAction getAction(PDFObject obj, PDFObject root) throws PDFParseException {
        PDFObject typeObj = obj.getDictRef("S");
        if (typeObj == null) {
            PDFParser.LOGGER.error((Object)("No action type in object: " + String.valueOf(obj)));
            return null;
        }
        PDFAction action = null;
        String type = typeObj.getStringValue();
        if (type.equals("GoTo")) {
            action = new GoToAction(obj, root);
        } else if (type.equals("URI")) {
            action = new UriAction(obj);
        } else {
            if (KNOWN_ACTIONS.contains(type)) {
                PDFParser.LOGGER.debug((Object)("PDF Action type not supported: " + type));
            } else {
                PDFParser.LOGGER.error((Object)("Unknown PDF action type: " + type));
            }
            return null;
        }
        PDFObject nextObj = obj.getDictRef("Next");
        if (nextObj != null) {
            action.setNext(nextObj);
        }
        return action;
    }

    public String getType() {
        return this.type;
    }

    public PDFObject getNext() {
        return this.next;
    }

    public void setNext(PDFObject next) {
        this.next = next;
    }

    static {
        KNOWN_ACTIONS.add("GoTo");
        KNOWN_ACTIONS.add("GoToR");
        KNOWN_ACTIONS.add("GoToE");
        KNOWN_ACTIONS.add("Launch");
        KNOWN_ACTIONS.add("Thread");
        KNOWN_ACTIONS.add("URI");
        KNOWN_ACTIONS.add("Sound");
        KNOWN_ACTIONS.add("Movie");
        KNOWN_ACTIONS.add("Hide");
        KNOWN_ACTIONS.add("Named");
        KNOWN_ACTIONS.add("SubmitForm");
        KNOWN_ACTIONS.add("ResetForm");
        KNOWN_ACTIONS.add("ImportData");
        KNOWN_ACTIONS.add("JavaScript");
        KNOWN_ACTIONS.add("SetOCGState");
        KNOWN_ACTIONS.add("Rendition");
        KNOWN_ACTIONS.add("Trans");
        KNOWN_ACTIONS.add("GoTo3DView");
    }
}

