/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.cache.image.SerializableImage;
import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.control.ControlData;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.structure.StructureType;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ParserListener {
    public void startPage(PDFPage var1);

    public void addTextElement(PDFFont var1, float var2, AffineTransform var3, String var4, Paint var5, Paint var6, double[] var7, double[] var8, boolean var9, boolean var10);

    public void addShapeElement(boolean var1, int var2, Point2D var3, Shape var4, BasicStroke var5, Paint var6, Paint var7);

    public void addImageElement(SerializableImage var1, PDFImageMeta var2, AffineTransform var3, Shape var4, int var5, boolean var6);

    public void addAnnotationElement(PDFObject var1, PDFPage var2, PDFDecrypter var3, CacheAccess var4) throws PDFParseException;

    public void addControl(ControlData var1);

    public void setCrystalReportsExport(boolean var1);

    @Deprecated
    public void startStructureElement(@Nonnull StructureType var1);

    default public void startStructureElement(@Nonnull StructureType type, @Nullable String lang, @Nullable String alt, @Nullable String actualText) {
        this.startStructureElement(type);
    }

    public void endStructureElement(@Nonnull StructureType var1);

    default public boolean doRead(ELEMENT_TYPE type) {
        return true;
    }

    public static class PDFImageMeta {
        private TYPE type;
        private boolean hasAlpha;
        private String format;

        public PDFImageMeta() {
        }

        public PDFImageMeta(TYPE type, boolean hasAlpha, String format) {
            this.type = type;
            this.hasAlpha = hasAlpha;
            this.format = format;
        }

        public void setMetaData(PDFImageMeta metaData) {
            this.type = metaData.type;
            this.hasAlpha = metaData.hasAlpha;
            this.format = metaData.format;
        }

        public TYPE getType() {
            return this.type;
        }

        public boolean hasAlpha() {
            return this.hasAlpha;
        }

        public String getFormat() {
            return this.format;
        }

        public static enum TYPE {
            GRAY,
            RGB,
            CMYK,
            unknown;

        }
    }

    public static enum ELEMENT_TYPE {
        text,
        textNoCharMapping,
        shape,
        image,
        annotation,
        structure;

    }
}

