/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.pdfview.PDFPage;
import com.inet.pdfview.ParserListener;
import com.inet.pdfview.command.PDFDrawTextCmd;
import com.inet.pdfview.command.PDFDrawTextCmds;
import com.inet.pdfview.decrypt.NamedCharacterConverter;
import com.inet.pdfview.font.CIDFontType2;
import com.inet.pdfview.font.NullFont;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFGlyph;
import com.inet.pdfview.font.Type0Font;
import com.inet.pdfview.optionalcontent.VisibilityFlag;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.List;

public class PDFTextFormat
implements Cloneable {
    private static final PDFFont NULL_FONT = new NullFont("_NORESOURCE_");
    private float charSpacing = 0.0f;
    private float wordSpacing = 0.0f;
    private float horizontalScale = 1.0f;
    private float tl = 0.0f;
    private float tr = 0.0f;
    private int tm = 2;
    private AffineTransform cur;
    private AffineTransform line;
    private PDFFont font = NULL_FONT;
    private float fsize = 1.0f;
    private boolean isTwoBytes;
    private String actualText;
    private VisibilityFlag visibility;

    public PDFTextFormat(VisibilityFlag visibility) {
        this.visibility = visibility;
        this.cur = new AffineTransform();
        this.line = new AffineTransform();
        this.tr = 0.0f;
        this.wordSpacing = 0.0f;
        this.charSpacing = 0.0f;
        this.tm = 2;
        this.horizontalScale = 1.0f;
    }

    private PDFTextFormat() {
    }

    public void reset() {
        this.cur.setToIdentity();
        this.line.setToIdentity();
    }

    public void end() {
    }

    public float getCharSpacing() {
        return this.charSpacing;
    }

    public void setCharSpacing(float spc) {
        this.charSpacing = spc;
    }

    public float getWordSpacing() {
        return this.wordSpacing;
    }

    public float getEffectiveWordSpacing() {
        return this.isTwoBytes ? 0.0f : this.getWordSpacing();
    }

    public void setWordSpacing(float spc) {
        this.wordSpacing = spc;
    }

    public float getHorizontalScale() {
        return this.horizontalScale * 100.0f;
    }

    public void setHorizontalScale(float scl) {
        this.horizontalScale = scl / 100.0f;
    }

    public float getLeading() {
        return this.tl;
    }

    public void setLeading(float spc) {
        this.tl = spc;
    }

    public PDFFont getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fsize;
    }

    public void setFont(PDFFont f, float size) {
        this.font = f;
        this.fsize = size > -0.001f && size < 0.001f ? Math.max(1.0E-4f, Math.abs(size)) * Math.signum(size) : size;
    }

    public int getMode() {
        return this.tm;
    }

    public void setMode(int m) {
        int mode = 0;
        if ((m & 1) == 0) {
            mode |= 2;
        }
        if ((m & 4) != 0) {
            mode |= 4;
        }
        if ((m & 1 ^ (m & 2) >> 1) != 0) {
            mode |= 1;
        }
        this.tm = mode;
    }

    public void setTextFormatMode(int mode) {
        this.tm = mode;
    }

    public float getRise() {
        return this.tr;
    }

    public void setRise(float spc) {
        this.tr = spc;
    }

    public void carriageReturn() {
        this.carriageReturn(0.0f, -this.tl);
    }

    public void carriageReturn(float x, float y) {
        this.line.translate(x, y);
        this.cur.setTransform(this.line);
    }

    public AffineTransform getTransform() {
        return this.cur;
    }

    public void setMatrix(float[] m) {
        if (m[0] == 0.0f && m[1] == 0.0f || m[2] == 0.0f && m[3] == 0.0f) {
            if (m[0] == 0.0f && m[1] == 0.0f && m[2] == 0.0f && m[3] == 0.0f) {
                m[0] = 1.0f;
                m[3] = 1.0f;
            } else if (m[0] == 0.0f && m[1] == 0.0f) {
                m[0] = m[3];
                m[1] = -m[2];
            } else {
                m[3] = m[0];
                m[2] = -m[1];
            }
        }
        this.line = new AffineTransform(m);
        this.cur.setTransform(this.line);
    }

    public AffineTransform getExtendedMatrix() {
        AffineTransform fscale = new AffineTransform(this.fsize * this.horizontalScale, 0.0f, 0.0f, this.fsize, 0.0f, this.tr);
        AffineTransform at = new AffineTransform();
        at.setTransform(this.cur);
        at.concatenate(fscale);
        return at;
    }

    public void doText(PDFPage page, TextWrapper textWrapper, boolean isHexadezimal) {
        PDFDrawTextCmds commands = new PDFDrawTextCmds();
        this.doText(page, textWrapper, isHexadezimal, commands, 0.0, CHUNKTYPE.complete);
        commands.setActualText(this.actualText);
        commands.setIsVisible(this.visibility.isVisible());
        this.actualText = null;
        page.addCommand(commands);
    }

    public void doTextExt2(PDFPage page, Object[] array, boolean isHexadezimal, ParserListener listener) {
        PDFDrawTextCmds commands = new PDFDrawTextCmds();
        double shift = 0.0;
        Area clipCalculation = null;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] instanceof String) {
                String text = (String)array[i];
                TextWrapper textWrapper = new TextWrapper(text, false, listener);
                CHUNKTYPE t = array.length < 3 ? CHUNKTYPE.complete : (i < 2 ? CHUNKTYPE.first : (i == array.length - 1 ? CHUNKTYPE.last : CHUNKTYPE.mid));
                this.doText(page, textWrapper, isHexadezimal, commands, shift, t);
                if (commands.getClip() != null) {
                    if (clipCalculation == null) {
                        clipCalculation = new Area(commands.getClip());
                    } else {
                        clipCalculation.add(new Area(commands.getClip()));
                    }
                }
                shift = 0.0;
                continue;
            }
            if (!(array[i] instanceof Double)) continue;
            shift = -((Double)array[i]).doubleValue() / 1000.0;
            this.cur.translate(shift *= (double)(this.fsize * this.horizontalScale), 0.0);
            if (i != 0) continue;
            shift = 0.0;
        }
        commands.setActualText(this.actualText);
        commands.setIsVisible(this.visibility.isVisible());
        if (clipCalculation != null) {
            commands.setClip(clipCalculation);
        }
        this.actualText = null;
        page.addCommand(commands);
    }

    private double[] doText(PDFPage page, TextWrapper textWrapper, boolean isHexadezimal, PDFDrawTextCmds commands, double shift, CHUNKTYPE type) {
        PDFTextFormat cloned = (PDFTextFormat)this.clone();
        AffineTransform fscale = new AffineTransform(this.fsize * this.horizontalScale, 0.0f, 0.0f, this.fsize, 0.0f, this.tr);
        List<PDFGlyph> glyphList = this.font.getGlyphs(textWrapper);
        boolean bl = this.isTwoBytes = textWrapper.isTwoByteChars() || glyphList.size() * 2 == textWrapper.getLength();
        if (this.isTwoBytes) {
            textWrapper.transformToTwoByteText();
        }
        String text = textWrapper.getText();
        boolean renderViaAWTFont = this.isAWTFontRendering(this.getFont().decodeText(text, this.isTwoBytes, true).getContent());
        double[] chrWidths = new double[glyphList.size()];
        double[] kerning = new double[glyphList.size() > 0 ? glyphList.size() : 0];
        if (kerning.length > 0) {
            kerning[0] = shift + (double)(type.applyCharWidth ? this.charSpacing * this.horizontalScale : 0.0f);
        }
        int index = 0;
        AffineTransform at = new AffineTransform();
        Area clipArea = null;
        for (PDFGlyph glyph : glyphList) {
            Type0Font f;
            PDFFont desc;
            if (glyph != null) {
                at.setTransform(this.cur);
                at.concatenate(fscale);
                if (!renderViaAWTFont) {
                    int mode = this.getMode() & 3;
                    glyph.addCommands(page, at, mode);
                    if (this.getMode() > 3) {
                        if (clipArea == null) {
                            clipArea = new Area(glyph.getShape().createTransformedShape(at));
                        } else {
                            clipArea.add(new Area(glyph.getShape().createTransformedShape(at)));
                        }
                    }
                }
                Point2D advance = glyph.getAdvance();
                double wordSpace = (glyph.getChar() == ' ' ? this.getEffectiveWordSpacing() : 0.0f) * this.horizontalScale;
                double widthX = advance.getX() * (double)this.fsize * (double)this.horizontalScale + wordSpace;
                double charSpaceX = this.charSpacing * this.horizontalScale;
                if (index > 0) {
                    kerning[index] = charSpaceX + wordSpace;
                    chrWidths[index++] = widthX + charSpaceX;
                } else {
                    double spacing = shift + (type.applyCharWidth ? charSpaceX : 0.0);
                    kerning[index] = spacing + wordSpace;
                    chrWidths[index++] = widthX + spacing;
                }
                this.cur.translate(widthX + charSpaceX, advance.getY());
                continue;
            }
            if (this.font.getSubtype() == PDFFont.Subtype.Type0 && (desc = (f = (Type0Font)this.font).getDescendantFont(0)) instanceof CIDFontType2) {
                CIDFontType2 outlineFont = (CIDFontType2)desc;
                int defaultWidth = outlineFont.getDefaultWidth();
                double charWidth = outlineFont.getWidth(text.charAt(index), null);
                if (charWidth == 0.0) {
                    charWidth = (double)defaultWidth / 1000.0;
                }
                double advanceX = charWidth * (double)this.fsize + (double)this.charSpacing;
                double advanceY = 0.0;
                this.cur.translate(advanceX *= (double)this.horizontalScale, advanceY);
                chrWidths[index++] = advanceX;
                continue;
            }
            chrWidths[index++] = -1.0;
        }
        boolean lookForWidthData = false;
        for (int i = 0; i < chrWidths.length; ++i) {
            if (chrWidths[i] != -1.0) continue;
            lookForWidthData = true;
            break;
        }
        if (lookForWidthData) {
            Type0Font f;
            PDFFont desc;
            lookForWidthData = false;
            if (this.font.getSubtype() == PDFFont.Subtype.Type0 && (desc = (f = (Type0Font)this.font).getDescendantFont(0)) instanceof CIDFontType2) {
                int i;
                CIDFontType2 cidFont = (CIDFontType2)desc;
                int defaultWidth = cidFont.getDefaultWidth();
                for (i = 0; i < chrWidths.length; ++i) {
                    if (chrWidths[i] != -1.0 || i >= text.length()) continue;
                    char ch = text.charAt(i);
                    float charWidth = cidFont.getWidth(ch, null);
                    chrWidths[i] = charWidth != 0.0f ? (double)charWidth : (double)defaultWidth / 1000.0;
                }
                for (i = 0; i < chrWidths.length; ++i) {
                    chrWidths[i] = chrWidths[i] * (double)this.fsize + (double)this.charSpacing;
                    if (text.charAt(i) == ' ') {
                        int n = i;
                        chrWidths[n] = chrWidths[n] + (double)this.getEffectiveWordSpacing();
                    }
                    int n = i;
                    chrWidths[n] = chrWidths[n] * (double)this.horizontalScale;
                    if (!(this.fsize > 100.0f)) continue;
                    int n2 = i;
                    chrWidths[n2] = chrWidths[n2] / 20.0;
                }
            }
        }
        if (this.visibility.isVisible()) {
            PDFDrawTextCmd cmd = new PDFDrawTextCmd(cloned, textWrapper, isHexadezimal, chrWidths, kerning, renderViaAWTFont);
            cmd.setIsVisible(true);
            commands.addCommand(cmd);
        }
        if (clipArea != null) {
            commands.setClip(clipArea);
        }
        return chrWidths;
    }

    public void flush() {
    }

    public Object clone() {
        PDFTextFormat newFormat = new PDFTextFormat();
        newFormat.visibility = this.visibility;
        newFormat.setCharSpacing(this.getCharSpacing());
        newFormat.setWordSpacing(this.getWordSpacing());
        newFormat.setHorizontalScale(this.getHorizontalScale());
        newFormat.setLeading(this.getLeading());
        newFormat.setTextFormatMode(this.getMode());
        newFormat.setRise(this.getRise());
        newFormat.setFont(this.getFont(), this.getFontSize());
        newFormat.cur = new AffineTransform(this.cur);
        newFormat.line = new AffineTransform(this.line);
        return newFormat;
    }

    public boolean isAWTFontRendering(String text) {
        if (this.getMode() != 2 || this.font.getAWTFont() == null) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (!PDFTextFormat.isWhiteSpaceChar(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhiteSpaceChar(char chr) {
        return chr == '\t' || chr == '\n' || chr == '\r' || chr >= '\u200c' && (chr <= '\u200f' || chr >= '\u2028' && chr <= '\u202e' || chr >= '\u206a' && chr <= '\u206f');
    }

    public void setActualText(String actualText) {
        this.actualText = NamedCharacterConverter.convert(actualText);
    }

    private static enum CHUNKTYPE {
        first(false),
        mid(true),
        last(true),
        complete(false);

        private boolean applyCharWidth;

        private CHUNKTYPE(boolean applyCharWidth) {
            this.applyCharWidth = applyCharWidth;
        }
    }

    public static class TextWrapper {
        private String text;
        private boolean isTwoByteChar;
        private ParserListener listener;

        public TextWrapper(String text, boolean isTwoByteChar, ParserListener listener) {
            this.text = text;
            this.isTwoByteChar = isTwoByteChar;
            this.listener = listener;
        }

        public ParserListener getListener() {
            return this.listener;
        }

        public String getText() {
            return this.text;
        }

        public boolean isTwoByteChars() {
            return this.isTwoByteChar;
        }

        public void transformToTwoByteText() {
            if (!this.isTwoByteChar) {
                char[] arry = this.text.toCharArray();
                char[] twoByteArray = new char[(this.text.length() + 1) / 2];
                for (int i = 0; i < arry.length; ++i) {
                    char c = (char)((arry[i] & 0xFF) << 8);
                    if (i < arry.length - 1) {
                        c = (char)(c | (char)(arry[++i] & 0xFF));
                    }
                    twoByteArray[i / 2] = c;
                }
                this.text = new String(twoByteArray);
                this.isTwoByteChar = true;
            }
        }

        public int getLength() {
            return this.text.length();
        }

        public void addText(TextWrapper wrapper) {
            if (wrapper.getLength() == 0) {
                return;
            }
            if (!this.isTwoByteChar && wrapper.isTwoByteChars()) {
                throw new IllegalStateException("both text must have the same numbers of byte per character");
            }
            if (this.isTwoByteChar && !wrapper.isTwoByteChars()) {
                wrapper.transformToTwoByteText();
            }
            this.text = this.text + wrapper.getText();
        }
    }
}

