/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.pdfview.PDFGroup;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.command.PDFChangeStrokeCmd;
import com.inet.pdfview.command.PDFCmd;
import com.inet.pdfview.command.PDFFillPaintCmd;
import com.inet.pdfview.command.PDFPopCmd;
import com.inet.pdfview.command.PDFPushCmd;
import com.inet.pdfview.command.PDFStrokePaintCmd;
import com.inet.pdfview.command.PDFXformCmd;
import com.inet.pdfview.control.ControlData;
import com.inet.pdfview.decrypt.PDFDecrypter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDFPage {
    public static final String BOX_MEDIA = "MediaBox";
    public static final String BOX_CROP = "CropBox";
    public static final String BOX_BLEED = "BleedBox";
    public static final String BOX_TRIM = "TrimBox";
    public static final String BOX_ART = "ArtBox";
    private List<PDFCmd> commands;
    private boolean finished = false;
    private int pageNumber;
    private Rectangle2D bbox;
    private AffineTransform init_bbox;
    private int rotation;
    private boolean buildPageImage;
    private PDFDecrypter decryptor;
    private PDFObject[] annots;
    private List<ControlData> controlList;
    private Exception recentError;
    private boolean skipDrawable;
    private PDFGroup group;
    private Map<String, Rectangle2D> pageBounds = new HashMap<String, Rectangle2D>();

    public PDFPage(Rectangle2D bbox, int rotation) {
        this(-1, bbox, rotation, null, null, null);
    }

    public PDFPage(int pageNumber, Rectangle2D bbox, int rotation, PDFDecrypter decryptor, PDFObject[] annots, List<ControlData> controlElements) {
        this(pageNumber, bbox, null, rotation, decryptor, annots, controlElements);
    }

    public PDFPage(int pageNumber, Rectangle2D bbox, AffineTransform init, int rotation, PDFDecrypter decryptor, PDFObject[] annots, List<ControlData> controlElements) {
        this.pageNumber = pageNumber;
        this.decryptor = decryptor;
        this.annots = annots;
        this.controlList = controlElements;
        this.init_bbox = init;
        this.group = new PDFGroup();
        if (bbox == null) {
            bbox = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
        }
        while (rotation < 0) {
            rotation += 360;
        }
        this.rotation = rotation %= 360;
        this.setPageBounds(BOX_MEDIA, bbox);
        if (rotation == 90 || rotation == 270) {
            bbox = new Rectangle2D.Double(bbox.getX(), bbox.getY(), bbox.getHeight(), bbox.getWidth());
        }
        this.bbox = bbox;
        if (bbox.getHeight() < 0.0) {
            this.bbox = new Rectangle2D.Double(bbox.getX(), bbox.getY() + bbox.getHeight(), bbox.getWidth(), bbox.getHeight() * -1.0);
        }
        if (bbox.getWidth() < 0.0) {
            this.bbox = new Rectangle2D.Double(bbox.getX() + bbox.getWidth(), bbox.getY(), bbox.getWidth() * -1.0, bbox.getHeight());
        }
        this.commands = Collections.synchronizedList(new ArrayList(250));
    }

    public float getWidth() {
        return (float)this.bbox.getWidth();
    }

    public float getHeight() {
        return (float)this.bbox.getHeight();
    }

    public int getRotation() {
        return this.rotation;
    }

    public PDFGroup getGroup() {
        return this.group;
    }

    public AffineTransform getInitialTransform() {
        if (this.init_bbox == null) {
            switch (this.getRotation()) {
                case 0: {
                    this.init_bbox = new AffineTransform(1.0, 0.0, 0.0, -1.0, -this.bbox.getX(), this.bbox.getHeight() + this.bbox.getY());
                    break;
                }
                case 90: {
                    this.init_bbox = new AffineTransform(0.0, 1.0, 1.0, 0.0, -this.bbox.getY(), -this.bbox.getX());
                    break;
                }
                case 180: {
                    this.init_bbox = new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)this.getWidth() + this.bbox.getX(), -this.bbox.getY());
                    break;
                }
                case 270: {
                    this.init_bbox = new AffineTransform(0.0, -1.0, -1.0, 0.0, (double)this.getWidth() + this.bbox.getY(), (double)this.getHeight() + this.bbox.getX());
                    break;
                }
                default: {
                    this.init_bbox = new AffineTransform();
                }
            }
        }
        return new AffineTransform(this.init_bbox);
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    public PDFCmd getCommand(int index) {
        return this.commands.get(index);
    }

    public List<PDFCmd> getCommands() {
        return this.commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(PDFCmd cmd) {
        if (this.finished) {
            throw new IllegalStateException("Cannot modify a finished page");
        }
        List<PDFCmd> list = this.commands;
        synchronized (list) {
            this.commands.add(cmd);
        }
        cmd.setSkip(this.skipDrawable);
    }

    public void addCommands(PDFPage page) {
        this.addCommands(page, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommands(PDFPage page, AffineTransform extra) {
        if (this.finished) {
            throw new IllegalStateException("Cannot modify a finished page");
        }
        List<PDFCmd> list = this.commands;
        synchronized (list) {
            this.addPush();
            if (extra != null) {
                this.addXform(extra);
            }
            this.commands.addAll(page.getCommands());
            this.addPop();
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void finish() {
        this.finished = true;
        this.notifyAll();
    }

    public void addPush() {
        this.addCommand(new PDFPushCmd());
    }

    public void addPop() {
        this.addCommand(new PDFPopCmd());
    }

    public void addXform(AffineTransform at) {
        this.addCommand(new PDFXformCmd(new AffineTransform(at)));
    }

    public void addStrokeWidth(float w) {
        PDFChangeStrokeCmd sc = new PDFChangeStrokeCmd();
        if (w == 0.0f) {
            w = 0.1f;
        }
        sc.setWidth(w);
        this.addCommand(sc);
    }

    public void addEndCap(int capstyle) {
        PDFChangeStrokeCmd sc = new PDFChangeStrokeCmd();
        int cap = 0;
        switch (capstyle) {
            case 0: {
                cap = 0;
                break;
            }
            case 1: {
                cap = 1;
                break;
            }
            case 2: {
                cap = 2;
            }
        }
        sc.setEndCap(cap);
        this.addCommand(sc);
    }

    public void addLineJoin(int joinstyle) {
        PDFChangeStrokeCmd sc = new PDFChangeStrokeCmd();
        int join = 0;
        switch (joinstyle) {
            case 0: {
                join = 0;
                break;
            }
            case 1: {
                join = 1;
                break;
            }
            case 2: {
                join = 2;
            }
        }
        sc.setLineJoin(join);
        this.addCommand(sc);
    }

    public void addMiterLimit(float limit) {
        PDFChangeStrokeCmd sc = new PDFChangeStrokeCmd();
        sc.setMiterLimit(limit);
        this.addCommand(sc);
    }

    public void addDash(float[] dashary, float phase) {
        PDFChangeStrokeCmd sc = new PDFChangeStrokeCmd();
        sc.setDash(dashary, phase);
        this.addCommand(sc);
    }

    public void addFillPaint(PDFPaint p) {
        this.addCommand(new PDFFillPaintCmd(p));
    }

    public void addStrokePaint(PDFPaint p) {
        this.addCommand(new PDFStrokePaintCmd(p));
    }

    public PDFDecrypter getDecrypter() {
        return this.decryptor;
    }

    public boolean isBuildPageImage() {
        return this.buildPageImage;
    }

    PDFObject[] getAnnots() {
        return this.annots;
    }

    List<ControlData> getControlElems() {
        return this.controlList;
    }

    void setParseError(Exception recentError) {
        this.recentError = recentError;
    }

    public Exception getRecentError() {
        return this.recentError;
    }

    public void setBuildPageImage(boolean buildPageImage) {
        this.buildPageImage = buildPageImage;
    }

    public int getPageIndex() {
        return this.pageNumber;
    }

    public Rectangle2D getBounds() {
        return this.bbox;
    }

    void setSkipDrawable(boolean val) {
        this.skipDrawable = val;
    }

    public void setPageBounds(String ref, Rectangle2D value) {
        this.pageBounds.put(ref, value);
    }

    public Rectangle2D getPageBounds(String ref) {
        return this.pageBounds.get(ref);
    }
}

