/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.cache.PersistenceKey;
import com.inet.cache.image.SerializableImage;
import com.inet.cache.internal.MemoryObserver;
import com.inet.id.GUID;
import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.GraphicsState;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.colorspace.AlternateColorSpace;
import com.inet.pdfview.colorspace.CMYKColorSpace;
import com.inet.pdfview.colorspace.IndexedColor;
import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.DCTDecode;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.function.FunctionType0;
import com.inet.pdfview.function.PDFFunction;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.FilteredImageSource;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RGBImageFilter;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public class PDFImage {
    private static final int MEMORY_CHECK_THRESHOLD = 3000000;
    private int width;
    private int height;
    private PDFColorSpace colorSpace;
    private int bpc;
    private boolean imageMask = false;
    private PDFImage sMask;
    private int[] minMaskBound;
    private int[] maxMaskBound;
    private float[] decode;
    private PDFObject imageObj;
    private PDFDecrypter decryptor;
    private boolean imageSupported = true;
    private Object persistenceKey;
    private CacheAccess cache;
    private final boolean isAlphaChannel;
    private boolean isJPEG2000 = false;
    private byte[] firstFewData = new byte[16];

    private PDFImage(PDFObject imageObj, PDFDecrypter decryptor, CacheAccess cache, boolean isAlphaChannel) {
        this.imageObj = imageObj;
        this.decryptor = decryptor;
        this.cache = cache;
        this.isAlphaChannel = isAlphaChannel;
    }

    public boolean isJPEG2000() {
        return this.isJPEG2000;
    }

    public byte[] first16byteData() {
        return this.firstFewData;
    }

    public static void checkMemoryForImage(int width, int height) {
        if (width * height > 3000000) {
            MemoryObserver.checkMemory();
        }
    }

    public static PDFImage createImage(PDFObject obj, Map<?, ?> resources, PDFDecrypter decryptor, CacheAccess cache, boolean isAlphaChannel) throws PDFParseException {
        PDFObject imageMaskObj;
        PDFImage image = new PDFImage(obj, decryptor, cache, isAlphaChannel);
        PDFObject widthObj = obj.getDictRef("Width");
        if (widthObj == null) {
            throw new PDFParseException("Unable to read image width: " + String.valueOf(obj));
        }
        image.setWidth(widthObj.getIntValue());
        PDFObject heightObj = obj.getDictRef("Height");
        if (heightObj == null) {
            throw new PDFParseException("Unable to get image height: " + String.valueOf(obj));
        }
        image.setHeight(heightObj.getIntValue());
        PDFObject decodeObj = obj.getDictRef("Decode");
        if (decodeObj != null) {
            PDFObject[] decodeArray = decodeObj.getArray();
            float[] decode = new float[decodeArray.length];
            for (int i = 0; i < decodeArray.length; ++i) {
                decode[i] = decodeArray[i].getFloatValue();
            }
            image.setDecode(decode);
        }
        if ((imageMaskObj = obj.getDictRef("ImageMask")) != null) {
            image.setImageMask(imageMaskObj.getBooleanValue());
        }
        boolean isJPX = image.isJPXDecode();
        if (image.isImageMask()) {
            image.setBitsPerComponent(1);
            Color[] colors = new Color[]{Color.WHITE, Color.BLACK};
            image.setColorSpace(new IndexedColor(colors));
        } else {
            PDFObject csObj;
            PDFObject bpcObj = obj.getDictRef("BitsPerComponent");
            if (bpcObj == null) {
                if (!isJPX) {
                    throw new PDFParseException("Unable to get bits per component: " + String.valueOf(obj));
                }
            } else {
                image.setBitsPerComponent(bpcObj.getIntValue());
            }
            if ((csObj = obj.getDictRef("ColorSpace")) == null) {
                if (!isJPX) {
                    throw new PDFParseException("No ColorSpace for image: " + String.valueOf(obj));
                }
            } else {
                PDFColorSpace cs = PDFColorSpace.getColorSpace(csObj, resources, decryptor);
                image.setColorSpace(cs);
            }
        }
        PDFObject sMaskObj = obj.getDictRef("SMask");
        if (sMaskObj == null) {
            sMaskObj = obj.getDictRef("Mask");
        }
        if (sMaskObj != null && sMaskObj.getType() != 8) {
            if (sMaskObj.getType() == 5) {
                PDFObject[] colorMaskBounds = sMaskObj.getArray();
                int size = colorMaskBounds.length;
                if (size % 2 == 0) {
                    int colorCount = size / 2;
                    image.minMaskBound = new int[colorCount];
                    image.maxMaskBound = new int[colorCount];
                    for (int i = 0; i < colorCount; ++i) {
                        image.minMaskBound[i] = colorMaskBounds[2 * i].getIntValue();
                        image.maxMaskBound[i] = colorMaskBounds[2 * i + 1].getIntValue();
                    }
                }
            } else {
                PDFImage sMaskImage = PDFImage.createImage(sMaskObj, resources, decryptor, cache, isAlphaChannel);
                image.setSMask(sMaskImage);
            }
        }
        image.isJPEG2000 = isJPX;
        return image;
    }

    public SerializableImage getOutputImage(GraphicsState state, PDFRenderer renderer) {
        SerializableImage si = this.getRenderableImage(this.isImageMask());
        if (si != null && si.getImage() != null && this.isImageMask()) {
            si = this.getMaskedImage(si.getBufferedImage(), this.getColorSpace(), state, renderer);
        }
        return si;
    }

    public SerializableImage getBufferedImage() {
        SerializableImage image = this.getRenderableImage(true);
        if (image == null) {
            image = new SerializableImage((Image)new BufferedImage(1, 1, 2), null);
        }
        return image;
    }

    private SerializableImage getRenderableImage(boolean isMask) {
        if (!this.imageSupported) {
            return null;
        }
        try {
            if (this.persistenceKey == null && this.cache != null) {
                this.persistenceKey = this.imageObj.dereference().getCache();
            }
        }
        catch (PDFParseException pDFParseException) {
            // empty catch block
        }
        if (this.persistenceKey != null && this.cache != null && !(this.persistenceKey instanceof ArtificialID)) {
            return this.cache.getImage(this.persistenceKey);
        }
        BufferedImage bi = null;
        try {
            bi = this.tryDCTDecode();
            if (bi != null) {
                bi = this.applyMask(bi);
            } else {
                byte[] data = this.imageObj.getStream(this.imageObj.getRefValue(), this.decryptor, true);
                if (data != null) {
                    bi = this.parseData(data);
                } else {
                    Object checkForJPX = this.imageObj.dereference().getCache();
                    if (checkForJPX instanceof BufferedImage) {
                        bi = (BufferedImage)checkForJPX;
                        this.imageObj.dereference().setCache(null);
                    }
                }
            }
        }
        catch (Exception e) {
            PDFParser.LOGGER.error("Error reading image", (Throwable)e);
        }
        boolean bl = this.imageSupported = bi != null;
        if (bi != null) {
            byte[] rawData = null;
            if (!this.hasMask()) {
                rawData = this.getDirectDCTData();
            }
            SerializableImage image = new SerializableImage((Image)bi, rawData);
            if (this.cache != null) {
                if (this.persistenceKey == null) {
                    if (isMask && rawData == null && image.getColorModel().getNumComponents() == 1 && image.getColorModel().getColorSpace().getType() == 6) {
                        PDFImage.checkMemoryForImage(image.getWidth(), image.getHeight());
                        image.getSerializer();
                    }
                    this.persistenceKey = this.cache.putImage(image);
                    if (this.persistenceKey == null) {
                        this.persistenceKey = new ArtificialID();
                        image.setPersistenceKey(PersistenceKey.create((String)this.persistenceKey.toString()));
                    }
                } else {
                    image.setPersistenceKey(PersistenceKey.create((String)this.persistenceKey.toString()));
                }
                try {
                    this.imageObj.dereference().setCache(this.persistenceKey);
                }
                catch (PDFParseException e) {
                    PDFParser.LOGGER.debug((Object)("Unable to dereference image '" + String.valueOf(this.imageObj) + "'. This may increase the memory usage for redundant images."));
                }
            } else {
                if (this.persistenceKey == null) {
                    this.persistenceKey = new ArtificialID();
                }
                image.setPersistenceKey(PersistenceKey.create((String)this.persistenceKey.toString()));
            }
            return image;
        }
        return null;
    }

    public SerializableImage getMaskedImage(BufferedImage bi, PDFColorSpace pdfColorSpace, GraphicsState state, PDFRenderer renderer) {
        Paint p = state.getFillPaint().getPaint(renderer);
        int startX = bi.getMinX();
        int startY = bi.getMinY();
        int width = bi.getWidth();
        int height = bi.getHeight();
        PDFImage.checkMemoryForImage(width, height);
        if (p instanceof Color) {
            BufferedImage dstImage;
            SerializableImage cachedImage;
            Color col = (Color)p;
            if (this.persistenceKey != null && !(this.persistenceKey instanceof ArtificialID) && (cachedImage = this.cache.getImage(this.getMaskCacheKey(col))) != null) {
                return cachedImage;
            }
            Color translucent = new Color(0, true);
            IndexColorModel cm = PDFImage.toColorModel(col, translucent);
            if (cm.isCompatibleRaster(bi.getData())) {
                int rgb1;
                int rgb0;
                IndexColorModel icm;
                Color[] table;
                if (bi.getColorModel() instanceof IndexColorModel && pdfColorSpace instanceof IndexedColor && (table = ((IndexedColor)pdfColorSpace).getTable()).length == (icm = (IndexColorModel)bi.getColorModel()).getMapSize() && (rgb0 = icm.getRGB(0)) != (rgb1 = table[0].getRGB())) {
                    cm = PDFImage.toColorModel(translucent, col);
                }
                dstImage = new BufferedImage(cm, bi.getRaster(), false, null);
            } else {
                dstImage = new BufferedImage(width, height, 2);
                for (int i = 0; i < height; ++i) {
                    int[] srcPixels = new int[width];
                    int[] dstPixels = new int[srcPixels.length];
                    bi.getRGB(startX, startY + i, width, 1, srcPixels, 0, height);
                    for (int j = 0; j < srcPixels.length; ++j) {
                        dstPixels[j] = srcPixels[j] == -16777216 ? col.getRGB() : 0;
                    }
                    dstImage.setRGB(startX, startY + i, width, 1, dstPixels, 0, height);
                }
            }
            SerializableImage maskedImage = new SerializableImage((Image)dstImage, null);
            if (this.persistenceKey != null && this.cache != null) {
                maskedImage.setPersistenceKey(this.getMaskCacheKey(col));
                this.cache.putImage(maskedImage);
            }
            return maskedImage;
        }
        BufferedImage dstImage = new BufferedImage(width, height, 2);
        AffineTransform t = PDFImage.voidTranslate(state.getXForm());
        AffineTransform at = new AffineTransform();
        at.translate(0.0, height);
        at.rotate(-1.5707963267948966);
        at.scale((double)width / (t.getScaleY() + t.getShearY()), (double)height / (t.getScaleX() + t.getShearX()));
        at.concatenate(PDFImage.voidTranslate(t));
        Graphics2D dstGraphics = (Graphics2D)dstImage.getGraphics();
        dstGraphics.setTransform(at);
        state.getFillPaint().fill(renderer, dstGraphics, new GeneralPath(new Rectangle(width, height)));
        for (int i = 0; i < height; ++i) {
            int[] srcPixels = new int[width];
            int[] dstPixels = new int[srcPixels.length];
            bi.getRGB(startX, startY + i, width, 1, srcPixels, 0, height);
            dstImage.getRGB(startX, startY + i, width, 1, dstPixels, 0, height);
            for (int j = 0; j < srcPixels.length; ++j) {
                if (srcPixels[j] == -16777216) continue;
                dstPixels[j] = 0;
            }
            dstImage.setRGB(startX, startY + i, width, 1, dstPixels, 0, height);
        }
        return new SerializableImage((Image)dstImage, null);
    }

    protected PersistenceKey getMaskCacheKey(Color col) {
        return PersistenceKey.create((String)(String.valueOf(this.persistenceKey) + "mask" + Integer.toHexString(col.getRGB())));
    }

    private static IndexColorModel toColorModel(Color ... colors) {
        byte[] r = new byte[colors.length];
        byte[] g = new byte[colors.length];
        byte[] b = new byte[colors.length];
        byte[] a = new byte[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            Color c = colors[i];
            r[i] = (byte)c.getRed();
            g[i] = (byte)c.getGreen();
            b[i] = (byte)c.getBlue();
            a[i] = (byte)c.getAlpha();
        }
        int bits = colors.length > 2 ? 8 : 1;
        return new IndexColorModel(bits, colors.length, r, g, b, a);
    }

    private static AffineTransform voidTranslate(AffineTransform t) {
        double[] m = new double[6];
        t.getMatrix(m);
        m[4] = 0.0;
        m[5] = 0.0;
        return new AffineTransform(m);
    }

    private BufferedImage tryDCTDecode() {
        try {
            PDFObject obj = this.imageObj.dereference();
            IDataBuffer stream = this.getDCTStream(this.imageObj);
            if (stream != null) {
                return DCTDecode.decodeImage(obj, stream, this.decryptor);
            }
        }
        catch (PDFParseException pDFParseException) {
            // empty catch block
        }
        return null;
    }

    private IDataBuffer getDCTStream(PDFObject obj) throws PDFParseException {
        PDFObject encoding;
        PDFColorSpace pdfColorSpace = this.getColorSpace();
        if (pdfColorSpace == null || pdfColorSpace.getClass() != PDFColorSpace.class) {
            return null;
        }
        ColorSpace cs = pdfColorSpace.getColorSpace();
        if (cs instanceof CMYKColorSpace || cs instanceof ICC_ColorSpace && cs.getType() == 9) {
            return null;
        }
        PDFXref xRef = obj.getRefValue();
        if ((obj = obj.dereference()).getRefValue() != null) {
            xRef = obj.getRefValue();
        }
        if ((encoding = obj.getDictRef("Filter")) == null) {
            return null;
        }
        PDFObject[] ary = encoding.getType() == 4 ? new PDFObject[]{encoding} : encoding.getArray();
        if (ary.length != 1) {
            return null;
        }
        String enc = ary[0].getStringValue();
        if (!enc.equals("DCTDecode") && !enc.equals("DCT")) {
            return null;
        }
        PDFObject decode = obj.getDictRef("Decode");
        if (decode != null) {
            return null;
        }
        IDataBuffer stream = obj.getStreamRaw(xRef, this.decryptor);
        return stream;
    }

    private boolean isJPXDecode() throws PDFParseException {
        PDFObject obj = this.imageObj.dereference();
        PDFObject encoding = obj.getDictRef("Filter");
        if (encoding == null) {
            return false;
        }
        PDFObject[] ary = encoding.getType() == 4 ? new PDFObject[]{encoding} : encoding.getArray();
        if (ary.length == 0) {
            return false;
        }
        for (PDFObject entry : ary) {
            if (!"JPXDecode".equals(entry.getStringValue())) continue;
            return true;
        }
        return false;
    }

    protected BufferedImage parseData(byte[] data) throws IllegalArgumentException {
        DataBuffer db;
        ColorModel cm;
        if (data.length >= this.firstFewData.length) {
            System.arraycopy(data, 0, this.firstFewData, 0, this.firstFewData.length);
        }
        if ((cm = this.getColorModel()).getComponentSize()[0] == 1 && cm.getNumComponents() > 1) {
            int newValue = -1;
            int stride = (this.getWidth() + 7) / 8;
            int lastCol = this.getWidth() % 8;
            byte[] tmp = new byte[this.getWidth() * (data.length / stride)];
            int pos = 0;
            for (int i = 0; i < data.length; ++i) {
                byte dataSegment = data[i];
                if (lastCol > 0 && i % stride == stride - 1) {
                    int mod = 128;
                    for (int j = 0; j < lastCol; ++j) {
                        tmp[pos + j] = (dataSegment & (byte)mod) == 0 ? 0 : newValue;
                        mod /= 2;
                    }
                    pos += lastCol;
                    continue;
                }
                tmp[pos] = (dataSegment & 0xFFFFFF80) == 0 ? 0 : newValue;
                tmp[pos + 1] = (dataSegment & 0x40) == 0 ? 0 : newValue;
                tmp[pos + 2] = (dataSegment & 0x20) == 0 ? 0 : newValue;
                tmp[pos + 3] = (dataSegment & 0x10) == 0 ? 0 : newValue;
                tmp[pos + 4] = (dataSegment & 8) == 0 ? 0 : newValue;
                tmp[pos + 5] = (dataSegment & 4) == 0 ? 0 : newValue;
                tmp[pos + 6] = (dataSegment & 2) == 0 ? 0 : newValue;
                tmp[pos + 7] = (dataSegment & 1) == 0 ? 0 : newValue;
                pos += 8;
            }
            data = tmp;
        }
        if (cm instanceof DeviceNColorModel) {
            DeviceNColorModel devCm = (DeviceNColorModel)cm;
            PDFFunction function = devCm.getFunction();
            int sourceComponentCount = function.getNumInputs();
            if (data.length % sourceComponentCount != 0) {
                throw new IllegalArgumentException("data length not compatible with color model: " + data.length);
            }
            int pixelCount = data.length / sourceComponentCount;
            int targetComponentCount = devCm.getAlternate().getNumComponents();
            byte[] datasmyk = new byte[pixelCount * targetComponentCount];
            float[] inputs = new float[sourceComponentCount];
            for (int i = 0; i < pixelCount; ++i) {
                int j;
                for (j = 0; j < sourceComponentCount; ++j) {
                    int v = data[sourceComponentCount * i + j] & 0xFF;
                    inputs[j] = (float)v / 255.0f;
                }
                float[] res = function.calculate(inputs);
                for (j = 0; j < res.length; ++j) {
                    int val = Math.round(res[j] * 255.0f);
                    datasmyk[targetComponentCount * i + j] = (byte)val;
                }
            }
            db = new DataBufferByte(datasmyk, datasmyk.length);
        } else if (cm.getComponentSize()[0] == 16) {
            short[] dataShort = new short[data.length / 2];
            ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN).asShortBuffer().get(dataShort);
            db = new DataBufferUShort(dataShort, dataShort.length);
        } else {
            db = new DataBufferByte(data, data.length);
        }
        long expectedSize = this.getWidth() * this.getHeight() * cm.getNumColorComponents();
        if ((long)db.getSize() != expectedSize && PDFParser.LOGGER.isDebug()) {
            PDFParser.LOGGER.debug((Object)("Expected Size is different to data Size " + String.valueOf(cm)));
        }
        PDFImage.checkMemoryForImage(this.getWidth(), this.getHeight());
        SampleModel sm = cm.createCompatibleSampleModel(this.getWidth(), this.getHeight());
        WritableRaster raster = Raster.createWritableRaster(sm, db, new Point(0, 0));
        BufferedImage bi = null;
        if (cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            int type = 12;
            if (this.getBitsPerComponent() == 8) {
                type = 13;
            }
            bi = new BufferedImage(this.getWidth(), this.getHeight(), type, icm);
            bi.setData(raster);
        } else {
            bi = new BufferedImage(cm, raster, true, null);
        }
        if (!(this.isImageMask() || this.hasMask() || this.isLinearColorModel(cm))) {
            int type = cm.getColorSpace().getType() == 6 ? 10 : 1;
            BufferedImage bimg = new BufferedImage(bi.getWidth(null), bi.getHeight(null), type);
            Graphics bg = bimg.getGraphics();
            bg.drawImage(bi, 0, 0, null);
            bi = bimg;
        }
        ColorSpace cs = cm.getColorSpace();
        ColorSpace rgbCS = ColorSpace.getInstance(1000);
        if (!this.isImageMask() && cs instanceof ICC_ColorSpace && !cs.equals(rgbCS)) {
            ColorConvertOp op = new ColorConvertOp(cs, rgbCS, null);
            BufferedImage converted = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            bi = op.filter(bi, converted);
        }
        if (this.isAlphaChannel) {
            RGBImageFilter filter = new RGBImageFilter(){

                @Override
                public final int filterRGB(int x, int y, int rgb) {
                    return rgb << 16 & 0xFF000000;
                }
            };
            FilteredImageSource ip = new FilteredImageSource(bi.getSource(), filter);
            Image img = Toolkit.getDefaultToolkit().createImage(ip);
            BufferedImage buffer = new BufferedImage(bi.getWidth(), bi.getHeight(), 2);
            Graphics2D g2d = buffer.createGraphics();
            g2d.drawImage(img, 0, 0, null);
            g2d.dispose();
            bi = buffer;
        }
        bi = this.applyMask(bi);
        return bi;
    }

    private boolean isLinearColorModel(ColorModel model) {
        if (model instanceof DeviceNColorModel) {
            return false;
        }
        if (model instanceof DecodeComponentColorModel) {
            DecodeComponentColorModel dccm = (DecodeComponentColorModel)model;
            if (dccm.decode == null) {
                return true;
            }
            if (dccm.decode.length % 2 == 1) {
                return false;
            }
            for (int i = 0; i < dccm.decode.length / 2; ++i) {
                if (dccm.decode[i * 2] == 0.0f && dccm.decode[i * 2 + 1] == 1.0f) continue;
                return false;
            }
        }
        return true;
    }

    public BufferedImage applyMask(BufferedImage bi) {
        PDFImage sMaskImage = this.getSMask();
        if (sMaskImage != null) {
            int maskHeight = sMaskImage.getHeight();
            int maskWidth = sMaskImage.getWidth();
            if (maskHeight != this.height || maskWidth != this.width) {
                maskWidth = Math.max(maskWidth, this.width);
                maskHeight = Math.max(maskHeight, this.height);
                BufferedImage maskImage = sMaskImage.getBufferedImage().getBufferedImage();
                RGBImageFilter filter = new RGBImageFilter(){

                    @Override
                    public final int filterRGB(int x, int y, int rgb) {
                        return rgb << 8 & 0xFF000000;
                    }
                };
                Image alphaMaskImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(maskImage.getSource(), filter));
                PDFImage.checkMemoryForImage(maskWidth, maskHeight);
                BufferedImage resultImg = new BufferedImage(maskWidth, maskHeight, 2);
                Graphics2D g = resultImg.createGraphics();
                g.drawImage(bi, 0, 0, maskWidth, maskHeight, null);
                g.setComposite(AlphaComposite.getInstance(6, 1.0f));
                g.drawImage(alphaMaskImage, 0, 0, maskWidth, maskHeight, null);
                bi = resultImg;
            } else {
                SerializableImage renderableImage = sMaskImage.getRenderableImage(true);
                if (renderableImage == null) {
                    PDFParser.LOGGER.warn((Object)"Alphamask can not applied because unsupported format!");
                    return bi;
                }
                BufferedImage si = renderableImage.getBufferedImage();
                BufferedImage outImage = new BufferedImage(this.width, this.height, 2);
                int[] srcArray = new int[this.width];
                int[] maskArray = new int[this.width];
                for (int i = 0; i < this.width; ++i) {
                    maskArray[i] = 255;
                }
                int ac = -16777216;
                if (si.getWidth() != this.width || si.getHeight() != this.height) {
                    BufferedImage temp = new BufferedImage(this.width, this.height, 2);
                    Graphics2D g = temp.createGraphics();
                    AffineTransform at = AffineTransform.getScaleInstance((float)this.width / (float)si.getWidth(), (float)this.height / (float)si.getHeight());
                    g.drawRenderedImage(si, at);
                    si = temp;
                }
                for (int y = 0; y < this.height; ++y) {
                    bi.getRGB(0, y, this.width, 1, srcArray, 0, this.width);
                    if (y < this.height) {
                        si.getRGB(0, y, this.width, 1, maskArray, 0, this.width);
                    }
                    for (int j = 0; j < this.width; ++j) {
                        srcArray[j] = (maskArray[j] & 0xFF) << 24 | srcArray[j] & 0xFFFFFF;
                    }
                    outImage.setRGB(0, y, this.width, 1, srcArray, 0, this.width);
                }
                bi = outImage;
            }
        } else if (this.maxMaskBound != null && this.minMaskBound != null) {
            BufferedImage outImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            int alphaMask = 0xFFFFFF;
            WritableRaster rr = bi.getRaster();
            int numBands = rr.getNumBands();
            int[] srcArray = new int[this.width];
            for (int y = 0; y < this.height; ++y) {
                bi.getRGB(0, y, this.width, 1, srcArray, 0, this.width);
                for (int x = 0; x < this.width; ++x) {
                    boolean setTransparent = true;
                    for (int band = 0; band < numBands; ++band) {
                        int pixelValue = rr.getSample(x, y, band);
                        if ((band >= this.minMaskBound.length || pixelValue >= this.minMaskBound[band]) && (band >= this.maxMaskBound.length || pixelValue <= this.maxMaskBound[band])) continue;
                        setTransparent = false;
                        break;
                    }
                    if (!setTransparent) continue;
                    int n = x;
                    srcArray[n] = srcArray[n] & 0xFFFFFF;
                }
                outImage.setRGB(0, y, this.width, 1, srcArray, 0, this.width);
            }
            bi = outImage;
        }
        return bi;
    }

    private boolean hasMask() {
        return this.getSMask() != null || this.maxMaskBound != null && this.minMaskBound != null;
    }

    public byte[] getDirectDCTData() {
        if (this.getSMask() == null && (this.maxMaskBound == null || this.minMaskBound != null)) {
            IDataBuffer stream;
            try {
                stream = this.getDCTStream(this.imageObj);
            }
            catch (PDFParseException e) {
                return null;
            }
            catch (RuntimeException e) {
                if (PDFParser.LOGGER.isDebug()) {
                    PDFParser.LOGGER.debug((Object)e);
                }
                return null;
            }
            if (stream != null) {
                stream.rewind();
                byte[] data = new byte[stream.remaining()];
                stream.get(data);
                if (data.length >= this.firstFewData.length) {
                    System.arraycopy(data, 0, this.firstFewData, 0, this.firstFewData.length);
                }
                return data;
            }
        }
        return null;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public PDFColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(PDFColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    public int getBitsPerComponent() {
        return this.bpc;
    }

    public void setBitsPerComponent(int bpc) {
        this.bpc = bpc;
    }

    public boolean isImageMask() {
        return this.imageMask;
    }

    public void setImageMask(boolean imageMask) {
        this.imageMask = imageMask;
    }

    public PDFImage getSMask() {
        return this.sMask;
    }

    protected void setSMask(PDFImage sMask) {
        this.sMask = sMask;
    }

    protected float[] getDecode() {
        return this.decode;
    }

    protected void setDecode(float[] decode) {
        this.decode = decode;
    }

    public ColorModel getColorModel() {
        PDFColorSpace cs = this.getColorSpace();
        if (cs instanceof IndexedColor) {
            int correctCount;
            IndexedColor ics = (IndexedColor)cs;
            byte[] components = ics.getColorComponents();
            int num = ics.getCount();
            if (this.decode != null) {
                byte[] normComps = new byte[components.length];
                for (int i = 0; i < num; ++i) {
                    byte[] orig = new byte[]{(byte)i};
                    float[] res = this.normalize(orig, null, 0);
                    int idx = (int)res[0];
                    normComps[i * 3] = components[idx * 3];
                    normComps[i * 3 + 1] = components[idx * 3 + 1];
                    normComps[i * 3 + 2] = components[idx * 3 + 2];
                }
                components = normComps;
            }
            if ((correctCount = 1 << this.getBitsPerComponent()) < num) {
                byte[] fewerComps = new byte[correctCount * 3];
                System.arraycopy(components, 0, fewerComps, 0, correctCount * 3);
                components = fewerComps;
                num = correctCount;
            }
            return new IndexColorModel(this.getBitsPerComponent(), num, components, 0, false);
        }
        int dataBufferType = 0;
        if (this.getBitsPerComponent() == 16) {
            dataBufferType = 1;
        }
        if (cs instanceof AlternateColorSpace) {
            AlternateColorSpace acs = (AlternateColorSpace)cs;
            PDFFunction f = acs.getFunction();
            ColorSpace ics = acs.getColorSpace();
            if (f != null && f.getNumInputs() == 1 && (ics.getNumComponents() == 3 || ics.getNumComponents() == 4) && this.getBitsPerComponent() == 8) {
                byte[] r = new byte[256];
                byte[] g = new byte[256];
                byte[] b = new byte[256];
                byte[] a = new byte[256];
                float[] fin = new float[1];
                for (int i = 0; i < 256; ++i) {
                    fin[0] = (float)i / 255.0f;
                    float[] rgba = ics.toRGB(f.calculate(fin));
                    r[i] = (byte)(255.0f * rgba[0]);
                    g[i] = (byte)(255.0f * rgba[1]);
                    b[i] = (byte)(255.0f * rgba[2]);
                    a[i] = rgba.length == 4 ? (int)((int)(255.0f * rgba[3])) : -1;
                }
                return new IndexColorModel(8, 256, r, g, b, a);
            }
            if (f != null && (f.getNumInputs() == 3 || f.getNumInputs() == 2 || ics.getNumComponents() == 4)) {
                int componentNumberInAlternateCS = acs.getNumComponents();
                if (f.getNumInputs() != componentNumberInAlternateCS) {
                    throw new IllegalArgumentException("number of component " + componentNumberInAlternateCS + " does not match function input" + f.getNumInputs());
                }
                int numComponent = ics.getNumComponents();
                int bpc = this.getBitsPerComponent();
                int[] bits = new int[numComponent];
                for (int i = 0; i < bits.length; ++i) {
                    bits[i] = bpc;
                }
                return new DeviceNColorModel(ics, bits, f, dataBufferType);
            }
        }
        int[] bits = new int[cs.getNumComponents()];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = this.getBitsPerComponent();
        }
        return new DecodeComponentColorModel(cs.getColorSpace(), bits, this.getDecode(), dataBufferType);
    }

    private float[] normalize(byte[] pixels, float[] normComponents, int normOffset) {
        if (normComponents == null) {
            normComponents = new float[normOffset + pixels.length];
        }
        float[] decodeArray = this.getDecode();
        for (int i = 0; i < pixels.length; ++i) {
            int val = pixels[i] & 0xFF;
            int pow = (int)Math.pow(2.0, this.getBitsPerComponent()) - 1;
            float ymin = decodeArray[i * 2];
            float ymax = decodeArray[i * 2 + 1];
            normComponents[normOffset + i] = FunctionType0.interpolate(val, 0.0f, pow, ymin, ymax);
        }
        return normComponents;
    }

    public PDFXref getRef() {
        return this.imageObj.getRefValue();
    }

    public PDFDecrypter getDecrypter() {
        return this.decryptor;
    }

    private static class ArtificialID
    extends GUID {
        private static final long serialVersionUID = 3395510154218930845L;

        public ArtificialID() {
            super(GUID.generateNew().toString());
        }
    }

    class DeviceNColorModel
    extends ComponentColorModel {
        private PDFFunction function;

        public DeviceNColorModel(ColorSpace cs, int[] bpc, PDFFunction function, int dataBufferType) {
            super(cs, bpc, false, false, 1, dataBufferType);
            this.pixel_bits = cs.getNumComponents() * bpc[0];
            this.function = function;
        }

        PDFFunction getFunction() {
            return this.function;
        }

        ColorSpace getAlternate() {
            return this.getColorSpace();
        }
    }

    public static class DecodeComponentColorModel
    extends ComponentColorModel {
        private float[] decode;
        private int bpc;

        public DecodeComponentColorModel(ColorSpace cs, int[] bpc, float[] decode, int dataBufferType) {
            super(cs, bpc, false, false, 1, dataBufferType);
            this.bpc = bpc[0];
            this.decode = decode;
            this.pixel_bits = bpc.length * bpc[0];
        }

        @Override
        public SampleModel createCompatibleSampleModel(int width, int height) {
            if (this.getNumComponents() == 1 && this.getPixelSize() < 8) {
                return new MultiPixelPackedSampleModel(this.getTransferType(), width, height, this.getPixelSize());
            }
            return super.createCompatibleSampleModel(width, height);
        }

        @Override
        public boolean isCompatibleRaster(Raster raster) {
            if (this.getNumComponents() == 1 && this.getPixelSize() < 8) {
                SampleModel sm = raster.getSampleModel();
                return sm instanceof MultiPixelPackedSampleModel && sm.getSampleSize(0) == this.getPixelSize();
            }
            return super.isCompatibleRaster(raster);
        }

        @Override
        public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
            if (this.decode == null) {
                return super.getNormalizedComponents(pixel, normComponents, normOffset);
            }
            return this.normalize((byte[])pixel, normComponents, normOffset);
        }

        private float[] normalize(byte[] pixels, float[] normComponents, int normOffset) {
            if (normComponents == null) {
                normComponents = new float[normOffset + pixels.length];
            }
            float[] decodeArray = this.decode;
            for (int i = 0; i < pixels.length; ++i) {
                int val = pixels[i] & 0xFF;
                int pow = (int)Math.pow(2.0, this.bpc) - 1;
                float ymin = i * 2 < decodeArray.length ? decodeArray[i * 2] : 0.0f;
                float ymax = i * 2 + 1 < decodeArray.length ? decodeArray[i * 2 + 1] : 1.0f;
                normComponents[normOffset + i] = FunctionType0.interpolate(val, 0.0f, pow, ymin, ymax);
            }
            return normComponents;
        }

        public float[] getDecode() {
            return this.decode;
        }
    }
}

