/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.ReferenceFactory;
import java.lang.ref.Reference;

public class PDFCrossRefEntry {
    public static final int ENTRY_REF_DELETE = 0;
    public static final int ENTRY_REF_FREE = 1;
    public static final int ENTRY_REF_COMPRESSED = 2;
    private int type;
    private int streamObjNum;
    private int indexInStream;
    private int fileOffset;
    private int generation;
    private Object reference = null;

    PDFCrossRefEntry(byte[] line) {
        if (line == null) {
            this.fileOffset = -1;
            this.generation = -1;
            this.type = 0;
        } else {
            this.fileOffset = Integer.parseInt(new String(line, 0, 10));
            this.generation = Integer.parseInt(new String(line, 11, 5));
            this.type = 1;
        }
    }

    PDFCrossRefEntry(int fileOffset, int gen) {
        this.fileOffset = fileOffset;
        this.generation = gen;
        this.type = 1;
    }

    PDFCrossRefEntry(int streamObjNum, int indexInStream, int gen) {
        this.streamObjNum = streamObjNum;
        this.indexInStream = indexInStream;
        this.generation = gen;
        this.type = 2;
    }

    int getFilePos() {
        return this.fileOffset;
    }

    boolean isCompressed() {
        return this.type == 2;
    }

    PDFObject getObject() {
        if (this.reference != null) {
            return (PDFObject)((Reference)this.reference).get();
        }
        return null;
    }

    void setObject(PDFObject obj) {
        this.reference = ReferenceFactory.createReference(obj);
    }

    int getObjectStreamNum() {
        return this.streamObjNum;
    }

    int getIndexInObjectStream() {
        return this.indexInStream;
    }
}

