/*
 * Decompiled with CFR 0.152.
 */
package com.inet.encoder.pdf;

import com.inet.classloader.I18nMessages;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.encoder.pdf.drive.PDFDocumentTypeHandler;
import com.inet.encoder.pdf.reporting.a;
import com.inet.logging.LogManager;
import com.inet.plugin.Executable;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.encode.DecoderFactory;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PluginInfo(id="parser.pdf", version="25.10.198", packages="com.inet.encoder.pdf;com.inet.pdfview", optionalDependencies="reporting;drive", internal="PDFParser.jar;jbig2.jar", group="system", flags="designer", icon="com/inet/encoder/pdf/structure/pluginpdf_48.png")
public class PDFParserPlugin
implements ServerPlugin {
    private static final List<@Nonnull DateTimeFormatter> a = List.of(DateTimeFormatter.ofPattern("'D:'yyyyMMddHHmmssXXXX"), DateTimeFormatter.ofPattern("'D:'yyyyMMddHHmmssXXX"), DateTimeFormatter.ofPattern("'D:'yyyyMMddHHmmssXX"), DateTimeFormatter.ofPattern("'D:'yyyyMMddHHmmssX"), DateTimeFormatter.ofPattern("yyyyMMddHHmmssXXXX"), DateTimeFormatter.ofPattern("yyyyMMddHHmmssXXX"), DateTimeFormatter.ofPattern("yyyyMMddHHmmssXX"), DateTimeFormatter.ofPattern("yyyyMMddHHmmssX"));
    private static final List<@Nonnull DateTimeFormatter> b = List.of(DateTimeFormatter.ofPattern("'D:'yyyyMMddHHmmss"), DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
    public static final I18nMessages MSG = new I18nMessages("com.inet.encoder.pdf.structure.i18n.ConfigStructure", PDFParserPlugin.class);

    public void registerExtension(final ServerPluginManager spm) {
        spm.runIfPluginLoaded("reporting", () -> new Executable(){

            public void execute() {
                spm.register(DecoderFactory.class, (Object)new DecoderFactory(a.class, DecoderFactory.DataType.DOCUMENT, "pdf", new DecoderFactory.MagicCondition[]{new DecoderFactory.MagicCondition("%25PDF")}));
            }
        });
        spm.runIfPluginLoaded("drive", () -> new Executable(){

            public void execute() {
                spm.register(DriveFileTypeHandler.class, (Object)new PDFDocumentTypeHandler());
            }
        });
    }

    public void init(ServerPluginManager spm) {
    }

    public void reset() {
    }

    public void restart() {
    }

    @Nullable
    public static String convertPDFTimeToMillis(@Nullable String pdfTimestamp) {
        if (pdfTimestamp == null) {
            return null;
        }
        pdfTimestamp = pdfTimestamp.replace("Z", "+").replaceAll("[^0-9:+-Z]", "").replaceAll("[+-]$", "Z");
        Exception exception = null;
        for (DateTimeFormatter dateTimeFormatter : a) {
            try {
                OffsetDateTime offsetDateTime = OffsetDateTime.parse(pdfTimestamp, dateTimeFormatter);
                return String.valueOf(offsetDateTime.toInstant().toEpochMilli());
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        for (DateTimeFormatter dateTimeFormatter : b) {
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(pdfTimestamp, dateTimeFormatter);
                return String.valueOf(localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            }
            catch (Exception exception3) {
                exception = exception3;
            }
        }
        LogManager.getConfigLogger().debug("Couldn't parse the pdf datetime " + pdfTimestamp, (Object)exception);
        return null;
    }
}

