/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.imageparser;

import com.inet.classloader.I18nMessages;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.model.Document;
import com.inet.pdfc.model.DocumentProgressListener;
import com.inet.pdfc.model.EnumerationProgress;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.plugin.imageparser.ImageParserPlugin;
import com.inet.pdfc.plugin.imageparser.c;
import com.inet.pdfc.plugin.interfaces.DocumentFactory;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.crypto.RandomAccessReadInputStream;
import com.inet.plugin.ServerPluginManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class b
implements DocumentFactory {
    private static final I18nMessages q = new I18nMessages("com.inet.pdfc.plugin.imageparser.structure.i18n.LanguageRessources", ImageParserPlugin.class);
    private static final Set<String> r = new HashSet<String>(Arrays.asList("png", "jpg", "jpeg", "gif", "bmp"));
    private Set<String> s = null;

    public Set<String> getSupportedFileExtensions() {
        return new HashSet<String>(){
            {
                this.addAll(r);
                this.addAll(b.this.e());
                this.add("zip");
            }
        };
    }

    private Set<String> e() {
        if (this.s == null) {
            String string;
            this.s = new HashSet<String>();
            String string2 = System.getProperty("java.version");
            if (string2.contains(".") && (string = string2.split("\\.")[0]).matches("[0-9]+") && Integer.parseInt(string) >= 9) {
                this.s.add("tif");
                this.s.add("tiff");
            }
            if (ServerPluginManager.getInstance().isPluginLoaded("jpeg2000")) {
                this.s.add("jp2");
            }
        }
        return this.s;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canRead(String fileName, File file) {
        boolean bl = false;
        for (String string : this.getSupportedFileExtensions()) {
            if (!fileName.toLowerCase().endsWith("." + string)) continue;
            bl = true;
            break;
        }
        if (!bl) return false;
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            do {
                if (!enumeration.hasMoreElements()) return false;
            } while (!b.a(enumeration.nextElement()));
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            try (FileImageInputStream fileImageInputStream = new FileImageInputStream(file);){
                boolean bl3 = ImageIO.getImageReaders(fileImageInputStream).hasNext();
                return bl3;
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean a(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return false;
        }
        string = string.substring(n + 1).toLowerCase();
        return r.contains(string);
    }

    public boolean canRead(String name, byte[] content) {
        return this.a(name, new ByteArrayInputStream(content));
    }

    public boolean canRead(String name, RandomAccessRead document) {
        return this.a(name, (InputStream)new RandomAccessReadInputStream(document, true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean a(String string, InputStream inputStream) {
        Object object;
        boolean bl = false;
        for (String string2 : this.getSupportedFileExtensions()) {
            if (!string.toLowerCase().endsWith("." + string2)) continue;
            bl = true;
            break;
        }
        if (!bl) return false;
        try {
            object = new MemoryCacheImageInputStream(inputStream);
            try {
                if (ImageIO.getImageReaders(object).hasNext()) {
                    boolean bl2 = true;
                    return bl2;
                }
            }
            finally {
                object.close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            inputStream.reset();
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            object = new ZipInputStream(inputStream);
            try {
                ZipEntry zipEntry;
                while ((zipEntry = ((ZipInputStream)object).getNextEntry()) != null) {
                    if (b.a(zipEntry)) {
                        boolean bl3 = true;
                        return bl3;
                    }
                    ((ZipInputStream)object).closeEntry();
                }
                return false;
            }
            finally {
                ((ZipInputStream)object).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Document readDocumentReduced(String userFileName, File file, String password, DocumentFactory.FEATURE ... requiredFeatures) throws DocumentFactory.PasswordException, PdfcException {
        if (requiredFeatures != null && !Arrays.asList(requiredFeatures).contains(DocumentFactory.FEATURE.images)) {
            return new a();
        }
        try (ZipFile zipFile = new ZipFile(file);){
            Object object;
            int n = 0;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                if (!b.a(enumeration.nextElement())) continue;
                ++n;
            }
            if (n == 0) {
                object = new FileImageInputStream(file);
                try {
                    if (ImageIO.getImageReaders(object).hasNext()) {
                        com.inet.pdfc.plugin.imageparser.a a2 = new com.inet.pdfc.plugin.imageparser.a(file);
                        return a2;
                    }
                }
                finally {
                    object.close();
                }
            }
            try {
                object = new c(new ZipFile(file), n);
                return object;
            }
            catch (IOException iOException) {
                throw PdfcException.create((Throwable)iOException);
            }
        }
        catch (IOException iOException) {
            return new com.inet.pdfc.plugin.imageparser.a(file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document readDocumentReduced(byte[] content, String userFileName, String password, DocumentFactory.FEATURE ... requiredFeatures) throws DocumentFactory.PasswordException, PdfcException {
        if (requiredFeatures != null && !Arrays.asList(requiredFeatures).contains(DocumentFactory.FEATURE.images)) {
            return new a();
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(content));){
            ZipEntry zipEntry;
            int n = 0;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (b.a(zipEntry)) {
                    ++n;
                }
                zipInputStream.closeEntry();
            }
            if (n == 0 && ImageIO.getImageReaders(new MemoryCacheImageInputStream(new ByteArrayInputStream(content))).hasNext()) {
                com.inet.pdfc.plugin.imageparser.a a2 = new com.inet.pdfc.plugin.imageparser.a(content);
                return a2;
            }
            c c2 = new c(new ZipInputStream(new ByteArrayInputStream(content)), n);
            return c2;
        }
        catch (IOException iOException) {
            return new com.inet.pdfc.plugin.imageparser.a(content);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document readDocumentReduced(String userFileName, RandomAccessRead document, String password, DocumentFactory.FEATURE ... requiredFeatures) throws DocumentFactory.PasswordException, PdfcException {
        if (requiredFeatures != null && !Arrays.asList(requiredFeatures).contains(DocumentFactory.FEATURE.images)) {
            return new a();
        }
        try (ZipInputStream zipInputStream = new ZipInputStream((InputStream)new RandomAccessReadInputStream(document, true));){
            Object object;
            ZipEntry zipEntry;
            int n = 0;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (b.a(zipEntry)) {
                    ++n;
                }
                zipInputStream.closeEntry();
            }
            document.seek(0L);
            if (n == 0) {
                object = new RandomAccessReadInputStream(document, true);
                try {
                    if (ImageIO.getImageReaders(new MemoryCacheImageInputStream((InputStream)object)).hasNext()) {
                        ((InputStream)object).reset();
                        com.inet.pdfc.plugin.imageparser.a a2 = new com.inet.pdfc.plugin.imageparser.a(document);
                        return a2;
                    }
                }
                finally {
                    ((InputStream)object).close();
                }
            }
            object = new c(new ZipInputStream((InputStream)new RandomAccessReadInputStream(document)), n);
            return object;
        }
        catch (IOException iOException) {
            return new com.inet.pdfc.plugin.imageparser.a(document);
        }
    }

    public String getDocumentTypeName(Locale locale) {
        return q.getMsg(locale, "plugin.image.docname", new Object[0]);
    }

    private static class a
    implements Document {
        private a() {
        }

        public Document.TextOrientation getTextOrientation() {
            return Document.TextOrientation.LEFTTORIGHT;
        }

        public void setProfile(IProfile profile) {
        }

        public EnumerationProgress getPages(DocumentProgressListener listener, int skip) {
            return new EnumerationProgress(){

                public Page nextElement() throws NoSuchElementException {
                    return null;
                }

                public boolean hasMoreElements() {
                    return false;
                }

                public double getProgress() {
                    return 0.0;
                }
            };
        }

        public void close() {
        }

        public int getEstimatedPageNum() {
            return 0;
        }
    }
}

