/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.xwpf.usermodel;

import com.inet.docx.document.utilities.Util;
import java.io.InputStream;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLanguage;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSettings;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTwipsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.SettingsDocument;

public class XWPFSettings {
    private static final int DEFAULTVALUE_TABSTOP = 720;
    private int tabStop = 720;
    private String listSeparator = ";";
    private boolean gutterAtTop = false;
    private boolean printTwoOnOne = false;
    private boolean mirrorMargins = false;
    private boolean hasEmbeddedTrueFont = false;
    private CTLanguage themeFontLang = null;

    public XWPFSettings() {
    }

    public XWPFSettings(PackagePart part) {
        try (InputStream is = part.getInputStream();){
            CTSettings settings = ((SettingsDocument)SettingsDocument.Factory.parse(is, POIXMLTypeLoader.DEFAULT_XML_OPTIONS)).getSettings();
            CTTwipsMeasure twips = settings.getDefaultTabStop();
            this.gutterAtTop = settings.isSetGutterAtTop();
            this.printTwoOnOne = settings.isSetPrintTwoOnOne();
            this.mirrorMargins = settings.isSetMirrorMargins();
            this.themeFontLang = settings.getThemeFontLang();
            this.tabStop = twips == null ? 720 : Util.getInt(twips.getVal());
            this.listSeparator = settings.getListSeparator() != null ? settings.getListSeparator().getVal() : ";";
            this.hasEmbeddedTrueFont = settings.isSetEmbedTrueTypeFonts();
        }
        catch (Exception ex) {
            Util.LOGGER.error((Throwable)ex);
        }
    }

    public int getDefaultTabStop() {
        return this.tabStop;
    }

    public String getListSeparator() {
        return this.listSeparator;
    }

    public boolean isGutterAtTop() {
        return this.gutterAtTop;
    }

    public boolean isPrintTwoOnOne() {
        return this.printTwoOnOne;
    }

    public boolean isMirrorMargins() {
        return this.mirrorMargins;
    }

    public boolean hasEmbeddedTrueFont() {
        return this.hasEmbeddedTrueFont;
    }

    public CTLanguage getThemeFontLang() {
        return this.themeFontLang;
    }
}

