/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.table;

import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.table.CellPageBreakPosition;
import java.util.Arrays;

public class TablePageBreakPosition {
    private int breakRow;
    private CellPageBreakPosition[] breakPoints;
    private boolean restartOnNextPage;

    public TablePageBreakPosition(int columnCount, int breakRow) {
        this.breakPoints = new CellPageBreakPosition[columnCount];
        this.breakRow = breakRow;
    }

    public TablePageBreakPosition() {
        this.restartOnNextPage = true;
    }

    public void setBreak(int startCol, int endCol, CellPageBreakPosition breakPos) {
        for (int i = startCol; i <= endCol; ++i) {
            this.breakPoints[i] = breakPos;
        }
    }

    public CellPageBreakPosition getCellBreak(int col) {
        if (this.breakPoints == null || this.breakPoints.length <= col) {
            if (this.breakPoints != null) {
                Util.LOGGER.debug((Object)("Wrong index of cellbreak. Not enought breakPoints available. The current lenght is " + this.breakPoints.length + " and it was looking for " + col));
            }
            return null;
        }
        return this.breakPoints[col];
    }

    public boolean isRestartOnNextPage() {
        return this.restartOnNextPage;
    }

    public boolean hasDisplayableContent() {
        for (int i = 0; i < this.breakPoints.length; ++i) {
            CellPageBreakPosition cellBreak = this.breakPoints[i];
            if (cellBreak == null || !cellBreak.isCellHasContent()) continue;
            return true;
        }
        return false;
    }

    public int getBreakRow() {
        return this.breakRow;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TablePageBreakPosition)) {
            return false;
        }
        TablePageBreakPosition other = (TablePageBreakPosition)obj;
        return other.breakRow == this.breakRow && Arrays.equals(this.breakPoints, other.breakPoints);
    }

    public String toString() {
        return "TableBreak: " + this.breakRow + " " + this.hasDisplayableContent();
    }
}

