/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.table;

import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.style.CellStyle;
import com.inet.docx.document.elements.subelements.Positionable;
import com.inet.docx.document.elements.subelements.table.TableCell;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.layout.AnchorManager;
import com.inet.docx.layout.DocumentLayouter;
import com.inet.docx.layout.LayoutElement;
import com.inet.docx.view.AreaObjects;
import com.inet.docx.view.DefaultRenderContext;
import com.inet.docx.view.PageElement;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.RenderContext;
import com.inet.docx.view.RenderPage;
import com.inet.docx.view.drawing.DrawingFactory;
import com.inet.docx.view.paragraph.ParagraphRow;
import com.inet.docx.view.paragraph.ParagraphView;
import com.inet.docx.view.table.CellPageBreakPosition;
import com.inet.docx.view.table.TableView;
import com.inet.docx.view.table.TableViewBorders;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class TableCellView
implements LayoutElement {
    private List<PageElement> content = new ArrayList<PageElement>();
    private TableCell source;
    private double xPos;
    private double yPos;
    private double intrinsicHeight;
    private double rowHeight;
    private double contentHeight = 0.0;
    private AreaObjects anchoredElements;
    private CellPageBreakPosition cpbpStart;
    private CellPageBreakPosition cpbpEnde;
    private Insets borders;

    public TableCellView(TableCell source, CellPageBreakPosition cpbpStart, CellPageBreakPosition cpbpEnde, TableViewBorders.CellBorders borders, RenderContext context) {
        this.source = source;
        this.cpbpStart = cpbpStart;
        this.cpbpEnde = cpbpEnde;
        this.borders = borders.getBorderSizes();
        List<DocumentElement> elements = source.getContent();
        int width = source.getWidth();
        Insets pageInsets = (Insets)source.getMargin().clone();
        pageInsets.top += this.borders.top;
        pageInsets.right += this.borders.right;
        pageInsets.left += this.borders.left;
        PageProperties props = new PageProperties(width, Integer.MAX_VALUE, pageInsets);
        context = new DefaultRenderContext(context.getDocumentProperties(), props, context, RenderContext.CONTEXT_TYPE.tableCell);
        List<RenderPage> pages = DocumentLayouter.layoutElements(elements, cpbpStart, cpbpEnde, context, true);
        if (pages.size() > 1) {
            Util.LOGGER.error((Object)"Cannot split content to pages inside a table cell!");
        }
        if (pages.size() >= 1) {
            RenderPage page = pages.get(0);
            this.contentHeight = page.getCurrentColumnContentHeight();
            this.content.addAll(page.getAllElements());
            AnchorManager anchorManager = page.getAnchorManager();
            if (anchorManager.hasElements()) {
                this.anchoredElements = new AreaObjects();
                anchorManager.getElements(this.anchoredElements);
            }
            if (pages.size() > 1 && Util.LOGGER.isDebug()) {
                Util.LOGGER.debug((Object)("The table cell '" + String.valueOf(source) + "' contains elements that cause a content/page break. Showing only the first part."));
            }
        }
        Insets margin = source.getMargin();
        int modelMinHeight = cpbpStart == null && cpbpEnde == null ? source.getHeight() : 0;
        this.intrinsicHeight = Math.max(this.contentHeight + (double)margin.top + (double)margin.bottom + (double)this.borders.top + (double)this.borders.bottom, (double)modelMinHeight);
        try {
            if (cpbpEnde != null) {
                this.getViewIndexFor(cpbpEnde.getBreakElement());
            }
            if (cpbpStart != null) {
                this.getViewIndexFor(cpbpStart.getBreakElement());
            }
        }
        catch (RuntimeException e) {
            Util.LOGGER.debug((Object)e);
        }
    }

    public TableCellView(TableCell source, TableViewBorders.CellBorders borders) {
        this.source = source;
        this.borders = borders.getBorderSizes();
        Insets marg = source.getMargin();
        this.intrinsicHeight = Math.max(marg.top + marg.bottom, source.getHeight()) + this.borders.top + this.borders.bottom;
    }

    @Override
    public double getMinKeepTogetherHeight() {
        return this.intrinsicHeight;
    }

    @Override
    public double getHeight() {
        return Math.max(this.rowHeight, this.intrinsicHeight);
    }

    @Override
    public void collectElements(List<Positionable> elements) {
        int startElement = 0;
        int endElement = this.content.size() - 1;
        Rectangle2D bounds = this.getCellBoundsInTwips();
        if (this.source.getCellStyle().getCellBackground() != null) {
            elements.add(DrawingFactory.createRectangle(bounds, this.source.getCellStyle().getCellBackground()));
        }
        for (int index = startElement; index <= endElement; ++index) {
            LayoutElement de = this.content.get(index);
            if (de instanceof ParagraphView) {
                ParagraphView prd = (ParagraphView)de;
                int startRow = 0;
                int endRow = prd.getRowCount();
                for (int i = startRow; i < endRow; ++i) {
                    ParagraphRow pr = prd.getRow(i);
                    pr.collectElements(elements);
                }
            }
            if (!(de instanceof TableView)) continue;
            elements.add((TableView)de);
        }
    }

    private int getViewIndexFor(DocumentElement element) {
        for (int i = 0; i < this.content.size(); ++i) {
            if (this.content.get(i).getSource() != element) continue;
            return i;
        }
        Util.LOGGER.warn((Object)("Break Consistency error in table cell '" + String.valueOf(this.source) + "', unable to find view for child element '" + String.valueOf(element) + "'"));
        return 0;
    }

    public void setComponentPosition(double x, double y) {
        int startElement = 0;
        int endElement = this.content.size() - 1;
        if (this.cpbpEnde != null) {
            endElement = this.getViewIndexFor(this.cpbpEnde.getBreakElement());
        }
        if (this.cpbpStart != null) {
            endElement -= this.getViewIndexFor(this.cpbpStart.getBreakElement());
        }
        double moveX = x - this.xPos;
        double moveY = y - this.yPos;
        this.xPos = x;
        this.yPos = y;
        if (this.content.size() == 0) {
            return;
        }
        for (int index = startElement; index <= endElement; ++index) {
            LayoutElement de = this.content.get(index);
            if (de instanceof Positionable) {
                Positionable prd = (Positionable)((Object)de);
                prd.move(moveX, moveY);
                continue;
            }
            Util.LOGGER.error((Object)de.getClass().getName());
        }
    }

    private Rectangle2D getCellBoundsInTwips() {
        double heightF = this.getHeight();
        double widthF = this.getWidth();
        double x = this.xPos;
        double y = this.yPos;
        return new Rectangle2D.Double(x, y, widthF, heightF);
    }

    public double getPositionX() {
        return this.xPos;
    }

    public double getPositionY() {
        return this.yPos;
    }

    public double getWidth() {
        return this.source.getWidth();
    }

    public int getColSpan() {
        return this.source.getEndColumn() - this.source.getStartColumn() + 1;
    }

    public int getRowSpan() {
        return this.source.getEndRow() - this.source.getStartRow() + 1;
    }

    public void setRowHeight(double rowHeight) {
        this.rowHeight = rowHeight;
        CellStyle style = this.source.getCellStyle();
        Insets margin = this.source.getMargin();
        double alignOffset = 0.0;
        if (STVerticalJc.BOTTOM == style.getVerticalAlign()) {
            alignOffset = this.getHeight() - this.contentHeight - (double)margin.bottom - (double)this.borders.bottom;
        } else if (STVerticalJc.CENTER == style.getVerticalAlign()) {
            alignOffset = (this.getHeight() - this.contentHeight - (double)margin.top - (double)this.borders.top - (double)margin.bottom - (double)this.borders.bottom) / 2.0 + (double)margin.top + (double)this.borders.top;
        }
        int endElement = this.content.size() - 1;
        if (this.cpbpEnde != null) {
            endElement = this.getViewIndexFor(this.cpbpEnde.getBreakElement());
        }
        if (this.cpbpStart != null) {
            endElement -= this.getViewIndexFor(this.cpbpStart.getBreakElement());
        }
        for (int index = 0; index <= endElement; ++index) {
            LayoutElement de = this.content.get(index);
            if (de instanceof Positionable) {
                Positionable prd = (Positionable)((Object)de);
                prd.move(0.0, alignOffset);
                continue;
            }
            Util.LOGGER.error((Object)de.getClass().getName());
        }
    }

    public List<PageElement> getContent() {
        return this.content;
    }

    public CellStyle getCellStyle() {
        return this.source.getCellStyle();
    }
}

