/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.log4j;

import com.inet.docx.document.utilities.Util;
import java.net.URI;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerContextFactory;

public class InetLog4JLoggerContextFactory
implements LoggerContextFactory {
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext) {
        return new BridgeLoggerContext();
    }

    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, URI configLocation, String name) {
        return new BridgeLoggerContext();
    }

    public void removeContext(LoggerContext context) {
    }

    private static class BridgeLoggerContext
    implements LoggerContext {
        private BridgeLoggerContext() {
        }

        public Object getExternalContext() {
            return null;
        }

        public ExtendedLogger getLogger(String name) {
            return new BridgeLogger();
        }

        public ExtendedLogger getLogger(String name, MessageFactory messageFactory) {
            return new BridgeLogger();
        }

        public boolean hasLogger(String name) {
            return true;
        }

        public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
            return true;
        }

        public boolean hasLogger(String name, MessageFactory messageFactory) {
            return true;
        }
    }

    private static class BridgeLogger
    extends AbstractLogger {
        private BridgeLogger() {
        }

        private Level getPDFClevel() {
            switch (Util.LOGGER.getLogLevel()) {
                case 4: {
                    return Level.DEBUG;
                }
                case 1: {
                    return Level.WARN;
                }
                case 0: {
                    return Level.FATAL;
                }
                case 3: {
                    return Level.INFO;
                }
                case -1: {
                    return Level.OFF;
                }
                case 2: {
                    return Level.WARN;
                }
            }
            return Level.WARN;
        }

        public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
            return level.intLevel() >= this.getPDFClevel().intLevel();
        }

        public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
            if (level.intLevel() < this.getPDFClevel().intLevel()) {
                return;
            }
            this.logInternal(level, message.getFormattedMessage());
            if (message.getThrowable() != null) {
                this.logInternal(level, message.getThrowable());
            }
        }

        private void logInternal(Level level, Object message) {
            if (level.intLevel() <= Level.OFF.intLevel()) {
                return;
            }
            if (level.intLevel() <= Level.FATAL.intLevel()) {
                Util.LOGGER.fatal(message);
                return;
            }
            if (level.intLevel() <= Level.ERROR.intLevel()) {
                Util.LOGGER.error(message);
                return;
            }
            if (level.intLevel() <= Level.WARN.intLevel()) {
                Util.LOGGER.warn(message);
                return;
            }
            if (level.intLevel() <= Level.INFO.intLevel()) {
                Util.LOGGER.info(message);
                return;
            }
            Util.LOGGER.debug(message);
        }

        public Level getLevel() {
            return this.getPDFClevel();
        }
    }
}

