/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.excel;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.style.CellBorder;
import com.inet.docx.document.elements.style.CellStyle;
import com.inet.docx.document.elements.style.Indent;
import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.LineStyle;
import com.inet.docx.document.elements.style.ParagraphAndRunStyle;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.elements.subelements.EmptyRow;
import com.inet.docx.document.elements.subelements.TextRowElement;
import com.inet.docx.document.elements.subelements.drawing.DrawingContent;
import com.inet.docx.document.elements.subelements.table.TableBorder;
import com.inet.docx.document.elements.subelements.table.TableCell;
import com.inet.docx.document.excel.coditional.ConditionalFormatingHandler;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.paragraph.StringLayouter;
import com.inet.docx.document.table.TableData;
import com.inet.docx.document.utilities.Util;
import java.awt.Color;
import java.awt.Insets;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTOleSize;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRElt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class WorkbookAnalyzer {
    private static int HAIR_LINE = 5;
    private static int THIN_LINE = 10;
    private static int MEDIUM_LINE = 15;
    private static int THICK_LINE = 30;
    private static int DEFAULT_CELL_PIXCEL = 86;
    public static final Insets TWO_PIXEL_MARGINS = new Insets(0, 30, 30, 30);
    private static final LineProperties GRID_LINE = new LineProperties(new Color(211, 211, 211), LineStyle.SINGLE, false, THIN_LINE, 0.0);
    private TableData tableData;
    private CellStyle defaultCellStyle;
    private ThemesTable themesTable;
    private XSSFFormulaEvaluator formulaEvaluator;
    private ConditionalFormatingHandler cfh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkbookAnalyzer(PackagePart pp, DrawingContent dc, DocumentProperties documentProperties) {
        InputStream is = null;
        try {
            is = pp.getInputStream();
            XSSFWorkbook wb = new XSSFWorkbook(is);
            CTWorkbook ctWb = wb.getCTWorkbook();
            this.formulaEvaluator = new XSSFFormulaEvaluator(wb);
            XSSFSheet activeSheet = wb.getSheetAt(wb.getActiveSheetIndex());
            CTOleSize os = ctWb.getOleSize();
            String[] refs = os.getRef().split(":");
            StylesTable st = wb.getStylesSource();
            XSSFFont defaultFont = st.getFontAt(0);
            IndexSizeAndStyle[] rows = this.getRows(activeSheet, refs);
            IndexSizeAndStyle[] columns = this.getColumns(activeSheet, refs, defaultFont, documentProperties);
            int[] columnSizes = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                columnSizes[i] = columns[i].getSize();
            }
            this.themesTable = wb.getTheme();
            this.cfh = new ConditionalFormatingHandler(this.themesTable, st.getIndexedColors());
            TableBorder tb = TableBorder.getDefaultBorders();
            if (ctWb.getWorkbookPr().getShowInkAnnotation()) {
                tb.setBottomLine(GRID_LINE);
                tb.setTopLine(GRID_LINE);
                tb.setLeftLine(GRID_LINE);
                tb.setRightLine(GRID_LINE);
                tb.setInsideHorizontal(GRID_LINE);
                tb.setInsideVertical(GRID_LINE);
            }
            this.defaultCellStyle = WorkbookAnalyzer.getCellStyle(defaultFont, this.themesTable);
            this.defaultCellStyle.setBorder(CellBorder.merge(tb, null));
            this.tableData = new TableData(columnSizes, rows.length, 0, null, null, null, TWO_PIXEL_MARGINS, 0, null, this.defaultCellStyle);
            this.tableData.setBorders(tb);
            this.tableData.setExcelStyle(true);
            this.analyzeCells(activeSheet, rows, columns);
        }
        catch (Exception ex) {
            Util.LOGGER.error((Throwable)ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public TableData getTable() {
        return this.tableData;
    }

    private TableCell createCell(XSSFCell cell, int colIndex, int rowIndex, XSSFCellStyle cellStyle, XSSFCellStyle rowStyle, XSSFCellStyle columnStyle) {
        TableCell tc = new TableCell(this.tableData, colIndex, rowIndex, WorkbookAnalyzer.getCellStyle(cellStyle.getFont(), this.themesTable));
        Color bgColor = Util.convertXssfColor(cellStyle.getFillForegroundXSSFColor());
        tc.getCellStyle().setCellBackground(bgColor);
        tc.getCellStyle().setBorder(this.getBorders(rowStyle, columnStyle, cellStyle));
        this.cfh.handleConditionalFormating(tc, cell);
        tc.addElement(this.getCellContent(cell, tc.getCellStyle()));
        return tc;
    }

    private int getIndex(IndexSizeAndStyle object, IndexSizeAndStyle[] units) {
        for (int i = 0; i < units.length; ++i) {
            if (object != units[i]) continue;
            return i;
        }
        return -1;
    }

    private void analyzeCells(XSSFSheet activeSheet, IndexSizeAndStyle[] rows, IndexSizeAndStyle[] columns) {
        XSSFCell cell;
        try {
            this.cfh.init(activeSheet, this.formulaEvaluator, rows, columns);
        }
        catch (Exception ex) {
            Util.LOGGER.error((Throwable)ex);
        }
        for (CellRangeAddress destRegion : activeSheet.getMergedRegions()) {
            List<IndexSizeAndStyle> visibleColumns = WorkbookAnalyzer.getVisible(destRegion.getFirstColumn(), destRegion.getLastColumn(), columns);
            List<IndexSizeAndStyle> visibleRows = WorkbookAnalyzer.getVisible((short)destRegion.getFirstRow(), (short)destRegion.getLastRow(), rows);
            if (visibleColumns.size() <= 0 || visibleRows.size() <= 0) continue;
            XSSFRow row = activeSheet.getRow(destRegion.getFirstRow());
            cell = row.getCell(destRegion.getFirstColumn());
            int internalColumnIndex = this.getIndex(visibleColumns.get(0), columns);
            int internalRowIndex = this.getIndex(visibleRows.get(0), rows);
            TableCell tc = this.createCell(cell, internalColumnIndex, internalRowIndex, cell.getCellStyle(), row.getRowStyle(), columns[internalColumnIndex].getStyle());
            tc.setEndRow(internalRowIndex + visibleRows.size() - 1);
            tc.setEndColumn(internalColumnIndex + visibleColumns.size() - 1);
            tc.setHeight(rows[internalRowIndex].getSize(), true);
            int displayWidth = 0;
            for (IndexSizeAndStyle visCol : visibleColumns) {
                displayWidth += visCol.getSize();
            }
            tc.setWidth(displayWidth);
            this.tableData.addCell(tc);
        }
        for (int internalRowNumber = 0; internalRowNumber < rows.length; ++internalRowNumber) {
            XSSFRow row = activeSheet.getRow((int)rows[internalRowNumber].getIndex());
            XSSFCellStyle rowStyle = rows[internalRowNumber].getStyle();
            for (int internalColumnIndex = 0; internalColumnIndex < columns.length; ++internalColumnIndex) {
                TableCell tc;
                short columnIndex = columns[internalColumnIndex].getIndex();
                if (this.tableData.getCell(internalColumnIndex, internalRowNumber) != null) continue;
                cell = row != null ? row.getCell((int)columnIndex) : null;
                XSSFCellStyle cellStyle = null;
                if (cell != null) {
                    cellStyle = cell.getCellStyle();
                    tc = this.createCell(cell, internalColumnIndex, internalRowNumber, cellStyle, rowStyle, columns[internalColumnIndex].getStyle());
                } else {
                    tc = new TableCell(this.tableData, internalColumnIndex, internalRowNumber, this.defaultCellStyle.clone());
                    ParagraphData pd = WorkbookAnalyzer.createParagraph();
                    RunRenderInformations textRenderInformations = this.defaultCellStyle.getFontStyle().getTextRenderInformations();
                    pd.setFontRenderInfos(textRenderInformations);
                    pd.addElement(new EmptyRow(textRenderInformations.createFont(this.defaultCellStyle.getFontStyle())));
                    tc.addElement(pd);
                    tc.getCellStyle().setBorder(this.getBorders(rowStyle, columns[internalColumnIndex].getStyle(), null));
                }
                tc.setHeight(rows[internalRowNumber].getSize(), true);
                tc.setWidth(columns[internalColumnIndex].getSize());
                this.tableData.addCell(tc);
            }
        }
    }

    private CellBorder getBorders(XSSFCellStyle rowStyle, XSSFCellStyle columnStyle, XSSFCellStyle cellStyle) {
        LineProperties topL;
        LineProperties rightL;
        LineProperties leftL;
        LineProperties bottomL;
        if (cellStyle != null) {
            bottomL = WorkbookAnalyzer.convertLineStyle(cellStyle.getBorderBottom(), cellStyle.getBottomBorderXSSFColor());
            leftL = WorkbookAnalyzer.convertLineStyle(cellStyle.getBorderLeft(), cellStyle.getLeftBorderXSSFColor());
            rightL = WorkbookAnalyzer.convertLineStyle(cellStyle.getBorderRight(), cellStyle.getRightBorderXSSFColor());
            topL = WorkbookAnalyzer.convertLineStyle(cellStyle.getBorderTop(), cellStyle.getTopBorderXSSFColor());
        } else if (rowStyle != null) {
            bottomL = WorkbookAnalyzer.convertLineStyle(rowStyle.getBorderBottom(), rowStyle.getBottomBorderXSSFColor());
            leftL = WorkbookAnalyzer.convertLineStyle(rowStyle.getBorderLeft(), rowStyle.getLeftBorderXSSFColor());
            rightL = WorkbookAnalyzer.convertLineStyle(rowStyle.getBorderRight(), rowStyle.getRightBorderXSSFColor());
            topL = WorkbookAnalyzer.convertLineStyle(rowStyle.getBorderTop(), rowStyle.getTopBorderXSSFColor());
        } else if (columnStyle != null) {
            bottomL = WorkbookAnalyzer.convertLineStyle(columnStyle.getBorderBottom(), columnStyle.getBottomBorderXSSFColor());
            leftL = WorkbookAnalyzer.convertLineStyle(columnStyle.getBorderLeft(), columnStyle.getLeftBorderXSSFColor());
            rightL = WorkbookAnalyzer.convertLineStyle(columnStyle.getBorderRight(), columnStyle.getRightBorderXSSFColor());
            topL = WorkbookAnalyzer.convertLineStyle(columnStyle.getBorderTop(), columnStyle.getTopBorderXSSFColor());
        } else {
            leftL = rightL = LineProperties.EMPTY_LINE;
            bottomL = rightL;
            topL = rightL;
        }
        return new CellBorder(topL, leftL, bottomL, rightL);
    }

    private ParagraphData getCellContent(XSSFCell cell, CellStyle cellStyle) {
        cellStyle.setCanGrowVertical(false);
        XSSFCellStyle excelCellStyle = cell.getCellStyle();
        cellStyle.setTextWraping(excelCellStyle.getWrapText());
        VerticalAlignment vertAlign = excelCellStyle.getVerticalAlignment();
        STVerticalJc.Enum vAlign = "TOP".equals(vertAlign.toString()) ? STVerticalJc.TOP : ("CENTER".equals(vertAlign.toString()) ? STVerticalJc.CENTER : STVerticalJc.BOTTOM);
        cellStyle.setVerticalAlign(vAlign);
        HorizontalAlignment horAlign = excelCellStyle.getAlignment();
        String hAlign = horAlign.toString().toLowerCase();
        RunRenderInformations textRenderInformations = cellStyle.getFontStyle().getTextRenderInformations();
        ParagraphData pd = WorkbookAnalyzer.createParagraph();
        pd.setHorizontalAlign(hAlign);
        pd.setFontRenderInfos(textRenderInformations);
        RenderFont rf = textRenderInformations.createFont(this.defaultCellStyle.getFontStyle());
        switch (cell.getCellType()) {
            case STRING: {
                XSSFRichTextString rts = cell.getRichStringCellValue();
                if (rts.getCTRst().sizeOfRArray() > 0) {
                    List rList = rts.getCTRst().getRList();
                    for (int i = 0; i < rList.size(); ++i) {
                        XSSFFont fontDef = rts.getFontOfFormattingRun(i);
                        textRenderInformations = fontDef != null ? RunRenderInformations.createRenderInformations(fontDef, this.themesTable) : cellStyle.getFontStyle().getTextRenderInformations();
                        TextRowElement tre = new TextRowElement(((CTRElt)rList.get(i)).getT(), textRenderInformations.createFont(this.defaultCellStyle.getFontStyle()), textRenderInformations.getFontColor(), null);
                        pd.addElement(tre);
                    }
                    break;
                }
                TextRowElement tre = new TextRowElement(rts.getCTRst().getT(), rf, textRenderInformations.getFontColor(), null);
                pd.addElement(tre);
                break;
            }
            case NUMERIC: {
                String displayValue = WorkbookAnalyzer.getNumberValue(excelCellStyle.getDataFormatString(), cell.getNumericCellValue(), cell);
                TextRowElement tre = new TextRowElement(displayValue, rf, textRenderInformations.getFontColor(), null);
                pd.addElement(tre);
                if (!"general".equals(hAlign)) break;
                pd.setHorizontalAlign("right");
                break;
            }
            case BLANK: {
                pd.addElement(new EmptyRow(rf));
                break;
            }
            case BOOLEAN: {
                TextRowElement tre = new TextRowElement(cell.getBooleanCellValue() ? "TRUE" : "FALSE", rf, textRenderInformations.getFontColor(), null);
                pd.addElement(tre);
                if (!"general".equals(hAlign)) break;
                pd.setHorizontalAlign("center");
                break;
            }
            case FORMULA: {
                CellValue cv = this.formulaEvaluator.evaluate((Cell)cell);
                WorkbookAnalyzer.setDisplayValueForFormula(cv, excelCellStyle.getDataFormatString(), cell, rf, pd, hAlign, textRenderInformations.getFontColor());
            }
        }
        return pd;
    }

    private IndexSizeAndStyle[] getRows(XSSFSheet activeSheet, String[] refs) {
        short startRow = WorkbookAnalyzer.geRowIndex(refs[0]);
        short endRow = WorkbookAnalyzer.geRowIndex(refs[1]);
        ArrayList<IndexSizeAndStyle> displayedRows = new ArrayList<IndexSizeAndStyle>();
        short defaultHeight = activeSheet.getDefaultRowHeight();
        for (short index = startRow; index <= endRow; index = (short)(index + 1)) {
            short height;
            XSSFRow row = activeSheet.getRow((int)index);
            short s = height = row != null ? row.getHeight() : defaultHeight;
            if (height <= 0 || row != null && row.getZeroHeight()) continue;
            displayedRows.add(new IndexSizeAndStyle(index, height, row != null ? row.getRowStyle() : null));
        }
        return displayedRows.toArray(new IndexSizeAndStyle[displayedRows.size()]);
    }

    private IndexSizeAndStyle[] getColumns(XSSFSheet activeSheet, String[] refs, XSSFFont defaultFont, DocumentProperties documentProperties) {
        int defaultColumnCharCount = activeSheet.getDefaultColumnWidth();
        RenderFont fontInfo = WorkbookAnalyzer.getRenderFont(defaultFont);
        StringLayouter sl = documentProperties.getLayouter(fontInfo);
        double maxCharWitdth = 0.0;
        for (int i = 0; i < 10; ++i) {
            maxCharWitdth = Math.max(maxCharWitdth, sl.getTextLength(String.valueOf(i)));
        }
        short startColumn = WorkbookAnalyzer.getColumnIndex(refs[0]);
        short endColumn = WorkbookAnalyzer.getColumnIndex(refs[1]);
        ArrayList<IndexSizeAndStyle> displayedColumns = new ArrayList<IndexSizeAndStyle>();
        for (short index = startColumn; index <= endColumn; index = (short)(index + 1)) {
            int width = activeSheet.getColumnWidth((int)index);
            if (width <= 0 || activeSheet.isColumnHidden((int)index)) continue;
            double charCount = (double)width / 256.0;
            int colWith = charCount == (double)defaultColumnCharCount ? DEFAULT_CELL_PIXCEL * 15 : (int)(charCount * maxCharWitdth);
            displayedColumns.add(new IndexSizeAndStyle(index, colWith, (XSSFCellStyle)activeSheet.getColumnStyle((int)index)));
        }
        return displayedColumns.toArray(new IndexSizeAndStyle[displayedColumns.size()]);
    }

    private static CellStyle getCellStyle(XSSFFont fontDef, ThemesTable tt) {
        RunRenderInformations textRenderInformations = RunRenderInformations.createRenderInformations(fontDef, tt);
        ParagraphAndRunStyle cellFont = new ParagraphAndRunStyle(textRenderInformations, new ParagraphAndRunStyle(RunRenderInformations.getEmpty(), null));
        cellFont.setName("excel_default");
        CellStyle cs = new CellStyle(cellFont, null);
        cs.setMargin(TWO_PIXEL_MARGINS);
        return cs;
    }

    private static RenderFont getRenderFont(XSSFFont fontDef) {
        int fontStyle = (fontDef.getBold() ? 1 : 0) + (fontDef.getItalic() ? 2 : 0);
        return new RenderFont(fontDef.getFontName(), fontDef.getFontHeightInPoints(), fontStyle, null, fontDef.getStrikeout(), false, false, 0.0, 1.0, 0);
    }

    private static short getColumnIndex(String cellName) {
        int result = 0;
        int index = 0;
        while (cellName.charAt(index) >= 'A') {
            result = result * 26 + cellName.charAt(index) - 64;
            ++index;
        }
        return (short)(result - 1);
    }

    private static short geRowIndex(String cellName) {
        int index = 0;
        while (cellName.charAt(index) >= 'A') {
            ++index;
        }
        return (short)(Integer.parseInt(cellName.substring(index)) - 1);
    }

    private static SimpleDateFormat getDateFormaterForPattern(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        String defaultPattern = sdf.toPattern();
        if ("m/d/yy".equals(pattern)) {
            pattern = defaultPattern.substring(0, defaultPattern.indexOf(32));
            pattern = pattern.replace("yy", "yyyy");
        } else if ("d/m/yy\\ h:mm;@".equals(pattern)) {
            pattern = defaultPattern.replace("HH", "H");
        }
        return new SimpleDateFormat(pattern);
    }

    private static void setDisplayValueForFormula(CellValue cellValue, String pattern, XSSFCell cell, RenderFont renderFont, ParagraphData pd, String hAlign, Color fontColor) {
        switch (cellValue.getCellType()) {
            case NUMERIC: {
                String displayValue = WorkbookAnalyzer.getNumberValue(pattern, cellValue.getNumberValue(), cell);
                pd.addElement(new TextRowElement(displayValue, renderFont, fontColor, null));
                if (!"general".equals(hAlign)) break;
                pd.setHorizontalAlign("right");
                break;
            }
            case BLANK: {
                pd.addElement(new EmptyRow(renderFont));
                break;
            }
            case BOOLEAN: {
                pd.addElement(new TextRowElement(cellValue.getBooleanValue() ? "TRUE" : "FALSE", renderFont, fontColor, null));
                if (!"general".equals(hAlign)) break;
                pd.setHorizontalAlign("center");
                break;
            }
            case STRING: {
                pd.addElement(new TextRowElement(cellValue.getStringValue(), renderFont, fontColor, null));
            }
        }
    }

    private static String getNumberValue(String pattern, double d, XSSFCell cell) {
        try {
            if (DateUtil.isValidExcelDate((double)d) && DateUtil.isCellDateFormatted((Cell)cell, null)) {
                boolean date1904 = cell.getSheet().getWorkbook().isDate1904();
                Date date = DateUtil.getJavaDate((double)d, (boolean)date1904);
                SimpleDateFormat format = WorkbookAnalyzer.getDateFormaterForPattern(pattern);
                return format.format((Object)date);
            }
            if ("General".equals(pattern)) {
                pattern = "#.##";
            }
            return new DecimalFormat(pattern).format(d);
        }
        catch (Throwable ex) {
            Util.LOGGER.warn((Object)("Unsupported Pattern '" + pattern + "' for the value " + d));
            return "" + d;
        }
    }

    public static LineProperties convertLineStyle(BorderStyle bStyle, XSSFColor xColor) {
        Color color = Util.convertXssfColor(xColor);
        switch (bStyle) {
            case THIN: {
                return new LineProperties(color, LineStyle.SINGLE, false, THIN_LINE, 0.0);
            }
            case MEDIUM: {
                return new LineProperties(color, LineStyle.SINGLE, false, MEDIUM_LINE, 0.0);
            }
            case DASHED: {
                return new LineProperties(color, LineStyle.DASHED, false, THIN_LINE, 0.0);
            }
            case DOTTED: {
                return new LineProperties(color, LineStyle.DOTTED, false, HAIR_LINE, 0.0);
            }
            case THICK: {
                return new LineProperties(color, LineStyle.SINGLE, false, THICK_LINE, 0.0);
            }
            case DOUBLE: {
                return new LineProperties(color, LineStyle.DOUBLE, false, THICK_LINE, 0.0);
            }
            case HAIR: {
                return new LineProperties(color, LineStyle.SINGLE, false, HAIR_LINE, 0.0);
            }
            case MEDIUM_DASHED: {
                return new LineProperties(color, LineStyle.DASHED, false, MEDIUM_LINE, 0.0);
            }
            case DASH_DOT: {
                return new LineProperties(color, LineStyle.DOTDASH, false, HAIR_LINE, 0.0);
            }
            case DASH_DOT_DOT: {
                return new LineProperties(color, LineStyle.DOTDOTDASH, false, HAIR_LINE, 0.0);
            }
            case MEDIUM_DASH_DOT: {
                return new LineProperties(color, LineStyle.DOTDASH, false, MEDIUM_LINE, 0.0);
            }
            case MEDIUM_DASH_DOT_DOT: {
                return new LineProperties(color, LineStyle.DOTDOTDASH, false, MEDIUM_LINE, 0.0);
            }
            case SLANTED_DASH_DOT: {
                return new LineProperties(color, LineStyle.DOTDASH, false, THICK_LINE, 0.0);
            }
        }
        return LineProperties.EMPTY_LINE;
    }

    private static ParagraphData createParagraph() {
        ParagraphData pd = new ParagraphData();
        pd.setIndent(new Indent(0, 0, 0, 0));
        pd.setSpacing(Spacing.getDefaultSpacing());
        return pd;
    }

    public static List<IndexSizeAndStyle> getVisible(int start, int end, IndexSizeAndStyle[] units) {
        ArrayList<IndexSizeAndStyle> visibleEntrys = new ArrayList<IndexSizeAndStyle>();
        for (IndexSizeAndStyle unit : units) {
            if (unit.getIndex() < start || unit.getIndex() > end) continue;
            visibleEntrys.add(unit);
        }
        return visibleEntrys;
    }

    public class IndexSizeAndStyle {
        private short index;
        private int size;
        private XSSFCellStyle style;

        private IndexSizeAndStyle(short index, int size, XSSFCellStyle style) {
            this.index = index;
            this.size = size;
            this.style = style;
        }

        protected int getSize() {
            return this.size;
        }

        public short getIndex() {
            return this.index;
        }

        public XSSFCellStyle getStyle() {
            return this.style;
        }
    }
}

