/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements;

import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import com.inet.docx.document.elements.subelements.Positionable;
import com.inet.docx.document.elements.subelements.drawing.Anchor;
import com.inet.docx.document.elements.subelements.drawing.DimensionDefinition;
import com.inet.docx.document.elements.subelements.drawing.TextWrapping;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.RenderContext;
import com.inet.docx.view.drawing.BorderLineExternalWidths;
import com.inet.docx.view.drawing.DrawingElement;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Drawing
extends Positionable
implements ParagraphElement,
DrawingElement {
    private ParagraphElement.ParagraphElementType type = ParagraphElement.ParagraphElementType.DRAWING;
    private TextWrapping textWrapping = TextWrapping.NONE;
    private TextWrapping.Side textWrappingSide = TextWrapping.Side.BOTHSIDE;
    private DrawingElement content = null;
    private boolean isBackground = false;
    private Insets textWrappingInsets = new Insets(0, 0, 0, 0);
    private Shape wrappingPolygon = null;
    private DimensionDefinition heightValue;
    private DimensionDefinition widthValue;
    private Anchor anchorVertical;
    private Anchor anchorHorizontal;
    private RenderFont renderFont;
    private long zOrder = 0L;
    private static Anchor.Reference[] paragraphSpecific = new Anchor.Reference[]{Anchor.Reference.paragraph, Anchor.Reference.character, Anchor.Reference.line, Anchor.Reference.text};

    public Drawing(DimensionDefinition width, DimensionDefinition height, RenderFont renderFont, Anchor anchorVertical, Anchor anchorHorizontal) {
        this.renderFont = renderFont;
        this.widthValue = width;
        this.heightValue = height;
        this.anchorHorizontal = anchorHorizontal;
        this.anchorVertical = anchorVertical;
        if (Util.isDebugMode) {
            Util.LOGGER.debug((Object)("Drawing = " + String.valueOf(width) + " x " + String.valueOf(height)));
        }
    }

    public Drawing(double width, double height) {
        this(new DimensionDefinition(width), new DimensionDefinition(height), null, null, null);
    }

    @Override
    public RenderFont getRenderFont() {
        return this.renderFont;
    }

    @Override
    public boolean isBackground() {
        return this.isBackground;
    }

    @Override
    public TextWrapping getTextWrapping() {
        return this.textWrapping;
    }

    @Override
    public TextWrapping.Side getTextWrappingSide() {
        return this.textWrappingSide;
    }

    public DrawingElement getContent() {
        return this.content;
    }

    public DimensionDefinition getHeightValue() {
        return this.heightValue;
    }

    public DimensionDefinition getWidthValue() {
        return this.widthValue;
    }

    public Anchor getAnchorVertical() {
        return this.anchorVertical;
    }

    public Anchor getAnchorHorizontal() {
        return this.anchorHorizontal;
    }

    @Nullable
    public Shape getWrappingPolygon() {
        return this.wrappingPolygon;
    }

    @Override
    public void setBackground(boolean background) {
        this.isBackground = background;
    }

    @Override
    public List<DrawingElement> getElements() {
        ArrayList<DrawingElement> list = new ArrayList<DrawingElement>();
        list.add(this.content);
        return list;
    }

    @Override
    public AffineTransform getTransformation() {
        return new AffineTransform();
    }

    @Override
    public void setTextWrapping(TextWrapping textWrapping) {
        this.textWrapping = textWrapping;
    }

    @Override
    public void setTextWrappingSide(TextWrapping.Side textWrappingSide) {
        this.textWrappingSide = textWrappingSide;
    }

    public void setContent(@Nonnull DrawingElement elements) {
        if (this.content != null) {
            throw new IllegalStateException("Drawing content can not override!");
        }
        this.content = elements;
    }

    public void setWrappingPolygon(Shape wrappingPolygon) {
        this.wrappingPolygon = wrappingPolygon;
    }

    @Override
    public boolean isAnchored() {
        return this.anchorHorizontal != null && this.anchorVertical != null;
    }

    public boolean isAnchorParagraphSpecific() {
        if (this.isAnchored()) {
            for (Anchor.Reference reference : paragraphSpecific) {
                if (!(this.anchorVertical.getOffsetValue() >= 0.0) || this.anchorVertical.getReferencePosition() != reference) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ParagraphElement.ParagraphElementType getElementType() {
        return this.type;
    }

    @Override
    public double getHeight() {
        if (this.content == null) {
            if (this.heightValue == null) {
                Util.LOGGER.error((Object)"Can not read the height for the drawing object. No content");
                return 0.0;
            }
            return this.heightValue.getValue();
        }
        if (this.content.getBoundsShape() == null) {
            Util.LOGGER.error((Object)"Can not read the height for the drawing object. No content shape.");
            return 0.0;
        }
        return this.content.getBoundsShape().getBounds().getHeight();
    }

    @Override
    public Shape getBoundsShape() {
        if (this.content == null) {
            return new Rectangle2D.Double(this.getPageX(), this.getPageY(), this.getWidth(), this.getHeight());
        }
        Shape contentShape = this.content.getBoundsShape();
        return new AffineTransform(0.0, 0.0, 0.0, 0.0, this.getPageX(), this.getPageY()).createTransformedShape(contentShape);
    }

    public Shape getCalcBoundsShape(RenderContext context) {
        double pageY;
        BorderLineExternalWidths borderLineWidths = this.getBorderLineExternalWidths();
        boolean oddPage = context.getInSectionPageNumber() % 2 != 0;
        double width = this.widthValue.calculateValue(context.getPageLayout(), oddPage);
        double height = this.heightValue.calculateValue(context.getPageLayout(), oddPage);
        double pageX = this.anchorHorizontal == null ? this.getPageX() : this.anchorHorizontal.getPositionValue(context.getPageLayout(), width, this.getPageX(), oddPage, borderLineWidths);
        double d = pageY = this.anchorVertical == null ? this.getPageY() : this.anchorVertical.getPositionValue(context.getPageLayout(), height, this.getPageY(), oddPage, borderLineWidths);
        Shape contentShape = this.content == null ? new Rectangle2D.Double(0.0, 0.0, width, height) : (this.wrappingPolygon == null ? this.content.getBoundsShape() : this.content.getTransformation().createTransformedShape(this.wrappingPolygon));
        return AffineTransform.getTranslateInstance(pageX, pageY).createTransformedShape(contentShape);
    }

    @Override
    public Point2D getPosition() {
        return new Point2D.Double(this.getPageX(), this.getPageY());
    }

    public void setTextWrappingInsets(Insets textWrappingInsets) {
        this.textWrappingInsets = textWrappingInsets;
    }

    public Insets getWrappingInsets() {
        return this.textWrappingInsets;
    }

    @Override
    public double getBaseline() {
        return this.getHeight();
    }

    @Override
    public void setHeight(double height) {
        this.heightValue = new DimensionDefinition(height);
    }

    @Override
    public void setWidth(double width) {
        this.widthValue = new DimensionDefinition(width);
    }

    @Override
    public double getWidth() {
        if (this.content == null) {
            if (this.widthValue == null) {
                Util.LOGGER.error((Object)"Can not read the width for the drawing object.  No content");
                return 0.0;
            }
            return this.widthValue.getValue();
        }
        if (this.content.getBoundsShape() == null) {
            Util.LOGGER.error((Object)"Can not read the width for the drawing object.  No content shape.");
            return 0.0;
        }
        return this.content.getBoundsShape().getBounds().getWidth();
    }

    public long getzOrder() {
        return this.zOrder;
    }

    public void setzOrder(long zOrder) {
        this.zOrder = zOrder;
    }

    @Override
    public void setPageY(double pageY) {
        super.setPageY(pageY);
        this.updatePositionData();
    }

    @Override
    public void setPageX(double pageX) {
        super.setPageX(pageX);
        this.updatePositionData();
    }

    private void updatePositionData() {
        if (Util.isDebugMode) {
            Util.LOGGER.debug((Object)(String.valueOf(this) + " position was updated => " + (double)((int)(this.getPageX() * 100.0)) / 100.0 + " x " + (double)((int)(this.getPageY() * 100.0)) / 100.0));
        }
    }

    @Override
    public void move(double xOffset, double yOffset) {
        super.move(xOffset, yOffset);
        this.updatePositionData();
    }

    @Override
    public BorderLineExternalWidths getBorderLineExternalWidths() {
        if (this.content == null) {
            return new BorderLineExternalWidths(0.0);
        }
        return this.content.getBorderLineExternalWidths();
    }

    public String toString() {
        return "Drawing{type=" + String.valueOf((Object)this.type) + ", pageX=" + this.getPageX() + ", pageY=" + this.getPageY() + ", heightValue=" + String.valueOf(this.heightValue) + ", widthValue=" + String.valueOf(this.widthValue) + ", anchorVertical=" + String.valueOf(this.anchorVertical) + ", anchorHorizontal=" + String.valueOf(this.anchorHorizontal) + ", textWrapping=" + String.valueOf((Object)this.textWrapping) + ", textWrappingSide=" + String.valueOf((Object)this.textWrappingSide) + ", content=" + String.valueOf(this.content) + "}";
    }
}

