/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements;

import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBrType;

public class Break
implements ParagraphElement {
    private BreakType type;
    private RenderFont renderFont;

    public Break(STBrType.Enum type, RenderFont renderFont) {
        this.type = Break.getType(type);
        this.renderFont = renderFont;
    }

    @Override
    public RenderFont getRenderFont() {
        return this.renderFont;
    }

    public BreakType getType() {
        return this.type;
    }

    @Override
    public ParagraphElement.ParagraphElementType getElementType() {
        return ParagraphElement.ParagraphElementType.Break;
    }

    public String toString() {
        return String.valueOf((Object)this.getElementType()) + " " + String.valueOf((Object)this.type);
    }

    public boolean isLayoutBreak() {
        return this.type == BreakType.page || this.type == BreakType.column;
    }

    @Override
    public boolean isAnchored() {
        return false;
    }

    public ParagraphElement clone() {
        return this;
    }

    private static BreakType getType(STBrType.Enum type) {
        if (type != null) {
            if (STBrType.PAGE.equals(type)) {
                return BreakType.page;
            }
            if (STBrType.COLUMN.equals(type)) {
                return BreakType.column;
            }
        }
        return BreakType.textWrapping;
    }

    public static enum BreakType {
        page,
        column,
        textWrapping;

    }
}

