/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.utilities.UnitNumber;
import com.inet.docx.document.utilities.Util;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextVerticalType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextWrappingType;

public class ShapeBodyProperties {
    private UnitNumber top;
    private UnitNumber left;
    private UnitNumber bottom;
    private UnitNumber right;
    private double rotation;
    private Anchor anchor = Anchor.t;
    private VerticalText vertical = VerticalText.horz;
    private STTextWrappingType.Enum wrap;

    public ShapeBodyProperties(CTTextBodyProperties bodypr) {
        STTextVerticalType.Enum vert;
        this.top = new UnitNumber(this.getOrDefault(bodypr.getTIns(), 45720.0), UnitNumber.Unit.EMU);
        this.bottom = new UnitNumber(this.getOrDefault(bodypr.getBIns(), 45720.0), UnitNumber.Unit.EMU);
        this.left = new UnitNumber(this.getOrDefault(bodypr.getLIns(), 91440.0), UnitNumber.Unit.EMU);
        this.right = new UnitNumber(this.getOrDefault(bodypr.getRIns(), 91440.0), UnitNumber.Unit.EMU);
        this.rotation = Math.toRadians(bodypr.getRot() / 60000);
        STTextAnchoringType.Enum anch = bodypr.getAnchor();
        if (anch != null) {
            this.setAnchor(anch.toString());
        }
        if ((vert = bodypr.getVert()) != null) {
            this.setVerticalText(vert.toString());
        }
        this.wrap = bodypr.getWrap();
    }

    private double getOrDefault(Object value, double defaultValue) {
        return value == null ? defaultValue : Util.getDouble(value);
    }

    private void setAnchor(String anchor) {
        try {
            this.anchor = Anchor.valueOf(anchor);
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException("Not implemented anchor type '" + anchor + "'");
            ex.initCause(e);
            Util.LOGGER.error((Throwable)ex);
        }
    }

    private void setVerticalText(String verticalText) {
        try {
            this.vertical = VerticalText.valueOf(verticalText);
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException("Not implemented vertical text type '" + verticalText + "'");
            ex.initCause(e);
            Util.LOGGER.error((Throwable)ex);
        }
    }

    public VerticalText getVerticalText() {
        return this.vertical;
    }

    public boolean isVerticalText() {
        return this.vertical == VerticalText.vert || this.vertical == VerticalText.vert270 || this.vertical == VerticalText.eaVert;
    }

    public double getContentRotation() {
        switch (this.vertical) {
            case vert270: {
                return Math.toRadians(270.0);
            }
            case eaVert: 
            case vert: {
                return Math.toRadians(90.0);
            }
        }
        return this.rotation;
    }

    public int getTopMargin() {
        return (int)this.top.getAsTwips();
    }

    public int getLeftMargin() {
        return (int)this.left.getAsTwips();
    }

    public int getBottomMargin() {
        return (int)this.bottom.getAsTwips();
    }

    public int getRightMargin() {
        return (int)this.right.getAsTwips();
    }

    public Anchor getAnchorType() {
        return this.anchor;
    }

    public boolean isTextWrap() {
        return this.wrap == STTextWrappingType.SQUARE;
    }

    public static enum Anchor {
        t,
        ctr,
        b;

    }

    public static enum VerticalText {
        horz,
        vert,
        vert270,
        eaVert;

    }
}

