/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.style.Indent;
import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.NumberingLevel;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.elements.style.Style;
import com.inet.docx.document.elements.style.TextFrame;
import com.inet.docx.document.elements.subelements.BorderLines;
import com.inet.docx.document.elements.subelements.Tab;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STVerticalAlignRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;

public class ParagraphAndRunStyle
implements Style {
    private ParagraphAndRunStyle parentStyle;
    private ParagraphAndRunStyle defaultStyle;
    private ParagraphAndRunStyle linkStyle;
    private Spacing spacing;
    private Indent indent;
    private List<Tab> tabData;
    private String name;
    private Boolean keepParagraphOnTheSamePage;
    private Boolean keepParagraphTogetherWithNextParagraph;
    private Boolean pageBreakBefore;
    private Boolean contextualSpacing;
    private Boolean widowControl;
    private STJc.Enum horAlign;
    private NumberingLevel numberingLevel;
    private RunRenderInformations textRenderInformations;
    private BorderLines border;
    private TextFrame textFrame;

    public ParagraphAndRunStyle(RunRenderInformations textRenderInformations, ParagraphAndRunStyle defaultStyle) {
        this.textRenderInformations = textRenderInformations;
        this.defaultStyle = defaultStyle;
    }

    public ParagraphAndRunStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public RunRenderInformations getTextRenderInformations() {
        return this.textRenderInformations;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setParentFontStyle(ParagraphAndRunStyle style) {
        this.parentStyle = style;
    }

    public void setLinkStyle(ParagraphAndRunStyle linkStyle) {
        this.linkStyle = linkStyle;
    }

    public Float getFontSize() {
        if (this.textRenderInformations.getFontSize() != null) {
            return this.textRenderInformations.getFontSize();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getFontSize();
        }
        return null;
    }

    protected Boolean getBold() {
        if (this.textRenderInformations.getBold() != null) {
            return this.textRenderInformations.getBold();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getBold();
        }
        return null;
    }

    private int getBoldValue() {
        Boolean boldValue = this.getBold();
        if (boldValue != null) {
            return boldValue != false ? 1 : 0;
        }
        return 0;
    }

    private int getItalicValue() {
        Boolean italicValue = this.getItalic();
        if (italicValue != null) {
            return italicValue != false ? 2 : 0;
        }
        return 0;
    }

    protected Boolean getItalic() {
        if (this.textRenderInformations.getItalic() != null) {
            return this.textRenderInformations.getItalic();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getItalic();
        }
        return null;
    }

    public int getFontStyle() {
        return this.getBoldValue() + this.getItalicValue();
    }

    public String getFontName() {
        if (this.textRenderInformations.getFontName() != null) {
            return this.textRenderInformations.getFontName();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getFontName();
        }
        return null;
    }

    public Color getFontColor() {
        if (this.textRenderInformations.getFontColor() != null) {
            return this.textRenderInformations.getFontColor();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getFontColor();
        }
        return null;
    }

    public Spacing getParagraphSpacing(boolean defaultSpacing) {
        if (this.spacing == null) {
            if (this.parentStyle != null) {
                return this.parentStyle.getParagraphSpacing(defaultSpacing);
            }
            if (defaultSpacing) {
                return this.defaultStyle.spacing;
            }
        } else {
            if (this.parentStyle != null) {
                return Spacing.mergeSpacing(this.spacing, this.parentStyle.getParagraphSpacing(defaultSpacing));
            }
            if (defaultSpacing && this.defaultStyle != null) {
                return Spacing.mergeSpacing(this.spacing, this.defaultStyle.spacing);
            }
        }
        return this.spacing;
    }

    public Float getFontSpacing() {
        if (this.textRenderInformations.getFontSpacing() != null) {
            return this.textRenderInformations.getFontSpacing();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getFontSpacing();
        }
        return null;
    }

    public Boolean getCaps() {
        if (this.textRenderInformations.getCaps() != null) {
            return this.textRenderInformations.getCaps();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getCaps();
        }
        return null;
    }

    public Boolean getSmallCaps() {
        if (this.textRenderInformations.getSmallCaps() != null) {
            return this.textRenderInformations.getSmallCaps();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getSmallCaps();
        }
        return null;
    }

    public void setSpacing(Spacing spacing) {
        this.spacing = spacing;
    }

    public void setIndent(Indent indent) {
        this.indent = indent;
    }

    public Indent getIndent() {
        if (this.indent == null && this.parentStyle != null) {
            return this.parentStyle.getIndent();
        }
        if (this.indent == null && this.defaultStyle != null) {
            return this.defaultStyle.getIndent();
        }
        return this.indent;
    }

    public boolean isKeepParagraphOnTheSamePage() {
        if (this.keepParagraphOnTheSamePage == null && this.parentStyle != null) {
            return this.parentStyle.isKeepParagraphOnTheSamePage();
        }
        if (this.keepParagraphOnTheSamePage != null) {
            return this.keepParagraphOnTheSamePage;
        }
        return false;
    }

    public void setKeepParagraphOnTheSamePage() {
        this.keepParagraphOnTheSamePage = Boolean.TRUE;
    }

    public boolean isKeepParagraphTogetherWithNextParagraph() {
        if (this.keepParagraphTogetherWithNextParagraph == null && this.parentStyle != null) {
            return this.parentStyle.isKeepParagraphTogetherWithNextParagraph();
        }
        if (this.keepParagraphTogetherWithNextParagraph != null) {
            return this.keepParagraphTogetherWithNextParagraph;
        }
        return false;
    }

    public void setKeepParagraphTogetherWithNextParagraph() {
        this.keepParagraphTogetherWithNextParagraph = Boolean.TRUE;
    }

    public boolean isPageBreakBefore() {
        if (this.pageBreakBefore == null && this.parentStyle != null) {
            return this.parentStyle.isPageBreakBefore();
        }
        if (this.pageBreakBefore != null) {
            return this.pageBreakBefore;
        }
        return false;
    }

    public void setPageBreakBefore() {
        this.pageBreakBefore = Boolean.TRUE;
    }

    public LineProperties getUnderline() {
        if (this.textRenderInformations.getUnderline() != null) {
            return this.textRenderInformations.getUnderline();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getUnderline();
        }
        return null;
    }

    public Boolean getVanish() {
        if (this.textRenderInformations.getVanish() != null) {
            return this.textRenderInformations.getVanish();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getVanish();
        }
        return null;
    }

    public Boolean getStrikethrough() {
        if (this.textRenderInformations.getStrikethrough() != null) {
            return this.textRenderInformations.getStrikethrough();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getStrikethrough();
        }
        return null;
    }

    public Boolean getContextualSpacing() {
        if (this.contextualSpacing == null && this.parentStyle != null) {
            return this.parentStyle.getContextualSpacing();
        }
        if (this.contextualSpacing != null) {
            return this.contextualSpacing;
        }
        return null;
    }

    public void setContextualSpacing(Boolean contextualSpacing) {
        this.contextualSpacing = contextualSpacing;
    }

    public Boolean getWidowControl() {
        if (this.widowControl == null && this.parentStyle != null) {
            return this.parentStyle.getWidowControl();
        }
        if (this.widowControl != null) {
            return this.widowControl;
        }
        return null;
    }

    public void setWidowControl(Boolean widowControl) {
        this.widowControl = widowControl;
    }

    public List<Tab> getTabData() {
        if (this.tabData != null) {
            ArrayList<Tab> newList = new ArrayList<Tab>();
            for (Tab tab : this.tabData) {
                newList.add((Tab)tab.clone());
            }
            return newList;
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getTabData();
        }
        return null;
    }

    public void setTabData(List<Tab> tabData) {
        this.tabData = tabData;
    }

    public STJc.Enum getHorAlign() {
        if (this.horAlign == null && this.parentStyle != null) {
            return this.parentStyle.getHorAlign();
        }
        return this.horAlign;
    }

    public BorderLines getBorder() {
        if (this.border == null && this.parentStyle != null) {
            return this.parentStyle.getBorder();
        }
        return this.border;
    }

    public void setBorder(BorderLines border) {
        this.border = border;
    }

    public TextFrame getTextFrame() {
        if (this.parentStyle != null) {
            return TextFrame.merge(this.textFrame, this.parentStyle.getTextFrame());
        }
        return this.textFrame;
    }

    public void setTextFrame(TextFrame textFrame) {
        this.textFrame = textFrame;
    }

    public void setHorAlign(STJc.Enum horAlign) {
        this.horAlign = horAlign;
    }

    public STVerticalAlignRun.Enum getVerticalAlign() {
        if (this.textRenderInformations.getVerticalAlign() != null) {
            return this.textRenderInformations.getVerticalAlign();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getVerticalAlign();
        }
        return null;
    }

    public Float getTextScale() {
        if (this.textRenderInformations.getTextScale() != null) {
            return this.textRenderInformations.getTextScale();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getTextScale();
        }
        return null;
    }

    public Integer getVerticalPosition() {
        if (this.textRenderInformations.getVerticalPosition() != null) {
            return this.textRenderInformations.getVerticalPosition();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getVerticalPosition();
        }
        return null;
    }

    public Color getFontBackgroundColor() {
        if (this.textRenderInformations.getFontBackgroundColor() != null) {
            return this.textRenderInformations.getFontBackgroundColor();
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getFontBackgroundColor();
        }
        return null;
    }

    public ParagraphAndRunStyle clone() {
        ParagraphAndRunStyle copy = new ParagraphAndRunStyle(this.textRenderInformations, this.defaultStyle);
        copy.parentStyle = this.parentStyle;
        copy.spacing = this.spacing;
        copy.indent = this.indent;
        copy.contextualSpacing = this.contextualSpacing;
        copy.widowControl = this.widowControl;
        copy.keepParagraphOnTheSamePage = this.keepParagraphOnTheSamePage;
        copy.keepParagraphTogetherWithNextParagraph = this.keepParagraphTogetherWithNextParagraph;
        copy.pageBreakBefore = this.pageBreakBefore;
        copy.tabData = this.tabData;
        copy.horAlign = this.horAlign;
        copy.name = this.name;
        copy.numberingLevel = this.numberingLevel;
        copy.border = this.border;
        copy.textFrame = this.textFrame;
        return copy;
    }

    @Override
    public Style getParentStyle() {
        return this.parentStyle;
    }

    public void setNumbering(NumberingLevel numberingLevel) {
        this.numberingLevel = numberingLevel;
    }

    public NumberingLevel getNumberingLevel() {
        return this.numberingLevel;
    }

    public static ParagraphAndRunStyle mergeFontInfos(CTRPr rpr, DocumentProperties docprops, ParagraphAndRunStyle parentFont, String name) {
        if (rpr != null) {
            RunRenderInformations rri = RunRenderInformations.getRenderInformations(rpr, docprops);
            if (parentFont != null) {
                ParagraphAndRunStyle mergedFontInfos = parentFont.clone();
                mergedFontInfos.textRenderInformations = RunRenderInformations.mergeRenderInformations(rri, parentFont);
                mergedFontInfos.setName(mergedFontInfos.getName() + "-" + name);
                return mergedFontInfos;
            }
            ParagraphAndRunStyle standardStyle = docprops.getStandardStyleFont();
            ParagraphAndRunStyle prs = new ParagraphAndRunStyle(rri, standardStyle.defaultStyle);
            prs.setName(name);
            prs.setIndent(standardStyle.getIndent());
            prs.setSpacing(standardStyle.spacing);
            return prs;
        }
        return parentFont;
    }

    public static ParagraphAndRunStyle mergeStyles(ParagraphAndRunStyle primaryStyle, ParagraphAndRunStyle secondaryStyle) {
        if (primaryStyle.name.equals(secondaryStyle.name) || primaryStyle.name.contains(secondaryStyle.name)) {
            return primaryStyle;
        }
        RunRenderInformations tri = RunRenderInformations.mergeRenderInformations(primaryStyle, secondaryStyle);
        ParagraphAndRunStyle mergedStyle = new ParagraphAndRunStyle(tri, primaryStyle.defaultStyle);
        mergedStyle.spacing = Spacing.mergeSpacing(primaryStyle.getParagraphSpacing(false), secondaryStyle.getParagraphSpacing(false));
        mergedStyle.indent = primaryStyle.getIndent() != null ? primaryStyle.getIndent() : secondaryStyle.getIndent();
        mergedStyle.tabData = primaryStyle.getTabData();
        mergedStyle.setName(primaryStyle.getName() + "-" + secondaryStyle.getName());
        mergedStyle.keepParagraphOnTheSamePage = primaryStyle.isKeepParagraphOnTheSamePage() || secondaryStyle.isKeepParagraphOnTheSamePage() ? Boolean.TRUE : Boolean.FALSE;
        mergedStyle.keepParagraphTogetherWithNextParagraph = primaryStyle.isKeepParagraphTogetherWithNextParagraph() || secondaryStyle.isKeepParagraphTogetherWithNextParagraph() ? Boolean.TRUE : Boolean.FALSE;
        mergedStyle.pageBreakBefore = primaryStyle.isPageBreakBefore() || secondaryStyle.isPageBreakBefore() ? Boolean.TRUE : Boolean.FALSE;
        mergedStyle.contextualSpacing = primaryStyle.contextualSpacing != null ? primaryStyle.contextualSpacing : secondaryStyle.contextualSpacing;
        mergedStyle.widowControl = primaryStyle.widowControl != null ? primaryStyle.widowControl : secondaryStyle.widowControl;
        mergedStyle.horAlign = primaryStyle.getHorAlign() != null ? primaryStyle.getHorAlign() : secondaryStyle.getHorAlign();
        mergedStyle.numberingLevel = primaryStyle.getNumberingLevel() != null ? primaryStyle.getNumberingLevel() : secondaryStyle.getNumberingLevel();
        mergedStyle.border = primaryStyle.getBorder() != null ? primaryStyle.getBorder() : secondaryStyle.getBorder();
        mergedStyle.textFrame = TextFrame.merge(primaryStyle.getTextFrame(), secondaryStyle.getTextFrame());
        return mergedStyle;
    }
}

