/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.style.Indent;
import com.inet.docx.document.elements.style.ParagraphAndRunStyle;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.subelements.Tab;
import com.inet.docx.document.utilities.NumberFormating;
import com.inet.docx.document.utilities.Util;
import java.util.ArrayList;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumFmt;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrGeneral;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabs;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;

public class NumberingLevel {
    private String markerText;
    private STJc.Enum justification = STJc.LEFT;
    private STNumberFormat.Enum numFmt;
    private int currentValue;
    private int start;
    private ParagraphAndRunStyle style;
    private int key;
    private int level;
    private Indent indent;
    private NumberingLevel childLvl;
    private ArrayList<Tab> tabs;
    private boolean isReplace = false;

    private NumberingLevel(long key, int level) {
        this.key = (int)key;
        this.level = level;
    }

    public void updateKey(long key) {
        if (!this.isReplacement()) {
            return;
        }
        this.key = (int)key;
    }

    public NumberingLevel(CTLvl data, DocumentProperties props, long key, int level) {
        this(key, level);
        this.start = 0;
        if (data.isSetStart()) {
            this.start = Util.getValueIfNotNull(data.getStart().getVal(), 0);
            --this.start;
        }
        this.currentValue = this.start;
        if (data.isSetLvlText()) {
            this.markerText = data.getLvlText().getVal();
        }
        if (data.isSetNumFmt()) {
            CTNumFmt nf = data.getNumFmt();
            this.numFmt = nf.getVal();
        }
        if (data.isSetLvlJc()) {
            try {
                this.justification = data.getLvlJc().getVal();
            }
            catch (Exception nf) {
                // empty catch block
            }
        }
        if (data.isSetPStyle()) {
            String styleName = data.getPStyle().getVal();
            this.style = props.getStyleFont(styleName);
            this.style.setNumbering(this);
        }
        if (data.isSetRPr()) {
            if (this.style == null) {
                this.style = new ParagraphAndRunStyle(RunRenderInformations.getRenderInformations(data.getRPr(), props), props.getDefaultStyleFont());
                this.style.setName("numbering_" + key + "_" + level);
            } else {
                this.style = ParagraphAndRunStyle.mergeFontInfos(data.getRPr(), props, this.style, "numbering_" + key + "_" + level);
            }
        }
        if (data.isSetPPr()) {
            CTTabs cttabs;
            CTPPrGeneral ppr = data.getPPr();
            if (ppr.isSetInd()) {
                this.indent = Util.getIndent(ppr.getInd(), new Indent(null, null, null, null));
            }
            if ((cttabs = ppr.getTabs()) != null) {
                RenderFont rf = this.style != null && this.style.getTextRenderInformations() != null ? this.style.getTextRenderInformations().createFont(props) : null;
                this.tabs = Util.getTabs(cttabs, rf);
            }
        }
    }

    public void setChild(NumberingLevel childLvl) {
        this.childLvl = childLvl;
    }

    public int getKey() {
        return this.key;
    }

    public int getLevel() {
        return this.level;
    }

    public Indent getIndent() {
        return this.indent;
    }

    public ArrayList<Tab> getTabs() {
        return this.tabs;
    }

    public ParagraphAndRunStyle getStyleFont() {
        return this.style;
    }

    public String getDisplayValue() {
        return this.markerText;
    }

    public STNumberFormat.Enum getDisplayFormat() {
        return this.numFmt;
    }

    public STJc.Enum getJustification() {
        return this.justification;
    }

    public int getCurrentValue(boolean increment) {
        if (increment || this.currentValue == this.start) {
            ++this.currentValue;
            if (increment && this.childLvl != null) {
                this.childLvl.resetValue();
            }
        }
        return this.currentValue;
    }

    public void resetCount() {
        --this.currentValue;
    }

    private void resetValue() {
        this.currentValue = this.start;
        if (this.childLvl != null) {
            this.childLvl.resetValue();
        }
    }

    public boolean isReplacement() {
        return this.isReplace;
    }

    public NumberingLevel clone() {
        NumberingLevel theClone = new NumberingLevel(this.key, this.level);
        theClone.markerText = this.markerText;
        theClone.justification = this.justification;
        theClone.numFmt = this.numFmt;
        theClone.start = this.start;
        theClone.currentValue = this.currentValue;
        theClone.style = this.style;
        theClone.indent = this.indent;
        theClone.tabs = this.tabs;
        theClone.isReplace = true;
        return theClone;
    }

    public NumberingLevel merge(CTNumLvl override, DocumentProperties props) {
        CTDecimalNumber startO = override.getStartOverride();
        CTLvl data = override.getLvl();
        if (startO != null) {
            NumberingLevel merge = this.clone();
            merge.start = startO.getVal().intValue() - 1;
            merge.currentValue = this.start;
            return merge;
        }
        if (data != null) {
            NumberingLevel replace = new NumberingLevel(data, props, this.key, this.level);
            replace.isReplace = true;
            return replace;
        }
        return this;
    }

    public static String handleNumberingDisplaxText(String baseText, DocumentProperties documentProperties, int key, int lvl) {
        NumberingLevel levelNumbering = documentProperties.getNumberingLevel(key, lvl);
        if (STNumberFormat.BULLET.equals(levelNumbering.getDisplayFormat())) {
            return levelNumbering.getDisplayValue();
        }
        int levelValue = levelNumbering.getCurrentValue(false);
        baseText = NumberingLevel.replaceLevel(baseText, lvl, NumberFormating.getFormatedValue(levelNumbering.getDisplayFormat(), levelValue));
        if (lvl > 0) {
            return NumberingLevel.handleNumberingDisplaxText(baseText, documentProperties, key, lvl - 1);
        }
        return baseText;
    }

    private static String replaceLevel(String text, int lvl, String replacement) {
        String key = "%" + (lvl + 1);
        if (text.contains(key)) {
            return text.replace(key, replacement);
        }
        return text;
    }
}

