/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.utilities.Util;
import java.util.HashMap;
import java.util.Map;

public class LineStyle {
    private static final Map<String, LineStyle> LINE_STYLE_MAP = new HashMap<String, LineStyle>();
    public static final LineStyle NONE = new LineStyle(0, 0, "none");
    public static final LineStyle NIL = new LineStyle(0, 1, "nil");
    public static final LineStyle SINGLE = new LineStyle(1, 2, "single", "solid", "sng");
    public static final LineStyle THICK = new LineStyle(1, 3, "thick");
    public static final LineStyle DOUBLE = new LineStyle(2, 4, "double");
    public static final LineStyle DOTTED = new LineStyle(1, 5, "dotted", "dottedHeavy", "sysDot");
    public static final LineStyle DASHED = new LineStyle(1, 6, "dashed", "dashedHeavy", "dash");
    public static final LineStyle DASHEDSMALL = new LineStyle(1, 7, "sysDash");
    public static final LineStyle DOTDASH = new LineStyle(1, 8, "dotDash", "dashDotHeavy", "dashDot", "sysDashDot");
    public static final LineStyle DOTDASHLONG = new LineStyle(1, 9, "lgDashDot");
    public static final LineStyle DOTDOTDASH = new LineStyle(1, 10, "dotDotDash", "dashDotDotHeavy", "sysDashDotDot", "lgDashDotDot");
    public static final LineStyle TRIPLE = new LineStyle(3, 11, "triple");
    public static final LineStyle THINTHICKSMALLGAP = new LineStyle(2, 12, "thinThickSmallGap");
    public static final LineStyle THICKTHINSMALLGAP = new LineStyle(2, 13, "thickThinSmallGap");
    public static final LineStyle THINTHICKTHINSMALLGAP = new LineStyle(3, 14, "thinThickThinSmallGap");
    public static final LineStyle THINTHICKMEDIUMGAP = new LineStyle(2, 15, "thinThickMediumGap");
    public static final LineStyle THICKTHINMEDIUMGAP = new LineStyle(2, 16, "thickThinMediumGap");
    public static final LineStyle THINTHICKTHINMEDIUMGAP = new LineStyle(3, 17, "thinThickThinMediumGap");
    public static final LineStyle THINTHICKLARGEGAP = new LineStyle(2, 18, "thinThickLargeGap");
    public static final LineStyle THICKTHINLARGEGAP = new LineStyle(2, 19, "thickThinLargeGap");
    public static final LineStyle THINTHICKTHINLARGEGAP = new LineStyle(3, 20, "thinThickThinLargeGap");
    public static final LineStyle WAVE = new LineStyle(1, 21, "wave", "wavyHeavy");
    public static final LineStyle DOUBLEWAVE = new LineStyle(2, 22, "doubleWave", "wavyDouble");
    public static final LineStyle DASHSMALLGAP = new LineStyle(1, 23, "dashSmallGap");
    public static final LineStyle DASHDOTSTROKED = new LineStyle(1, 24, "dashDotStroked");
    public static final LineStyle THREEDEMBOSS = new LineStyle(3, 25, "threeDEmboss");
    public static final LineStyle THREEDENGRAVE = new LineStyle(3, 26, "threeDEngrave");
    public static final LineStyle DASHLONG = new LineStyle(1, 29, "dashLong", "dashLongHeavy", "lgDash");
    public static final LineStyle DOT = new LineStyle(1, 31, "dot");
    public static final LineStyle OUTSET = new LineStyle(2, 27, "outset");
    public static final LineStyle INSET = new LineStyle(2, 28, "inset");
    public static final LineStyle WORDS = new LineStyle(1, 30, "words");
    public static final LineStyle IMAGE = new LineStyle(1, 32, "image");
    private final int lineCount;
    private final int weight;

    private LineStyle(int lineCount, int weight, String ... keys) {
        this.lineCount = lineCount;
        this.weight = weight;
        for (String key : keys) {
            LINE_STYLE_MAP.put(key.toLowerCase(), this);
        }
    }

    public int getWeight() {
        return this.weight;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public static LineStyle getStyle(String key) {
        LineStyle style;
        LineStyle lineStyle = style = key != null ? LINE_STYLE_MAP.get(key.toLowerCase()) : SINGLE;
        if (style == null && key != null) {
            Util.LOGGER.warn((Object)("Line style '" + key + "' is unknown"));
            return SINGLE;
        }
        return style;
    }
}

