/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf.records.object;

import com.inet.emf.EmfGraphic;
import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfUtil;
import com.inet.emf.GraphicObject;
import com.inet.emf.records.object.BaseObjectModifier;
import java.awt.BasicStroke;
import java.awt.Color;

public class CreatePenRecord
extends BaseObjectModifier
implements GraphicObject {
    protected int style;
    protected int width;
    protected Color color;

    private BasicStroke getStroke() {
        int cap;
        int n = PenStyleEndcap.getValue(this.style) == PenStyleEndcap.ROUND ? 1 : (cap = PenStyleEndcap.getValue(this.style) == PenStyleEndcap.SQUARE ? 2 : 0);
        int join = PenStyleJoin.getValue(this.style) == PenStyleJoin.ROUND ? 1 : (PenStyleJoin.getValue(this.style) == PenStyleJoin.BEVEL ? 2 : 0);
        return new BasicStroke(this.width, cap, join);
    }

    public CreatePenRecord() {
    }

    public CreatePenRecord(PenStyleLine styleLine, PenStyleJoin styleJoin, PenStyleEndcap endcap, PenStyleOptional styleOptional, Color color) {
        this.style = styleLine.id + styleJoin.id + endcap.id + styleOptional.id;
        this.color = color;
    }

    @Override
    public void readContent(byte[] source, int offset) {
        this.ihObject = EmfUtil.read4BytesInteger(source, offset);
        this.style = EmfUtil.read4BytesInteger(source, offset + 4);
        this.width = EmfUtil.read4BytesInteger(source, offset + 8);
        this.color = EmfUtil.readColor(source, offset + 12);
    }

    @Override
    public void execute(EmfRecordExecutor executor) {
        executor.setGraphicObject(this.ihObject, this);
    }

    @Override
    public void changeGraphics(EmfGraphic graphics2D) {
        if (PenStyleLine.getValue(this.style) != PenStyleLine.NULL) {
            graphics2D.setStroke(this.getStroke());
            graphics2D.setForeground(this.color);
        }
    }

    @Override
    public String toString() {
        return "CreatePenRecord{type=" + this.getType() + ", size=" + this.getSize() + ", ihPen=" + this.ihObject + ", style=" + this.style + ", width=" + this.width + ", stroke=" + String.valueOf(this.getStroke()) + ", color=" + String.valueOf(this.color) + "}";
    }

    public static enum PenStyleEndcap {
        ROUND(0),
        SQUARE(256),
        FLAT(512);

        private final int id;

        private PenStyleEndcap(int id) {
            this.id = id;
        }

        public static PenStyleEndcap getValue(int id) {
            id &= 0x300;
            for (PenStyleEndcap value : PenStyleEndcap.values()) {
                if (value.id != id) continue;
                return value;
            }
            EmfUtil.getLogger().debug((Object)("PenStyleEndcap with the id " + id + " didn't exist"));
            return ROUND;
        }
    }

    public static enum PenStyleJoin {
        ROUND(0),
        BEVEL(4096),
        MITER(8192);

        private final int id;

        private PenStyleJoin(int id) {
            this.id = id;
        }

        public static PenStyleJoin getValue(int id) {
            id &= 0x3000;
            for (PenStyleJoin value : PenStyleJoin.values()) {
                if (value.id != id) continue;
                return value;
            }
            EmfUtil.getLogger().debug((Object)("PenStyleJoin with the id " + id + " didn't exist"));
            return ROUND;
        }
    }

    public static enum PenStyleLine {
        SOLID(0),
        DASH(1),
        DOT(2),
        DASHDOT(3),
        DASHDOTDOT(4),
        NULL(5),
        INSIDEFRAME(6),
        USERSTYLE(7),
        ALTERNATE(8);

        private final int id;

        private PenStyleLine(int id) {
            this.id = id;
        }

        public static PenStyleLine getValue(int id) {
            id &= 0xFF;
            for (PenStyleLine value : PenStyleLine.values()) {
                if (value.id != id) continue;
                return value;
            }
            EmfUtil.getLogger().debug((Object)("PenStyleLine with the id " + id + " didn't exist"));
            return SOLID;
        }
    }

    public static enum PenStyleOptional {
        COSMETIC(0),
        GEOMETRIC(65536);

        private final int id;

        private PenStyleOptional(int id) {
            this.id = id;
        }

        public static PenStyleOptional getValue(int id) {
            id &= 0x10000;
            for (PenStyleOptional value : PenStyleOptional.values()) {
                if (value.id != id) continue;
                return value;
            }
            EmfUtil.getLogger().debug((Object)("PenStyleOptional with the id " + id + " didn't exist"));
            return COSMETIC;
        }
    }
}

