/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf.records;

import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfRecords;
import com.inet.emf.EmfUtil;
import java.awt.geom.AffineTransform;

public class ModifyWorldTransform
extends EmfRecords {
    private AffineTransform transform;
    private ModifyMode modifWorldTransformMode;

    @Override
    public void readContent(byte[] source, int offset) {
        double m11 = EmfUtil.read4BytesFloatingPoint(source, offset);
        double m12 = EmfUtil.read4BytesFloatingPoint(source, offset + 4);
        double m21 = EmfUtil.read4BytesFloatingPoint(source, offset + 8);
        double m22 = EmfUtil.read4BytesFloatingPoint(source, offset + 12);
        double dx = EmfUtil.read4BytesFloatingPoint(source, offset + 16);
        double dy = EmfUtil.read4BytesFloatingPoint(source, offset + 20);
        this.transform = new AffineTransform(m11, m21, m12, m22, dx, dy);
        this.modifWorldTransformMode = ModifyMode.getValue(EmfUtil.read4BytesInteger(source, offset + 24));
    }

    @Override
    public void execute(EmfRecordExecutor executor) {
    }

    @Override
    public String toString() {
        return "ModifyWorldTransform{type=" + this.getType() + ", size=" + this.getSize() + ", ModifWorldTransformMode=" + String.valueOf((Object)this.modifWorldTransformMode) + ", transform=" + String.valueOf(this.transform) + "}";
    }

    static enum ModifyMode {
        MWT_IDENTITY(1),
        MWT_LEFTMULTIPLY(2),
        MWT_RIGHTMULTIPLY(3),
        MWT_SET(4);

        private final int id;

        private ModifyMode(int id) {
            this.id = id;
        }

        public static ModifyMode getValue(int id) {
            for (ModifyMode value : ModifyMode.values()) {
                if (value.id != id) continue;
                return value;
            }
            EmfUtil.getLogger().debug((Object)("ModifyMode with the id " + id + " didn't exist"));
            return MWT_IDENTITY;
        }
    }
}

