/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf;

import com.inet.emf.EMFDecoder;
import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfRecords;
import com.inet.emf.GraphicObject;
import com.inet.emf.records.ModifyWorldTransform;
import com.inet.emf.records.StrokePathRecord;
import com.inet.emf.records.bitmap.StretchDiBitsRecord;
import com.inet.emf.records.drawing.LineToRecord;
import com.inet.emf.records.drawing.MoveToExRecord;
import com.inet.emf.records.drawing.PathRecord;
import com.inet.emf.records.drawing.PolyBezierToRecord;
import com.inet.emf.records.drawing.PolygonRecord;
import com.inet.emf.records.drawing.PolylineRecord;
import com.inet.emf.records.header.HeaderRecord;
import com.inet.emf.records.object.CreateBrushIndirect;
import com.inet.emf.records.object.CreatePenRecord;
import com.inet.emf.records.object.ExtCreatePen;
import com.inet.emf.records.object.StockGraphicObject;
import com.inet.emf.records.object.manipulate.DeleteObject;
import com.inet.emf.records.object.manipulate.SelectObject;
import com.inet.emf.records.state.SetBKMode;
import com.inet.emf.records.state.SetMapMode;
import com.inet.emf.records.state.SetPolyfillModeRecord;
import com.inet.emf.records.state.SetWindowExtEx;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class EmfUtil {
    private static LinkedList<String> typeToId = new LinkedList();
    public static LinkedList<String> debug = new LinkedList();
    public static final int HEADERTYPE = 1;
    private static List<StockGraphicObject> stockObjects = new ArrayList<StockGraphicObject>();

    public static GraphicObject getDefaultGraphicsObject(int id) {
        for (StockGraphicObject stockObject : stockObjects) {
            if (stockObject.getIndex() != id) continue;
            return stockObject;
        }
        return null;
    }

    public static Logger getLogger() {
        return LogManager.getLogger((String)"EMFParser");
    }

    public static String getTypeName(int id) {
        return typeToId.get(id);
    }

    public static byte readByte(byte[] data, int offset) {
        try {
            return data[offset];
        }
        catch (Throwable th) {
            EmfUtil.getLogger().error((Object)("Can not read a byte value. The current offset is " + offset + "\n" + String.valueOf(th)));
            return 0;
        }
    }

    public static Color readColor(byte[] data, int offset) {
        Color color = new Color(EmfUtil.readByte(data, offset) & 0xFF, EmfUtil.readByte(data, offset + 1) & 0xFF, EmfUtil.readByte(data, offset + 2) & 0xFF);
        debug.add(color.toString());
        return color;
    }

    public static int read2BytesInteger(byte[] data, int offset) {
        return (EmfUtil.readByte(data, offset + 1) & 0xFF) << 8 | EmfUtil.readByte(data, offset) & 0xFF;
    }

    public static int read4BytesInteger(byte[] data, int offset) {
        return EmfUtil.readByte(data, offset + 3) << 24 | (EmfUtil.readByte(data, offset + 2) & 0xFF) << 16 | (EmfUtil.readByte(data, offset + 1) & 0xFF) << 8 | EmfUtil.readByte(data, offset) & 0xFF;
    }

    public static Rectangle readRectangle(byte[] data, int offset) {
        int left = EmfUtil.read4BytesInteger(data, offset);
        int top = EmfUtil.read4BytesInteger(data, offset + 4);
        int right = EmfUtil.read4BytesInteger(data, offset + 8);
        int bottom = EmfUtil.read4BytesInteger(data, offset + 12);
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public static Point readPoint(byte[] data, int offset) {
        return new Point(EmfUtil.read4BytesInteger(data, offset), EmfUtil.read4BytesInteger(data, offset + 4));
    }

    public static double read4BytesFloatingPoint(byte[] data, int offset) {
        int tmp = EmfUtil.read4BytesInteger(data, offset);
        int fractionalValue = tmp & 0xF;
        int intValue = (tmp & 0xFFFFFFF0) >> 4;
        if (intValue < 0) {
            return (double)(++intValue) - (double)fractionalValue / 16.0;
        }
        return (double)intValue + (double)fractionalValue / 16.0;
    }

    public static BufferedImage getImage(InputStream inputStream) {
        return new EMFDecoder(inputStream).getImage();
    }

    public static EmfRecords getRecords(int typeId) {
        switch (typeId) {
            case 1: {
                return new HeaderRecord();
            }
            case 3: {
                return new PolygonRecord();
            }
            case 4: {
                return new PolylineRecord();
            }
            case 5: {
                return new PolyBezierToRecord();
            }
            case 9: {
                return new SetWindowExtEx(SetWindowExtEx.Type.WINDOWEXTEX);
            }
            case 10: {
                return new SetWindowExtEx(SetWindowExtEx.Type.WINDOWORGEX);
            }
            case 11: {
                return new SetWindowExtEx(SetWindowExtEx.Type.VIEWPORTEXTEX);
            }
            case 12: {
                return new SetWindowExtEx(SetWindowExtEx.Type.VIEWPORTORGEX);
            }
            case 17: {
                return new SetMapMode();
            }
            case 18: {
                return new SetBKMode();
            }
            case 19: {
                return new SetPolyfillModeRecord();
            }
            case 27: {
                return new MoveToExRecord();
            }
            case 36: {
                return new ModifyWorldTransform();
            }
            case 37: {
                return new SelectObject();
            }
            case 38: {
                return new CreatePenRecord();
            }
            case 39: {
                return new CreateBrushIndirect();
            }
            case 40: {
                return new DeleteObject();
            }
            case 54: {
                return new LineToRecord();
            }
            case 59: {
                return new PathRecord(PathRecord.Type.BEGINPATH);
            }
            case 60: {
                return new PathRecord(PathRecord.Type.ENDPATH);
            }
            case 61: {
                return new PathRecord(PathRecord.Type.CLOSEFIGURE);
            }
            case 62: {
                return new StrokePathRecord(StrokePathRecord.Type.FILL);
            }
            case 63: {
                return new StrokePathRecord(StrokePathRecord.Type.STROKEANDFILLPATH);
            }
            case 64: {
                return new StrokePathRecord(StrokePathRecord.Type.STROKE);
            }
            case 81: {
                return new StretchDiBitsRecord();
            }
            case 95: {
                return new ExtCreatePen();
            }
        }
        return new EmfRecords(){

            @Override
            public void readContent(byte[] source, int offset) {
            }

            @Override
            public void execute(EmfRecordExecutor executor) {
            }

            @Override
            public String toString() {
                return super.toString() + " NOT IMPLEMENTED ";
            }
        };
    }

    static {
        typeToId.add("NOT DEFINED");
        typeToId.addAll(Arrays.asList("HEADER,POLYBEZIER,POLYGON,POLYLINE,POLYBEZIERTO,POLYLINETO,POLYPOLYLINE,POLYPOLYGON,SETWINDOWEXTEX,SETWINDOWORGEX,SETVIEWPORTEXTEX,SETVIEWPORTORGEX,SETBRUSHORGEX,EOF,SETPIXELV,SETMAPPERFLAGS,SETMAPMODE,SETBKMODE,SETPOLYFILLMODE,SETROP2,SETSTRETCHBLTMODE,SETTEXTALIGN,SETCOLORADJUSTMENT,SETTEXTCOLOR,SETBKCOLOR,OFFSETCLIPRGN,MOVETOEX,SETMETARGN,EXCLUDECLIPRECT,INTERSECTCLIPRECT,SCALEVIEWPORTEXTEX,SCALEWINDOWEXTEX,SAVEDC,RESTOREDC,SETWORLDTRANSFORM,MODIFYWORLDTRANSFORM,SELECTOBJECT,CREATEPEN,CREATEBRUSHINDIRECT,DELETEOBJECT,ANGLEARC,ELLIPSE,RECTANGLE,ROUNDRECT,ARC,CHORD,PIE,SELECTPALETTE,CREATEPALETTE,SETPALETTEENTRIES,RESIZEPALETTE,REALIZEPALETTE,EXTFLOODFILL,LINETO,ARCTO,POLYDRAW,SETARCDIRECTION,SETMITERLIMIT,BEGINPATH,ENDPATH,CLOSEFIGURE,FILLPATH,STROKEANDFILLPATH,STROKEPATH,FLATTENPATH,WIDENPATH,SELECTCLIPPATH,ABORTPATH,0x45,COMMENT,FILLRGN,FRAMERGN,INVERTRGN,PAINTRGN,EXTSELECTCLIPRGN,BITBLT,STRETCHBLT,MASKBLT,PLGBLT,SETDIBITSTODEVICE,STRETCHDIBITS,EXTCREATEFONTINDIRECTW,EXTTEXTOUTA,EXTTEXTOUTW,POLYBEZIER16,POLYGON16,POLYLINE16,POLYBEZIERTO16,POLYLINETO16,POLYPOLYLINE16,POLYPOLYGON16,POLYDRAW16,CREATEMONOBRUSH,CREATEDIBPATTERNBRUSHPT,EXTCREATEPEN,POLYTEXTOUTA,POLYTEXTOUTW,SETICMMODE,CREATECOLORSPACE,SETCOLORSPACE,DELETECOLORSPACE,GLSRECORD,GLSBOUNDEDRECORD,PIXELFORMAT,DRAWESCAPE,EXTESCAPE,SMALLTEXTOUT,FORCEUFIMAPPING,NAMEDESCAPE,COLORCORRECTPALETTE,SETICMPROFILEA,SETICMPROFILEW,ALPHABLEND,SETLAYOUT,TRANSPARENTBLT,GRADIENTFILL,SETLINKEDUFIS,SETTEXTJUSTIFICATION,COLORMATCHTOTARGETW,CREATECOLORSPACEW".split(",")));
        stockObjects.add(new StockGraphicObject(Integer.MIN_VALUE, "WHITE_BRUSH", new CreateBrushIndirect(CreateBrushIndirect.BrushStyle.SOLID, Color.WHITE)));
        stockObjects.add(new StockGraphicObject(-2147483647, "LTGRAY_BRUSH", new CreateBrushIndirect(CreateBrushIndirect.BrushStyle.SOLID, new Color(192, 192, 192))));
        stockObjects.add(new StockGraphicObject(-2147483646, "GRAY_BRUSH", new CreateBrushIndirect(CreateBrushIndirect.BrushStyle.SOLID, new Color(128, 128, 128))));
        stockObjects.add(new StockGraphicObject(-2147483645, "DKGRAY_BRUSH", new CreateBrushIndirect(CreateBrushIndirect.BrushStyle.SOLID, new Color(64, 64, 64))));
        stockObjects.add(new StockGraphicObject(-2147483644, "BLACK_BRUSH", new CreateBrushIndirect(CreateBrushIndirect.BrushStyle.SOLID, Color.BLACK)));
        stockObjects.add(new StockGraphicObject(-2147483643, "NULL_BRUSH", new CreateBrushIndirect(CreateBrushIndirect.BrushStyle.NULL, Color.BLACK)));
        stockObjects.add(new StockGraphicObject(-2147483642, "WHITE_PEN", new CreatePenRecord(CreatePenRecord.PenStyleLine.SOLID, CreatePenRecord.PenStyleJoin.ROUND, CreatePenRecord.PenStyleEndcap.ROUND, CreatePenRecord.PenStyleOptional.COSMETIC, Color.WHITE)));
        stockObjects.add(new StockGraphicObject(-2147483641, "BLACK_PEN", new CreatePenRecord(CreatePenRecord.PenStyleLine.SOLID, CreatePenRecord.PenStyleJoin.ROUND, CreatePenRecord.PenStyleEndcap.ROUND, CreatePenRecord.PenStyleOptional.COSMETIC, Color.BLACK)));
        stockObjects.add(new StockGraphicObject(-2147483640, "NULL_PEN", new CreatePenRecord(CreatePenRecord.PenStyleLine.NULL, CreatePenRecord.PenStyleJoin.ROUND, CreatePenRecord.PenStyleEndcap.ROUND, CreatePenRecord.PenStyleOptional.COSMETIC, Color.BLACK)));
        stockObjects.add(new StockGraphicObject(-2147483638, "OEM_FIXED_FONT", null));
        stockObjects.add(new StockGraphicObject(-2147483637, "ANSI_FIXED_FONT", null));
        stockObjects.add(new StockGraphicObject(-2147483636, "ANSI_VAR_FONT", null));
        stockObjects.add(new StockGraphicObject(-2147483635, "SYSTEM_FONT", null));
        stockObjects.add(new StockGraphicObject(-2147483634, "DEVICE_DEFAULT_FONT", null));
        stockObjects.add(new StockGraphicObject(-2147483633, "DEFAULT_PALETTE", null));
        stockObjects.add(new StockGraphicObject(-2147483632, "SYSTEM_FIXED_FONT", null));
        stockObjects.add(new StockGraphicObject(-2147483631, "DEFAULT_GUI_FONT", null));
        stockObjects.add(new StockGraphicObject(-2147483630, "DC_BRUSH", null));
        stockObjects.add(new StockGraphicObject(-2147483629, "DC_PEN", null));
        for (StockGraphicObject stockObject : stockObjects) {
            EmfUtil.getLogger().debug((Object)("StockObjectID => " + String.valueOf(stockObject)));
        }
    }
}

