/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf;

import com.inet.emf.EMFReader;
import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfUtil;

public abstract class EmfRecords
implements EMFReader {
    private int type;
    private int size;
    private boolean wasRead = false;

    public int getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public int read(byte[] source, int offset) {
        this.type = EmfUtil.read4BytesInteger(source, offset);
        this.size = EmfUtil.read4BytesInteger(source, offset + 4);
        this.wasRead = true;
        if (this.size < 8) {
            EmfUtil.getLogger().debug((Object)("Ein fehler im aktuellen Records, die Size darf nicht kleiner als 8 sein.\nThe current size is " + this.size));
            this.size = 8;
        }
        this.readContent(source, offset + 8);
        return this.size;
    }

    public abstract void readContent(byte[] var1, int var2);

    public void execute(EmfRecordExecutor executor) {
        if (!this.wasRead) {
            EmfUtil.getLogger().debug((Object)("Records wasn't read. " + this.getType() + "(" + EmfUtil.getTypeName(this.getSize()) + ")"));
        }
    }

    public String toString() {
        return "EmfRecords{type=" + this.type + "( " + EmfUtil.getTypeName(this.type) + " ), size=" + this.size + "}";
    }
}

