/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.render;

import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.subelements.TextRowElement;
import com.inet.docx.document.paragraph.StringLayouter;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.paragraph.RowTextPiece;
import com.inet.docx.view.render.RenderBaseObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STVerticalAlignRun;

public class RenderText
extends RenderBaseObject {
    private final AffineTransform transform;
    private final Paint strokePaint;
    private final Paint fillPaint;
    private final String text;
    private final Font font;
    private final double[] charWidths;
    private final double[] kerning;
    private boolean isSuperscript;
    private boolean isSubscript;
    private boolean isStrikethrough;
    private boolean hasUnderline;
    private final Color defaultPageBg;
    private final double baselineHeight;
    private final boolean isBound;
    private boolean isControlElement = false;
    private boolean isEmpty;

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public String getText() {
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    public double[] getCharWidths() {
        return this.charWidths;
    }

    public double[] getKerning() {
        return this.kerning;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public boolean isSuperscript() {
        return this.isSuperscript;
    }

    public boolean isSubscript() {
        return this.isSubscript;
    }

    public boolean isStrikethrough() {
        return this.isStrikethrough;
    }

    public boolean hasUnderline() {
        return this.hasUnderline;
    }

    public void setSuperscript(boolean superscript) {
        this.isSuperscript = superscript;
    }

    public void setSubscript(boolean subscript) {
        this.isSubscript = subscript;
    }

    public void setStrikethrough(boolean strikethrough) {
        this.isStrikethrough = strikethrough;
    }

    public void setHasUnderline(boolean hasUnderline) {
        this.hasUnderline = hasUnderline;
    }

    public double getTextHeight() {
        return this.baselineHeight;
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean isControlElement() {
        return this.isControlElement;
    }

    public RenderText(RowTextPiece row, StringLayouter stringLayouter, AffineTransform preTransformation, Color defaultStrokePaint) {
        LineProperties line;
        char charAt;
        if (row.getText().length() == 1 && ((charAt = row.getText().charAt(0)) == '\n' || charAt == '\uf000' || charAt == '\uf001')) {
            this.isControlElement = true;
        }
        TextRowElement tre = row.getParent();
        RenderFont renderFont = tre.getRenderFont();
        Font font = stringLayouter.getFont();
        AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, Util.convertTwipsToPoint(row.getPageX()), Util.convertTwipsToPoint(row.getPageY() + row.getParent().getRenderFont().getRenderDimensions().getBaselineHeight()));
        affineTransform.preConcatenate(preTransformation);
        Color strokePaint = tre.getBackgroundColor();
        if (strokePaint == null) {
            strokePaint = defaultStrokePaint;
        }
        String text = row.getText();
        double[] charWidths = Util.calcToPoint(stringLayouter.calcCharWidths(text));
        double[] kerning = null;
        if (charWidths.length > 0 && renderFont.getSpacing() != 0.0) {
            int length = Math.max(charWidths.length, 1);
            kerning = new double[length];
            for (int i = 1; i < kerning.length; ++i) {
                kerning[i] = -renderFont.getSpacing();
            }
        }
        this.setHasUnderline((line = renderFont.getUnderline()) != null && line != LineProperties.EMPTY_LINE);
        this.setStrikethrough(renderFont.isStrikethrough());
        this.setSuperscript(renderFont.getVerticalAlign() == STVerticalAlignRun.SUPERSCRIPT);
        this.setSubscript(renderFont.getVerticalAlign() == STVerticalAlignRun.SUBSCRIPT);
        this.defaultPageBg = defaultStrokePaint;
        this.transform = affineTransform;
        this.strokePaint = strokePaint;
        this.fillPaint = tre.getColor() != null ? tre.getColor() : Color.BLACK;
        this.text = text;
        this.font = font;
        this.charWidths = charWidths;
        this.kerning = kerning;
        this.baselineHeight = Util.convertTwipsToPoint(row.getParent().getRenderFont().getRenderDimensions().getBaselineHeight());
        this.isBound = row.isBounded();
        this.isEmpty = row.isEmpty();
    }

    @Override
    public void renderPage(Graphics2D graphics, Rectangle2D imgBounds) {
        if (this.isEmpty || this.isControlElement) {
            return;
        }
        Graphics2D sub = (Graphics2D)graphics.create();
        sub.transform(this.transform);
        sub.setPaint(this.fillPaint);
        sub.setFont(this.getFormattedFont());
        String text = this.text;
        if (this.isBound) {
            text = text.substring(0, text.length() - 1);
        }
        char[] chars = text.toCharArray();
        double posX = 0.0;
        for (int i = 0; i < chars.length; ++i) {
            sub.drawString("" + chars[i], (float)(posX += this.kerning == null ? 0.0 : this.kerning[i]), 0.0f);
            posX += this.charWidths[i];
        }
        sub.dispose();
    }

    private Font getFormattedFont() {
        HashMap attributes;
        Font font = this.font;
        if (this.kerning != null) {
            attributes = new HashMap(font.getAttributes());
            attributes.put(TextAttribute.TRACKING, -this.kerning[0]);
            font = font.deriveFont(attributes);
        }
        if (this.isStrikethrough()) {
            attributes = new HashMap(font.getAttributes());
            attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            font = font.deriveFont(attributes);
        }
        if (this.isSubscript()) {
            attributes = new HashMap(font.getAttributes());
            attributes.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
            font = font.deriveFont(attributes);
        }
        if (this.isSuperscript()) {
            attributes = new HashMap(font.getAttributes());
            attributes.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
            font = font.deriveFont(attributes);
        }
        if (!this.strokePaint.equals(this.defaultPageBg)) {
            attributes = new HashMap(font.getAttributes());
            attributes.put(TextAttribute.BACKGROUND, this.strokePaint);
            font = font.deriveFont(attributes);
        }
        return font;
    }
}

