/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.render;

import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.render.RenderBaseObject;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class RenderShape
extends RenderBaseObject {
    private final Shape shape;
    private final Paint strokePaint;
    private final Paint fillPaint;
    private final BasicStroke stroke;

    public Shape getShape() {
        return this.shape;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public RenderShape(Shape shape, Paint strokePaint, Paint fillPaint, BasicStroke stroke) {
        this.shape = shape;
        this.strokePaint = strokePaint;
        this.fillPaint = fillPaint;
        this.stroke = stroke;
    }

    @Override
    public void renderPage(Graphics2D graphics, Rectangle2D imgBounds) {
        if (this.shape == null) {
            Util.LOGGER.warn((Object)"Shape element has no shape outline!");
            return;
        }
        Graphics2D sub = (Graphics2D)graphics.create();
        if (this.fillPaint != null) {
            sub.setPaint(this.fillPaint);
            sub.fill(this.shape);
        }
        if (this.strokePaint != null) {
            sub.setPaint(this.strokePaint);
            if (this.stroke != null && this.stroke.getLineWidth() > 0.0f) {
                sub.setStroke(this.stroke);
            }
            sub.draw(this.shape);
        }
        sub.dispose();
    }
}

