/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.paragraph;

public class ParagraphPageBreakPosition {
    private int elementIndex;
    private int inTextIndex;

    public ParagraphPageBreakPosition(int elementIndex, int inTextIndex) {
        if (elementIndex < 0) {
            throw new IllegalArgumentException("The text break position must not be negative");
        }
        if (inTextIndex < 0) {
            throw new IllegalArgumentException("The text break position must be inside the bounds of the current paragraph");
        }
        this.elementIndex = elementIndex;
        this.inTextIndex = inTextIndex;
    }

    public int getContinueIndex() {
        return this.elementIndex;
    }

    public int getInTextIndex() {
        return this.inTextIndex;
    }

    public String toString() {
        return "ParagraphPageBreakPosition{elementIndex=" + this.elementIndex + ", inTextIndex=" + this.inTextIndex + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParagraphPageBreakPosition)) {
            return false;
        }
        ParagraphPageBreakPosition other = (ParagraphPageBreakPosition)obj;
        return other.elementIndex == this.elementIndex && other.inTextIndex == this.inTextIndex;
    }
}

