/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.drawing;

import com.inet.docx.view.drawing.RectangleCornerStyle;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;

public abstract class CustomRectangle2D
extends RectangularShape {
    CustomRectangle2D() {
    }

    public abstract double[] getArcWidth();

    public abstract double[] getArcHeight();

    public abstract RectangleCornerStyle[] getStyles();

    public abstract void setRectParameter(double var1, double var3, double var5, double var7, double[] var9, double[] var10, RectangleCornerStyle[] var11);

    public void setRectParameter(CustomRectangle2D customRectangle2D) {
        this.setRectParameter(customRectangle2D.getX(), customRectangle2D.getY(), customRectangle2D.getWidth(), customRectangle2D.getHeight(), customRectangle2D.getArcWidth(), customRectangle2D.getArcHeight(), customRectangle2D.getStyles());
    }

    @Override
    public void setFrame(double x, double y, double w, double h) {
        this.setRectParameter(x, y, w, h, this.getArcWidth(), this.getArcHeight(), this.getStyles());
    }

    @Override
    public boolean contains(double x, double y) {
        throw new IllegalStateException("CustomRectangle contains not implemented");
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        throw new IllegalStateException("CustomRectangle intersects not implemented");
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        throw new IllegalStateException("CustomRectangle contains not implemented");
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new CustomRectIterator(this, at);
    }

    private class CustomRectIterator
    implements PathIterator {
        double x;
        double y;
        double w;
        double h;
        double[] aws = new double[4];
        double[] ahs = new double[4];
        AffineTransform affine;
        int index;
        RectangleCornerStyle[] styles;
        private final double angle = 0.7853981633974483;
        private final double a = 1.0 - Math.cos(0.7853981633974483);
        private final double b = Math.tan(0.7853981633974483);
        private final double c = Math.sqrt(1.0 + this.b * this.b) - 1.0 + this.a;
        private final double cv = 1.3333333333333333 * this.a * this.b / this.c;
        private final double acv = (1.0 - this.cv) / 2.0;
        private double[][] ctrlpts = new double[][]{{0.0, 0.0, 0.0, 0.5}, {0.0, 0.0, 1.0, -0.5}, {0.0, 0.0, 1.0, -this.acv, 0.0, this.acv, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0}, {1.0, -0.5, 1.0, 0.0}, {1.0, -this.acv, 1.0, 0.0, 1.0, 0.0, 1.0, -this.acv, 1.0, 0.0, 1.0, -0.5}, {1.0, 0.0, 0.0, 0.5}, {1.0, 0.0, 0.0, this.acv, 1.0, -this.acv, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}, {0.0, this.acv, 0.0, 0.0, 0.0, 0.0, 0.0, this.acv, 0.0, 0.0, 0.0, 0.5}, new double[0]};
        private int[] types = new int[]{0, 1, 3, 1, 3, 1, 3, 1, 3, 4};

        CustomRectIterator(CustomRectangle2D rr, AffineTransform at) {
            int i;
            this.x = rr.getX();
            this.y = rr.getY();
            this.w = rr.getWidth();
            this.h = rr.getHeight();
            for (i = 0; i < rr.getArcWidth().length; ++i) {
                this.aws[i] = Math.min(this.w, Math.abs(rr.getArcWidth()[i]));
            }
            for (i = 0; i < rr.getArcHeight().length; ++i) {
                this.ahs[i] = Math.min(this.h, Math.abs(rr.getArcHeight()[i]));
            }
            this.affine = at;
            this.styles = rr.getStyles();
            for (i = 0; i < this.styles.length; ++i) {
                RectangleCornerStyle style = this.styles[i];
                if (style == RectangleCornerStyle.ROUND) continue;
                int indexInCoords = (3 - i) * 2 + 2;
                double[] factor = this.ctrlpts[indexInCoords];
                this.ctrlpts[indexInCoords] = style == RectangleCornerStyle.BEVEL ? new double[]{factor[factor.length - 4], factor[factor.length - 3], factor[factor.length - 2], factor[factor.length - 1]} : new double[]{factor[factor.length - 4], 0.0, factor[factor.length - 2], 0.0};
            }
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.index >= this.ctrlpts.length;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException("roundrect iterator out of bounds");
            }
            double[] ctrls = this.ctrlpts[this.index];
            int nc = 0;
            int indexCorner = this.index == 0 ? 0 : (this.index <= 2 ? 3 : (this.index <= 4 ? 2 : (this.index <= 6 ? 1 : 0)));
            for (int i = 0; i < ctrls.length; i += 4) {
                coords[nc++] = (float)(this.x + ctrls[i + 0] * this.w + ctrls[i + 1] * this.aws[indexCorner]);
                coords[nc++] = (float)(this.y + ctrls[i + 2] * this.h + ctrls[i + 3] * this.ahs[indexCorner]);
            }
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, nc / 2);
            }
            if (this.types[this.index] == 3 && this.styles[indexCorner] != RectangleCornerStyle.ROUND) {
                return 1;
            }
            return this.types[this.index];
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException("roundrect iterator out of bounds");
            }
            double[] ctrls = this.ctrlpts[this.index];
            int nc = 0;
            int indexCorner = this.index == 0 ? 0 : (this.index <= 2 ? 3 : (this.index <= 4 ? 2 : (this.index <= 6 ? 1 : 0)));
            for (int i = 0; i < ctrls.length; i += 4) {
                coords[nc++] = (float)(this.x + ctrls[i + 0] * this.w + ctrls[i + 1] * this.aws[indexCorner]);
                coords[nc++] = (float)(this.y + ctrls[i + 2] * this.h + ctrls[i + 3] * this.ahs[indexCorner]);
            }
            if (this.affine != null) {
                this.affine.transform(coords, 0, coords, 0, nc / 2);
            }
            if (this.types[this.index] == 3 && this.styles[indexCorner] != RectangleCornerStyle.ROUND) {
                return 1;
            }
            return this.types[this.index];
        }
    }

    public static class Double
    extends CustomRectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;
        public double[] arcwidth;
        public double[] archeight;
        public RectangleCornerStyle[] styles = new RectangleCornerStyle[]{RectangleCornerStyle.NORMAL, RectangleCornerStyle.NORMAL, RectangleCornerStyle.NORMAL, RectangleCornerStyle.NORMAL};

        public Double() {
        }

        public Double(double x, double y, double w, double h, double[] arcw, double[] arch, RectangleCornerStyle[] cornerStyle) {
            this.setRectParameter(x, y, w, h, arcw, arch, cornerStyle);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public double[] getArcWidth() {
            return this.arcwidth;
        }

        @Override
        public double[] getArcHeight() {
            return this.archeight;
        }

        @Override
        public RectangleCornerStyle[] getStyles() {
            return this.styles;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        @Override
        public void setRectParameter(double x, double y, double w, double h, double[] arcw, double[] arch, RectangleCornerStyle[] styles) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcw;
            this.archeight = arch;
            this.styles = styles;
        }

        @Override
        public void setRectParameter(CustomRectangle2D customRectangle2D) {
            this.x = customRectangle2D.getX();
            this.y = customRectangle2D.getY();
            this.width = customRectangle2D.getWidth();
            this.height = customRectangle2D.getHeight();
            this.arcwidth = customRectangle2D.getArcWidth();
            this.archeight = customRectangle2D.getArcHeight();
            this.styles = customRectangle2D.getStyles();
        }

        @Override
        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }
    }
}

