/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.drawing;

import com.inet.docx.document.elements.subelements.drawing.TextWrapping;
import com.inet.docx.view.drawing.DrawingElement;
import com.inet.docx.view.drawing.DrawingReflection;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class AbstractDrawingElement
implements DrawingElement {
    private double width;
    private double height;
    private Point2D.Double position;
    private TextWrapping textWrapping;
    private TextWrapping.Side textWrappingSide;
    private DrawingReflection reflection;
    private boolean isBackground = false;
    private double rotation = 0.0;
    private double scaleX = 1.0;
    private double scaleY = 1.0;

    public AbstractDrawingElement(Rectangle2D bounds, double rotation, double scaleX, double scaleY, DrawingReflection reflection) {
        this.width = bounds.getWidth();
        this.height = bounds.getHeight();
        this.position = new Point2D.Double(bounds.getX(), bounds.getY());
        this.rotation = rotation;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.reflection = reflection;
    }

    public AbstractDrawingElement(Rectangle2D bounds, double rotation, double scaleX, double scaleY) {
        this(bounds, rotation, scaleX, scaleY, DrawingReflection.NONE);
    }

    @Override
    public TextWrapping getTextWrapping() {
        return this.textWrapping;
    }

    @Override
    public void setTextWrapping(TextWrapping textWrapping) {
        this.textWrapping = textWrapping;
    }

    @Override
    public TextWrapping.Side getTextWrappingSide() {
        return this.textWrappingSide;
    }

    @Override
    public void setTextWrappingSide(TextWrapping.Side textWrappingSide) {
        this.textWrappingSide = textWrappingSide;
    }

    @Override
    public boolean isBackground() {
        return this.isBackground;
    }

    @Override
    public void setBackground(boolean background) {
        this.isBackground = background;
    }

    @Override
    public AffineTransform getTransformation() {
        return this.getTransformation(this.getPosition().getX(), this.getPosition().getY(), this.getWidth(), this.getHeight());
    }

    public AffineTransform getTransformation(double x, double y, double width, double height) {
        return this.getTransformation(x, y, width, height, this.getRotation());
    }

    public AffineTransform getTransformation(double x, double y, double width, double height, double rotation) {
        double scaleX = this.getScaleX();
        double scaleY = this.getScaleY();
        Rectangle2D.Double bounds = new Rectangle2D.Double(x, y, width, height);
        Point2D.Double mp1 = new Point2D.Double(((RectangularShape)bounds).getWidth() * 0.5 + ((RectangularShape)bounds).getX(), ((RectangularShape)bounds).getHeight() * 0.5 + ((RectangularShape)bounds).getY());
        AffineTransform tx = new AffineTransform();
        switch (this.reflection) {
            case NONE: {
                break;
            }
            case HORIZONTAL: {
                tx = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                break;
            }
            case VERTICAL: {
                tx = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
                break;
            }
            case BOTH: {
                tx = new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
            }
        }
        tx.rotate(Math.toRadians(rotation));
        tx.scale(scaleX, scaleY);
        tx.translate(-mp1.getX(), -mp1.getY());
        Rectangle2D bounds2D = tx.createTransformedShape(bounds).getBounds2D();
        Point2D.Double mp2 = new Point2D.Double(bounds2D.getWidth() * 0.5 + bounds2D.getX(), bounds2D.getHeight() * 0.5 + bounds2D.getY());
        tx.preConcatenate(AffineTransform.getTranslateInstance(mp1.getX() * scaleX, mp1.getY() * scaleY));
        return tx;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public DrawingReflection getReflection() {
        return this.reflection;
    }

    @Override
    public Shape getBoundsShape() {
        return this.getTransformation().createTransformedShape(new Rectangle2D.Double(this.getPosition().getX(), this.getPosition().getY(), this.getWidth(), this.getHeight()));
    }

    @Override
    public void setHeight(double height) {
        this.height = height;
    }

    @Override
    public void setWidth(double width) {
        this.width = width;
    }

    public void modifySize(double x, double y, double width, double height) {
        this.position = new Point2D.Double(x, y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public String toString() {
        return "AbstractDrawingElement{width=" + this.width + ", height=" + this.height + ", position=" + String.valueOf(this.position) + ", rotation=" + this.rotation + ", scaleX=" + this.scaleX + ", scaleY=" + this.scaleY + "}";
    }
}

