/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.paragraph;

import com.inet.docx.document.paragraph.FontDimensionsTwips;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class StringLayouter {
    private HashMap<Integer, Double> charWidths = new HashMap();
    private Graphics2D graphics;
    private Font font;
    private FontMetrics fm;
    private FontDimensionsTwips fontDimensions;

    public StringLayouter(Font font, boolean isSuperOrSubScript) {
        this.font = font;
        BufferedImage bi = new BufferedImage(1, 1, 12);
        this.graphics = (Graphics2D)bi.getGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.fm = isSuperOrSubScript ? this.graphics.getFontMetrics(font.deriveFont((float)font.getSize() * 0.666f)) : this.graphics.getFontMetrics(font);
        LineMetrics lm = this.fm.getLineMetrics("Text", this.graphics);
        this.fontDimensions = new FontDimensionsTwips((double)lm.getHeight() * 20.0, (double)lm.getAscent() * 20.0, (double)lm.getDescent() * 20.0, (double)lm.getLeading() * 20.0);
    }

    public Font getFont() {
        return this.font;
    }

    public FontDimensionsTwips getFontDimensions() {
        return this.fontDimensions;
    }

    public double getTextLength(String text) {
        return this.fm.getStringBounds(text, this.graphics).getWidth() * 20.0;
    }

    public double[] calcCharWidths(String text) {
        double[] widths = new double[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            widths[i] = this.charWidth(text.charAt(i));
        }
        return widths;
    }

    private double charWidth(char ch) {
        Integer key = ch;
        Double result = this.charWidths.get(key);
        if (result == null) {
            result = new Double(this.fm.getStringBounds(new char[]{ch}, 0, 1, (Graphics)this.graphics).getWidth() * 20.0);
            this.charWidths.put(key, result);
        }
        return result;
    }

    public void close() {
        this.graphics.dispose();
    }
}

