/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.elements.subelements.drawing.Anchor;
import com.inet.docx.document.elements.subelements.drawing.TextWrapping;
import com.inet.docx.document.utilities.Util;
import java.math.BigInteger;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STXAlign;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STYAlign;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFramePr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHAnchor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVAnchor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STWrap;

public class TextFrame {
    private TextWrapping textWrap;
    private Double width;
    private Double height;
    private Double x;
    private Double y;
    private Double vSpace;
    private Double hSpace;
    private Anchor.Reference horizontalAnchor;
    private Anchor.Reference verticalAnchor;
    private Anchor.Align horizontalAlign;
    private Anchor.Align verticalAlign;

    private TextFrame() {
    }

    public TextFrame(CTFramePr framePr) {
        this.textWrap = TextFrame.convertTextWrap(framePr.getWrap());
        this.width = Util.getDoubleAsDouble(framePr.getW());
        this.height = Util.getDoubleAsDouble(framePr.getH());
        this.x = Util.getDoubleAsDouble(framePr.getX());
        this.y = Util.getDoubleAsDouble(framePr.getY());
        this.horizontalAnchor = TextFrame.convertHorizantalAnchor(framePr.getHAnchor());
        this.verticalAnchor = TextFrame.convertVerticalalAnchor(framePr.getVAnchor());
        this.horizontalAlign = TextFrame.convertXAlign(framePr.getXAlign());
        this.verticalAlign = TextFrame.convertYAlign(framePr.getYAlign());
        this.hSpace = Util.getDoubleAsDouble(framePr.getHSpace());
        this.vSpace = Util.getDoubleAsDouble(framePr.getVSpace());
    }

    public TextWrapping getTextWrap() {
        return this.textWrap;
    }

    public Double getWidth() {
        return this.width;
    }

    public Double getHeight() {
        return this.height;
    }

    public Double getX() {
        return this.x;
    }

    public Double getY() {
        return this.y;
    }

    public Double getHSpace() {
        return this.hSpace;
    }

    public Double getVSpace() {
        return this.vSpace;
    }

    public Anchor.Reference getHorizontalAnchor() {
        if (this.horizontalAnchor != null) {
            return this.horizontalAnchor;
        }
        return Anchor.Reference.margin;
    }

    public Anchor.Reference getVerticalAnchor() {
        if (this.verticalAnchor != null) {
            return this.verticalAnchor;
        }
        return Anchor.Reference.margin;
    }

    public Anchor.Align getHorizontalAlign() {
        if (this.horizontalAlign != null) {
            return this.horizontalAlign;
        }
        return Anchor.Align.left;
    }

    public Anchor.Align getVerticalAlign() {
        if (this.verticalAlign != null) {
            return this.verticalAlign;
        }
        return Anchor.Align.top;
    }

    public static TextFrame merge(TextFrame primary, TextFrame secondary) {
        if (secondary == null) {
            return primary;
        }
        if (primary == null) {
            return secondary;
        }
        TextFrame tf = new TextFrame();
        tf.textWrap = primary.textWrap != null ? primary.textWrap : secondary.textWrap;
        tf.width = primary.width != null ? primary.width : secondary.width;
        tf.height = primary.height != null ? primary.height : secondary.height;
        tf.x = primary.x != null ? primary.x : secondary.x;
        tf.y = primary.y != null ? primary.y : secondary.y;
        tf.hSpace = primary.hSpace != null ? primary.hSpace : secondary.hSpace;
        tf.vSpace = primary.vSpace != null ? primary.vSpace : secondary.vSpace;
        tf.horizontalAnchor = primary.horizontalAnchor != null ? primary.horizontalAnchor : secondary.horizontalAnchor;
        tf.verticalAnchor = primary.verticalAnchor != null ? primary.verticalAnchor : secondary.verticalAnchor;
        tf.horizontalAlign = primary.horizontalAlign != null ? primary.horizontalAlign : secondary.horizontalAlign;
        tf.verticalAlign = primary.verticalAlign != null ? primary.verticalAlign : secondary.verticalAlign;
        return tf;
    }

    public String toString() {
        return String.valueOf((Object)this.textWrap) + " w " + this.width + " h " + this.height + " x " + this.x + " y " + this.y + " hs " + this.hSpace + " vs " + this.vSpace + " hanch " + String.valueOf((Object)this.horizontalAnchor) + " halig " + String.valueOf((Object)this.horizontalAlign) + " vanch " + String.valueOf((Object)this.verticalAnchor) + " valig " + String.valueOf((Object)this.verticalAlign);
    }

    private static Double convertBigInteger(BigInteger bi) {
        if (bi != null) {
            return new Double(bi.intValue());
        }
        return null;
    }

    private static Anchor.Align convertYAlign(STYAlign.Enum yAlign) {
        if (yAlign == null) {
            return null;
        }
        if (yAlign == STYAlign.CENTER) {
            return Anchor.Align.center;
        }
        if (yAlign == STYAlign.TOP) {
            return Anchor.Align.top;
        }
        if (yAlign == STYAlign.BOTTOM) {
            return Anchor.Align.bottom;
        }
        if (yAlign == STYAlign.OUTSIDE) {
            return Anchor.Align.outside;
        }
        if (yAlign == STYAlign.INSIDE) {
            return Anchor.Align.inside;
        }
        return Anchor.Align.inline;
    }

    private static Anchor.Align convertXAlign(STXAlign.Enum xAlign) {
        if (xAlign == null) {
            return null;
        }
        if (xAlign == STXAlign.CENTER) {
            return Anchor.Align.center;
        }
        if (xAlign == STXAlign.RIGHT) {
            return Anchor.Align.right;
        }
        return Anchor.Align.left;
    }

    private static Anchor.Reference convertVerticalalAnchor(STVAnchor.Enum vAnchor) {
        if (vAnchor == null) {
            return null;
        }
        if (vAnchor == STVAnchor.PAGE) {
            return Anchor.Reference.page;
        }
        if (vAnchor == STVAnchor.MARGIN) {
            return Anchor.Reference.margin;
        }
        return Anchor.Reference.text;
    }

    private static Anchor.Reference convertHorizantalAnchor(STHAnchor.Enum hAnchor) {
        if (hAnchor == null) {
            return null;
        }
        if (hAnchor == STHAnchor.PAGE) {
            return Anchor.Reference.page;
        }
        if (hAnchor == STHAnchor.MARGIN) {
            return Anchor.Reference.margin;
        }
        return Anchor.Reference.text;
    }

    private static TextWrapping convertTextWrap(STWrap.Enum wrap) {
        if (wrap == null) {
            return null;
        }
        if (wrap == STWrap.AROUND || wrap == STWrap.AUTO) {
            return TextWrapping.SQUARE;
        }
        if (wrap == STWrap.NOT_BESIDE) {
            return TextWrapping.TOPANDBOTTOM;
        }
        if (wrap == STWrap.TIGHT) {
            return TextWrapping.TIGHT;
        }
        if (wrap == STWrap.THROUGH) {
            return TextWrapping.THROUGH;
        }
        return TextWrapping.NONE;
    }
}

