/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.style.CellBorder;
import com.inet.docx.document.elements.style.CellStyle;
import com.inet.docx.document.elements.style.ParagraphAndRunStyle;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.elements.style.Style;
import com.inet.docx.document.elements.subelements.table.TableBorder;
import com.inet.docx.document.utilities.Util;
import java.awt.Color;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrGeneral;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblCellMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblStylePr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;

public class StyleTable
implements Style {
    private static final CellType[] ALL_CELL_TYPES = new CellType[]{CellType.band1Horz, CellType.band2Horz, CellType.band1Vert, CellType.band2Vert, CellType.firstCol, CellType.firstRow, CellType.lastCol, CellType.lastRow, CellType.neCell, CellType.nwCell, CellType.seCell, CellType.swCell, CellType.defaultCell};
    public static final List<CellType> DEFAULT_STYLE = StyleTable.initDefault();
    Map<CellType, CellStyle> cellTypes = new HashMap<CellType, CellStyle>();
    private ParagraphAndRunStyle tableCellFont;
    private ParagraphAndRunStyle defaultFontstyle;
    private StyleTable parentStyle;
    private Insets margin;
    private TableBorder tableBorder;
    private Color cellBg;
    private CellBorder cellBorder;
    private String name;

    private static List<CellType> initDefault() {
        ArrayList<CellType> list = new ArrayList<CellType>();
        list.add(CellType.defaultCell);
        return list;
    }

    public StyleTable(StyleTable parentStyle, ParagraphAndRunStyle defaultFontstyle, HashMap<String, Color> themeColors, CTStyle cts, DocumentProperties documentDefaults, String styleName) {
        List styleprs;
        this.parentStyle = parentStyle;
        this.defaultFontstyle = defaultFontstyle;
        this.name = styleName;
        if (parentStyle == null) {
            this.tableCellFont = new ParagraphAndRunStyle(RunRenderInformations.getEmpty(), documentDefaults.getDefaultStyleFont());
            this.tableCellFont.setName(styleName);
        } else {
            this.tableCellFont = parentStyle.tableCellFont.clone();
            this.tableCellFont.setName(this.tableCellFont.getName() + "-" + styleName);
        }
        CTPPrGeneral ctppr = cts.getPPr();
        Spacing spacing = null;
        if (ctppr != null) {
            if (ctppr.isSetSpacing()) {
                spacing = new Spacing(ctppr.getSpacing(), null);
            }
            if (ctppr.isSetJc()) {
                this.tableCellFont.setHorAlign(ctppr.getJc().getVal());
            }
        }
        spacing = Spacing.mergeSpacing(spacing, defaultFontstyle.getParagraphSpacing(true));
        this.tableCellFont.setSpacing(spacing);
        this.tableCellFont = ParagraphAndRunStyle.mergeFontInfos(cts.getRPr(), documentDefaults, this.tableCellFont, "rpr");
        CTTblPrBase tblPr = cts.getTblPr();
        if (tblPr != null && tblPr.isSetTblCellMar()) {
            CTTblCellMar ctMarg = tblPr.getTblCellMar();
            this.margin = new Insets(Util.getValueFromWidth(ctMarg.getTop()), Util.getValueFromWidth(ctMarg.getLeft()), Util.getValueFromWidth(ctMarg.getBottom()), Util.getValueFromWidth(ctMarg.getRight()));
        }
        if (parentStyle != null && parentStyle.tableBorder != null) {
            this.tableBorder = parentStyle.tableBorder;
        }
        if (tblPr != null && tblPr.isSetTblBorders()) {
            this.tableBorder = this.tableBorder == null ? new TableBorder(tblPr.getTblBorders(), themeColors) : this.tableBorder.mergeBorders(tblPr.getTblBorders(), themeColors);
        }
        if (parentStyle != null) {
            CellBorder defaultBorder = this.tableBorder != null ? new CellBorder(this.tableBorder) : null;
            for (CellType ct : ALL_CELL_TYPES) {
                CellStyle cs = parentStyle.getCellStyle(ct).clone();
                cs.setFontStyle(ParagraphAndRunStyle.mergeStyles(this.tableCellFont, cs.getFontStyle()));
                cs.setTableStyle(this);
                this.cellTypes.put(ct, cs);
            }
            if (defaultBorder != null) {
                for (CellType ct : ALL_CELL_TYPES) {
                    if (this.getCellStyle(ct).getBorder() != CellBorder.NO_BORDER) continue;
                    this.getCellStyle(ct).setBorder(defaultBorder);
                }
            }
            this.margin = parentStyle.margin;
        } else {
            CellStyle defaultCs = new CellStyle(this.tableCellFont, this);
            this.cellTypes.put(CellType.defaultCell, defaultCs);
            if (this.tableBorder == null) {
                this.tableBorder = TableBorder.getDefaultBorders();
                defaultCs.setBorder(CellBorder.NO_BORDER);
            } else {
                defaultCs.setBorder(new CellBorder(this.tableBorder));
            }
            for (CellType ct : ALL_CELL_TYPES) {
                if (ct == CellType.defaultCell) continue;
                CellStyle theClone = defaultCs.clone();
                this.cellTypes.put(ct, theClone);
            }
        }
        CTTcPr defaultTcPrs = cts.getTcPr();
        if (defaultTcPrs != null) {
            if (defaultTcPrs.isSetTcBorders()) {
                this.cellBorder = new CellBorder(defaultTcPrs.getTcBorders(), themeColors);
            }
            if (defaultTcPrs.isSetShd()) {
                CTShd shd = defaultTcPrs.getShd();
                Object col = shd.getFill();
                this.cellBg = Util.getColor(shd.getVal(), col, col, shd.getThemeFill(), themeColors);
            }
        }
        if ((styleprs = cts.getTblStylePrList()).size() > 0) {
            for (CTTblStylePr stylepr : styleprs) {
                String ctName = stylepr.getType().toString();
                CellType ct = StyleTable.getType(ctName);
                CellStyle cs = this.getCellStyle(ct);
                CTTcPr tcpr = stylepr.getTcPr();
                if (tcpr != null) {
                    if (tcpr.isSetTcBorders()) {
                        CellBorder cb = new CellBorder(tcpr.getTcBorders(), themeColors);
                        cs.setBorder(cb);
                    }
                    if (tcpr.isSetShd()) {
                        CTShd shd = tcpr.getShd();
                        Object col = shd.getFill();
                        Color bg = Util.getColor(shd.getVal(), col, col, shd.getThemeFill(), themeColors);
                        if (bg != null) {
                            cs.setCellBackground(bg);
                        }
                    }
                }
                ParagraphAndRunStyle fs = ParagraphAndRunStyle.mergeFontInfos(stylepr.getRPr(), documentDefaults, this.tableCellFont, ctName);
                CTPPrGeneral ppr = stylepr.getPPr();
                if (ppr != null && ppr.isSetJc()) {
                    fs.setHorAlign(ppr.getJc().getVal());
                }
                cs.setFontStyle(fs);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Color getCellDefaultBackground() {
        if (this.cellBg == null && this.parentStyle != null) {
            return this.parentStyle.getCellDefaultBackground();
        }
        return this.cellBg;
    }

    public CellBorder getCellDefaultBorder() {
        if (this.cellBorder == null && this.parentStyle != null) {
            return this.parentStyle.getCellDefaultBorder();
        }
        return this.cellBorder;
    }

    public Insets getCellMargin() {
        if (this.margin != null) {
            return this.margin;
        }
        return this.parentStyle == null ? null : this.parentStyle.getCellMargin();
    }

    @Override
    public StyleTable getParentStyle() {
        return this.parentStyle;
    }

    public ParagraphAndRunStyle getCnfFontStyle(String key) {
        List<CellType> ctypes = this.getCellTypesForCnfKey(key);
        return this.getCellStyle(ctypes).getFontStyle();
    }

    public TableBorder getTableBorders() {
        return this.tableBorder;
    }

    public List<CellType> getCellTypesForCnfKey(String key) {
        if (key != null) {
            ArrayList<CellType> cellStyles = new ArrayList<CellType>();
            if (key.charAt(11) == '1') {
                cellStyles.add(CellType.swCell);
            }
            if (key.charAt(10) == '1') {
                cellStyles.add(CellType.seCell);
            }
            if (key.charAt(9) == '1') {
                cellStyles.add(CellType.nwCell);
            }
            if (key.charAt(8) == '1') {
                cellStyles.add(CellType.neCell);
            }
            if (key.charAt(7) == '1') {
                cellStyles.add(CellType.band2Horz);
            }
            if (key.charAt(6) == '1') {
                cellStyles.add(CellType.band1Horz);
            }
            if (key.charAt(5) == '1') {
                cellStyles.add(CellType.band2Vert);
            }
            if (key.charAt(4) == '1') {
                cellStyles.add(CellType.band1Vert);
            }
            if (key.charAt(3) == '1') {
                cellStyles.add(CellType.lastCol);
            }
            if (key.charAt(2) == '1') {
                cellStyles.add(CellType.firstCol);
            }
            if (key.charAt(1) == '1') {
                cellStyles.add(CellType.lastRow);
            }
            if (key.charAt(0) == '1') {
                cellStyles.add(CellType.firstRow);
            }
            if (cellStyles.size() > 0) {
                return cellStyles;
            }
        }
        return new ArrayList<CellType>(DEFAULT_STYLE);
    }

    public CellStyle getCnfCellStyle(String key) {
        List<CellType> cts = this.getCellTypesForCnfKey(key);
        if (cts.size() == 1) {
            return this.getCellStyle(cts).clone();
        }
        return this.getCellStyle(cts);
    }

    public CellStyle getCellStyle(List<CellType> ctypes) {
        ctypes.sort(Comparator.comparingInt(o -> o.getValue()));
        CellStyle primaryStyle = this.cellTypes.get((Object)ctypes.get(0));
        for (int i = 1; i < ctypes.size(); ++i) {
            primaryStyle = CellStyle.merge(primaryStyle, this.cellTypes.get((Object)ctypes.get(i)));
        }
        primaryStyle.setFontStyle(ParagraphAndRunStyle.mergeStyles(primaryStyle.getFontStyle(), this.defaultFontstyle));
        return primaryStyle;
    }

    public CellStyle getCellStyle(CellType ct) {
        ArrayList<CellType> cTypes = new ArrayList<CellType>();
        cTypes.add(ct);
        return this.getCellStyle(cTypes);
    }

    private static CellType getType(String type) {
        try {
            return CellType.valueOf(type);
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException("Unknown cell type '" + type + "'");
            ex.initCause(e);
            Util.LOGGER.error((Throwable)ex);
            return CellType.defaultCell;
        }
    }

    public static enum CellType {
        band1Horz(9),
        band2Horz(11),
        band1Vert(10),
        band2Vert(12),
        firstCol(7),
        firstRow(5),
        lastCol(8),
        lastRow(6),
        neCell(2),
        nwCell(1),
        seCell(4),
        swCell(3),
        defaultCell(20);

        private int ranking;

        private CellType(int ranking) {
            this.ranking = ranking;
        }

        private int getValue() {
            return this.ranking;
        }
    }
}

