/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document;

import com.inet.cache.image.SerializableImage;
import com.inet.docx.document.RelationObject;
import com.inet.docx.document.elements.Comment;
import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.HeaderFooter;
import com.inet.docx.document.elements.PageBackground;
import com.inet.docx.document.elements.style.Indent;
import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.NumberingLevel;
import com.inet.docx.document.elements.style.ParagraphAndRunStyle;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.elements.style.Style;
import com.inet.docx.document.elements.style.StyleTable;
import com.inet.docx.document.elements.style.TextFrame;
import com.inet.docx.document.elements.subelements.Field;
import com.inet.docx.document.elements.subelements.Footnote;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.paragraph.ParagraphFactory;
import com.inet.docx.document.paragraph.StringLayouter;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.PageProperties;
import com.inet.docx.xwpf.XWPFDocumentOwnImpl;
import com.inet.docx.xwpf.usermodel.XWPFFontInformation;
import com.inet.docx.xwpf.usermodel.XWPFSettings;
import com.inet.docx.xwpf.usermodel.XWPFStyleDefaults;
import com.inet.docx.xwpf.usermodel.XWPFThemeData;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STVerticalAlignRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBackground;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFramePr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrGeneral;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFtnEdn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STStyleType;

public class DocumentProperties {
    public static final String DEFAULT_HEADER_OR_FOOTER = "DEFAULT_HEADER_FOOTER";
    public static final String DEFAULT_FONT_STYLE = "DEFAULT_FONT_STYLE";
    public static final String NORMAL_FONT_STYLE = "Normal";
    private PageBackground pageBackground = new PageBackground();
    private PageProperties defaultDocumentPageProperties;
    private XWPFStyleDefaults styleDefaults;
    private HashMap<String, Style> usedStyles = new HashMap();
    private HashMap<String, NumberingLevel> numberingLevels = new HashMap();
    private HashMap<String, StringLayouter> layouterMap = new HashMap();
    private ArrayList<Comment> comments;
    private XWPFStyles availableStyles;
    private HashMap<String, HeaderFooter> headers = new HashMap();
    private HashMap<String, HeaderFooter> footers = new HashMap();
    private HashMap<String, Color> themeColors;
    private Integer pageNumberStart;
    private RenderFont defaultRenderFont;
    private ArrayList<Field> fields = new ArrayList();
    private HashMap<String, ParagraphData> bookmarks = new HashMap();
    private HashMap<Field.FieldNames, Object> documentProps = new HashMap();
    private HashMap<BigInteger, Footnote> footnotes = new HashMap();
    private HashMap<String, Object> pictureReferenceIdToSessionKey = new HashMap();
    private Set<String> fontNames;
    private HashMap<String, PackagePart> workbookReferences;
    private Map<String, RelationObject> relationObjects;
    private String normalStyleId = "Normal";
    private Map<String, ArrayList<String>> preserveTexts;
    private List<String> currentPreserveTexts;
    private String currentPartName;
    private XWPFDocumentOwnImpl doc;
    private XWPFSettings settings;

    public DocumentProperties(XWPFDocumentOwnImpl doc) {
        XWPFThemeData theme;
        this.doc = doc;
        CTDocument1 document = doc.getDocument();
        CTBackground bg = document.getBackground();
        if (bg != null) {
            this.pageBackground = new PageBackground(bg);
        }
        POIXMLProperties.CoreProperties cp = doc.getProperties().getCoreProperties();
        this.documentProps.put(Field.FieldNames.CREATEDATE, cp.getCreated());
        this.documentProps.put(Field.FieldNames.PRINTDATE, cp.getLastPrinted());
        this.documentProps.put(Field.FieldNames.SAVEDATE, cp.getModified());
        this.documentProps.put(Field.FieldNames.LASTSAVEDBY, cp.getLastModifiedByUser());
        this.documentProps.put(Field.FieldNames.TITLE, cp.getTitle());
        this.documentProps.put(Field.FieldNames.AUTHOR, cp.getCreator());
        this.documentProps.put(Field.FieldNames.SUBJECT, cp.getSubject());
        this.documentProps.put(Field.FieldNames.REVNUM, cp.getRevision());
        this.documentProps.put(Field.FieldNames.COMMENTS, cp.getDescription());
        this.documentProps.put(Field.FieldNames.KEYWORDS, cp.getKeywords());
        POIXMLProperties.ExtendedProperties ep = doc.getProperties().getExtendedProperties();
        this.documentProps.put(Field.FieldNames.NUMPAGES, ep.getPages());
        this.documentProps.put(Field.FieldNames.TEMPLATE, ep.getTemplate());
        this.documentProps.put(Field.FieldNames.APPLICATION, ep.getApplication());
        this.documentProps.put(Field.FieldNames.APPVERSION, ep.getAppVersion());
        this.documentProps.put(Field.FieldNames.NUMWORDS, ep.getWords());
        this.documentProps.put(Field.FieldNames.NUMCHARS, ep.getCharacters());
        Util.LOGGER.info((Object)(String.valueOf(this.documentProps.get((Object)Field.FieldNames.APPLICATION)) + " " + String.valueOf(this.documentProps.get((Object)Field.FieldNames.APPVERSION)) + " pages " + String.valueOf(this.documentProps.get((Object)Field.FieldNames.NUMPAGES))));
        this.workbookReferences = doc.getWorkbooks();
        this.styleDefaults = doc.getStyleDefaults();
        if (this.styleDefaults == null) {
            this.styleDefaults = XWPFStyleDefaults.getDefaultInstance();
        }
        if ((theme = doc.getThemeData()) != null) {
            this.themeColors = theme.getThemeColors();
            this.styleDefaults.handleThemeSettings(theme);
            this.fontNames = theme.getFontNames();
        } else {
            this.fontNames = new HashSet<String>();
        }
        CTBody body = document.getBody();
        CTSectPr pageSection = body.getSectPr();
        if (pageSection != null) {
            CTPageNumber pn = pageSection.getPgNumType();
            if (pn != null && pn.getStart() != null) {
                this.pageNumberStart = pn.getStart().intValue();
            }
            this.defaultDocumentPageProperties = new PageProperties(pageSection, this);
        } else {
            this.defaultDocumentPageProperties = new PageProperties(12240, 15840, new Insets(1440, 1440, 1440, 1440));
        }
        this.availableStyles = doc.getStyles();
        this.setStyleDefaults();
        this.setNumbering(doc.getNumbering());
        this.settings = doc.getDocumentSettings();
        ParagraphAndRunStyle defaultFont = this.getDefaultStyleFont();
        this.defaultRenderFont = new RenderFont(defaultFont.getFontName(), defaultFont.getFontSize().floatValue(), defaultFont.getFontStyle(), null, false, false, false, 0.0, 1.0, 0);
        this.getLayouter(this.defaultRenderFont);
        this.comments = doc.getCommentsInternal();
        this.preserveTexts = doc.getPreserveTexts();
        this.setCurrentPartName("footnote");
        this.readFootnotes(doc.getFootnotes());
        this.relationObjects = doc.getInternalRelations();
    }

    public String getCurrentPartName() {
        return this.currentPartName;
    }

    public void setCurrentPartName(String currentPartName) {
        this.currentPartName = currentPartName;
        this.currentPreserveTexts = this.preserveTexts.get(currentPartName);
    }

    public String checkPreserveText(String input) {
        int index = this.currentPreserveTexts.indexOf(input);
        if (index > -1) {
            this.preserveTexts.remove(input);
            return input;
        }
        for (String str : this.currentPreserveTexts) {
            if (!input.equals(str.trim())) continue;
            this.preserveTexts.remove(str);
            return str;
        }
        return input;
    }

    public RelationObject getRelation(String key, Rectangle2D bounds) {
        RelationObject relObj = this.relationObjects.get(key);
        if (relObj == null) {
            Util.LOGGER.warn((Object)("Could not found the docx element with key " + key));
            return null;
        }
        relObj.init(this, bounds);
        return relObj;
    }

    public PackagePart getWorkbookReference(String refId) {
        if (this.workbookReferences == null) {
            return null;
        }
        return this.workbookReferences.get(refId);
    }

    public String getCaseSensitiveFontName(String fontName) {
        for (String name : this.fontNames) {
            if (!name.equalsIgnoreCase(fontName)) continue;
            return name;
        }
        return fontName;
    }

    private void readFootnotes(List<XWPFFootnote> footnoteList) {
        int index = 1;
        for (XWPFFootnote footnote : footnoteList) {
            BigInteger id = footnote.getId();
            if (footnote.getCTFtnEdn().getType() != STFtnEdn.NORMAL && footnote.getCTFtnEdn().getType() != null) continue;
            List bodyEles = footnote.getBodyElements();
            ArrayList<ParagraphData> content = new ArrayList<ParagraphData>();
            for (IBodyElement bodyEle : bodyEles) {
                content.add(ParagraphFactory.readParagraph(this, (XWPFParagraph)bodyEle, false, this.getDefaultStyleFont()));
            }
            this.footnotes.put(id, new Footnote(index++, content));
        }
    }

    @Nullable
    public Footnote getFootnoteData(BigInteger id) {
        return this.footnotes.get(id);
    }

    public Object getValue(Field.FieldNames key) {
        return this.documentProps.get((Object)key);
    }

    public void registerVariableField(Field field) {
        this.fields.add(field);
    }

    public void registerBookmark(String key, ParagraphData referencedParagraph) {
        this.bookmarks.put(key, referencedParagraph);
    }

    public Integer getPageNumberStart() {
        return this.pageNumberStart;
    }

    public PageBackground getPageBackground() {
        if (this.pageBackground.getImageKey() != null) {
            return new PageBackground(this.pageBackground, this.getImageData(this.pageBackground.getImageKey()));
        }
        return this.pageBackground;
    }

    public String handleFontKeys(String fontKey) {
        if (fontKey.equals("+mn-lt")) {
            return this.styleDefaults.getMinorLatinThemeFont();
        }
        if (fontKey.equals("+mj-lt")) {
            return this.styleDefaults.getMajorLatinThemeFont();
        }
        return fontKey;
    }

    public Color getThemeColor(String key) {
        return this.themeColors.get(key);
    }

    public HashMap<String, Color> getThemeColors() {
        return this.themeColors;
    }

    public void addHeaderFooter(boolean isHeader, String key, List<DocumentElement> elements) {
        HashMap<String, HeaderFooter> current = isHeader ? this.headers : this.footers;
        current.put(key, new HeaderFooter(elements, this.defaultDocumentPageProperties, isHeader));
    }

    public Map<String, HeaderFooter> getHeaderFooter(boolean isHeader, List<String[]> keys) {
        if (keys == null) {
            return null;
        }
        HashMap<String, HeaderFooter> current = isHeader ? this.headers : this.footers;
        HashMap<String, HeaderFooter> hfList = new HashMap<String, HeaderFooter>();
        for (String[] key : keys) {
            HeaderFooter hf = current.get(key[0]);
            String useType = key[1];
            if ("even".equals(useType) && !this.isUseOddAndEvenParts()) {
                useType = "invalid";
            }
            hfList.put(useType, hf);
        }
        return hfList;
    }

    public Comment getComment(BigInteger id) {
        for (Comment comment : this.comments) {
            if (!id.equals(comment.getId())) continue;
            return comment;
        }
        return null;
    }

    public void putImageData(String referenceId, BufferedImage image, byte[] rawData) {
        if (this.getImageKey(referenceId) != null) {
            Util.LOGGER.debug((Object)("Duplicate reference information for id " + referenceId));
            return;
        }
        this.pictureReferenceIdToSessionKey.put(referenceId, new SerializableImage((Image)image, rawData));
    }

    public Object getImageKey(String referenceId) {
        return this.pictureReferenceIdToSessionKey.get(referenceId);
    }

    public SerializableImage getImageData(String referenceId) {
        return (SerializableImage)this.pictureReferenceIdToSessionKey.get(referenceId);
    }

    public StringLayouter getLayouter(RenderFont fontInfo) {
        if (fontInfo == null) {
            return null;
        }
        StringLayouter layouter = this.layouterMap.get(fontInfo.toString());
        if (layouter == null) {
            HashMap attributes;
            XWPFFontInformation xwpfFontInformation = this.doc.getEmbeddedFontInformations().get(fontInfo.getFontName());
            int fontSize = (int)fontInfo.getFontSize();
            Font font = xwpfFontInformation == null || !this.settings.hasEmbeddedTrueFont() ? new Font(fontInfo.getFontName(), fontInfo.getFontStyle(), fontSize) : xwpfFontInformation.getFont();
            font = font.deriveFont(fontInfo.getFontSize());
            if ((float)fontSize < fontInfo.getFontSize()) {
                font = font.deriveFont(fontInfo.getFontSize());
            }
            if (fontInfo.getSpacing() != 0.0) {
                attributes = new HashMap(font.getAttributes());
                attributes.put(TextAttribute.TRACKING, fontInfo.getSpacing());
                font = font.deriveFont(attributes);
            }
            if (fontInfo.getTextScale() < 0.5 || fontInfo.getTextScale() > 10.0) {
                Util.LOGGER.warn((Object)"A Textwidth smaller as 0.5 or higher than 10 are not supported.");
            }
            if (fontInfo.getTextScale() != 1.0) {
                attributes = new HashMap(font.getAttributes());
                attributes.put(TextAttribute.WIDTH, fontInfo.getTextScale());
                font = font.deriveFont(attributes);
            }
            layouter = new StringLayouter(font, fontInfo.getVerticalAlign() != STVerticalAlignRun.BASELINE);
            this.layouterMap.put(fontInfo.toString(), layouter);
        }
        fontInfo.setRenderDimensions(layouter.getFontDimensions());
        return layouter;
    }

    public void close() {
        this.availableStyles = null;
        for (Map.Entry<String, StringLayouter> entry : this.layouterMap.entrySet()) {
            entry.getValue().close();
        }
    }

    public PageProperties getDefaultDocumentPageProperties() {
        return this.defaultDocumentPageProperties;
    }

    public NumberingLevel getNumberingLevel(int id, int level) {
        return this.numberingLevels.get(id + "." + level);
    }

    public XWPFSettings getSettings() {
        return this.settings;
    }

    private void setNumbering(XWPFNumbering numbering) {
        if (numbering == null) {
            return;
        }
        HashMap<CallSite, NumberingLevel> orgLevels = new HashMap<CallSite, NumberingLevel>();
        for (long i = 0L; i < 100L; ++i) {
            if (!numbering.numExist(BigInteger.valueOf(i))) continue;
            BigInteger id = BigInteger.valueOf(i);
            XWPFNum num = numbering.getNum(id);
            CTNum innerNum = num.getCTNum();
            List numLevList = innerNum.getLvlOverrideList();
            XWPFAbstractNum anum = numbering.getAbstractNum(innerNum.getAbstractNumId().getVal());
            CTAbstractNum ctanum = anum.getAbstractNum();
            List lvls = ctanum.getLvlList();
            BigInteger abstrac = ctanum.getAbstractNumId();
            NumberingLevel prev = null;
            for (int n = 0; n < lvls.size(); ++n) {
                String key = i + "." + n;
                String abstractKey = String.valueOf(abstrac) + "." + n;
                NumberingLevel newLvl = (NumberingLevel)orgLevels.get(abstractKey);
                if (newLvl == null) {
                    newLvl = new NumberingLevel((CTLvl)lvls.get(n), this, i, n);
                    orgLevels.put((CallSite)((Object)abstractKey), newLvl);
                }
                newLvl = this.handleOverrides(newLvl, numLevList, prev);
                newLvl.updateKey(i);
                prev = newLvl;
                this.numberingLevels.put(key, newLvl);
            }
            for (CTNumLvl lvl : numLevList) {
                int n = lvl.getIlvl().intValue();
                if (n < lvls.size()) continue;
                String key = i + "." + n;
                String abstractKey = String.valueOf(abstrac) + "." + n;
                NumberingLevel newLvl = (NumberingLevel)orgLevels.get(abstractKey);
                if (newLvl == null) {
                    CTLvl refLevel = lvl.getLvl();
                    if (refLevel == null) continue;
                    newLvl = new NumberingLevel(refLevel, this, i, n);
                    orgLevels.put((CallSite)((Object)abstractKey), newLvl);
                }
                newLvl = this.handleOverrides(newLvl, numLevList, (NumberingLevel)orgLevels.get(String.valueOf(abstrac) + "." + (n - 1)));
                newLvl.updateKey(i);
                this.numberingLevels.put(key, newLvl);
            }
        }
    }

    private NumberingLevel handleOverrides(NumberingLevel newLvl, List<CTNumLvl> numLevList, NumberingLevel parent) {
        for (CTNumLvl numLev : numLevList) {
            if (newLvl.getLevel() != numLev.getIlvl().intValue()) continue;
            newLvl = newLvl.merge(numLev, this);
        }
        if (parent != null) {
            if (parent.isReplacement() && !newLvl.isReplacement()) {
                newLvl = newLvl.clone();
            }
            parent.setChild(newLvl);
        }
        return newLvl;
    }

    private void setStyleDefaults() {
        ParagraphAndRunStyle defaultSettingsStyle = new ParagraphAndRunStyle(RunRenderInformations.getDefault(this.getStyleDefaults()), null);
        defaultSettingsStyle.setName(DEFAULT_FONT_STYLE);
        defaultSettingsStyle.setSpacing(this.getStyleDefaults().getDefaultSpacing());
        defaultSettingsStyle.setHorAlign(this.getStyleDefaults().getDefaultHorizontalAlign());
        defaultSettingsStyle.setIndent(new Indent(null, null, null, null));
        this.usedStyles.put(DEFAULT_FONT_STYLE, defaultSettingsStyle);
        XWPFStyle normal = this.getStyleWithName(NORMAL_FONT_STYLE);
        if (normal != null) {
            this.normalStyleId = normal.getStyleId();
            this.addStyle(this.normalStyleId, normal);
            this.usedStyles.put(NORMAL_FONT_STYLE, ParagraphAndRunStyle.mergeStyles(this.getStyleFont(this.normalStyleId), defaultSettingsStyle));
        } else {
            ParagraphAndRunStyle ps = new ParagraphAndRunStyle(defaultSettingsStyle.getTextRenderInformations(), defaultSettingsStyle);
            ps.setName(NORMAL_FONT_STYLE);
            this.usedStyles.put(NORMAL_FONT_STYLE, ps);
        }
    }

    public Spacing getDefaultSpacing() {
        if (this.getStandardStyleFont().getParagraphSpacing(false) != null) {
            return this.getStandardStyleFont().getParagraphSpacing(false);
        }
        return this.getStyleDefaults().getDefaultSpacing();
    }

    public STJc.Enum getDefaultHorizontalAlign() {
        return this.styleDefaults.getDefaultHorizontalAlign();
    }

    @Nonnull
    public XWPFStyleDefaults getStyleDefaults() {
        return this.styleDefaults;
    }

    public ParagraphAndRunStyle getStyleFont(String name) {
        return (ParagraphAndRunStyle)this.getStyle(name);
    }

    public ParagraphAndRunStyle getDefaultStyleFont() {
        ParagraphAndRunStyle pars = (ParagraphAndRunStyle)this.usedStyles.get(NORMAL_FONT_STYLE);
        return pars != null ? pars : (ParagraphAndRunStyle)this.usedStyles.get(DEFAULT_FONT_STYLE);
    }

    public ParagraphAndRunStyle getStandardStyleFont() {
        return (ParagraphAndRunStyle)this.usedStyles.get(this.normalStyleId);
    }

    public RenderFont getDefaultRenderFont() {
        return this.defaultRenderFont.clone();
    }

    public Style getStyle(String name) {
        XWPFStyle style;
        if (this.usedStyles.get(name) == null && (style = this.getStyleWithID(name)) != null) {
            String baseStyle = style.getBasisStyleID();
            if (baseStyle != null) {
                this.getStyle(baseStyle);
            }
            this.addStyle(name, style);
        }
        return this.usedStyles.get(name);
    }

    public StyleTable getBaseTableStyle() {
        for (String key : this.usedStyles.keySet()) {
            Style style = this.usedStyles.get(key);
            if (style.getParentStyle() != null || !(style instanceof StyleTable)) continue;
            return (StyleTable)style;
        }
        XWPFStyle style = this.getStyleWithName("Normal Table");
        if (style != null) {
            String id = style.getStyleId();
            this.addStyle(style.getStyleId(), style);
            return (StyleTable)this.usedStyles.get(id);
        }
        return null;
    }

    @Nullable
    private XWPFStyle getStyleWithName(String name) {
        return this.availableStyles == null ? null : this.availableStyles.getStyleWithName(name);
    }

    @Nullable
    private XWPFStyle getStyleWithID(String name) {
        return this.availableStyles == null ? null : this.availableStyles.getStyle(name);
    }

    public boolean isUseOddAndEvenParts() {
        return this.doc.getEvenAndOddHeadings();
    }

    private void addStyle(String name, XWPFStyle style) {
        CTStyle cts = style.getCTStyle();
        CTRPr ctrpr = cts.getRPr();
        RunRenderInformations renderInformations = RunRenderInformations.getRenderInformations(ctrpr, this);
        String baseStyle = style.getBasisStyleID();
        if (STStyleType.PARAGRAPH.equals(style.getType()) || STStyleType.CHARACTER.equals(style.getType())) {
            CTPPrGeneral ctppr = cts.getPPr();
            ParagraphAndRunStyle sf = new ParagraphAndRunStyle(renderInformations, (ParagraphAndRunStyle)this.usedStyles.get(DEFAULT_FONT_STYLE));
            sf.setName(cts.getName().getVal());
            ParagraphAndRunStyle parentStyle = null;
            if (baseStyle != null) {
                parentStyle = (ParagraphAndRunStyle)this.usedStyles.get(baseStyle);
            }
            sf.setParentFontStyle(parentStyle);
            if (ctppr != null) {
                CTFramePr frmPr = ctppr.getFramePr();
                if (frmPr != null) {
                    sf.setTextFrame(new TextFrame(frmPr));
                }
                if (ctppr.isSetInd()) {
                    Indent parentIndent = parentStyle != null ? parentStyle.getIndent() : null;
                    sf.setIndent(Util.getIndent(ctppr.getInd(), parentIndent));
                }
                if (ctppr.isSetSpacing()) {
                    Spacing parentSpacing = parentStyle != null ? parentStyle.getParagraphSpacing(false) : null;
                    sf.setSpacing(new Spacing(ctppr.getSpacing(), parentSpacing));
                } else if (parentStyle == null) {
                    sf.setSpacing(this.styleDefaults.getDefaultSpacing());
                }
                sf.setBorder(Util.getBorders(ctppr.getPBdr(), this.getThemeColors()));
                sf.setContextualSpacing(Util.getBooleanForOnOff(ctppr.getContextualSpacing(), true));
                sf.setWidowControl(Util.getBooleanForOnOff(ctppr.getWidowControl(), false));
                sf.setWidowControl(Boolean.TRUE);
                if (ctppr.isSetTabs()) {
                    LineProperties underline = sf.getUnderline();
                    boolean strikeThrough = sf.getStrikethrough() != null ? sf.getStrikethrough() : false;
                    boolean invisible = sf.getVanish() != null ? sf.getVanish() : false;
                    boolean smallCaps = sf.getSmallCaps() != null ? sf.getSmallCaps() : false;
                    String fontName = sf.getFontName() != null ? sf.getFontName() : "Arial";
                    float fontSize = sf.getFontSize() != null ? sf.getFontSize().floatValue() : 11.0f;
                    float textScale = sf.getTextScale() != null ? sf.getTextScale().floatValue() : 1.0f;
                    int vertOff = sf.getVerticalPosition() != null ? sf.getVerticalPosition() : 0;
                    RenderFont rf = new RenderFont(fontName, fontSize, sf.getFontStyle(), underline, strikeThrough, invisible, smallCaps, 0.0, textScale, vertOff);
                    this.getLayouter(rf);
                    sf.setTabData(Util.getTabs(ctppr.getTabs(), rf));
                }
                if (ctppr.isSetKeepLines()) {
                    sf.setKeepParagraphOnTheSamePage();
                }
                if (ctppr.isSetKeepNext()) {
                    sf.setKeepParagraphTogetherWithNextParagraph();
                }
                if (ctppr.isSetPageBreakBefore() && !ctppr.getPageBreakBefore().isSetVal()) {
                    sf.setPageBreakBefore();
                }
                if (ctppr.isSetJc()) {
                    try {
                        sf.setHorAlign(ctppr.getJc().getVal());
                    }
                    catch (XmlValueOutOfRangeException underline) {}
                } else if (parentStyle == null) {
                    STJc.Enum horAlign = this.styleDefaults.getDefaultHorizontalAlign();
                    if (horAlign == null) {
                        horAlign = STJc.LEFT;
                    }
                    sf.setHorAlign(horAlign);
                }
            }
            this.usedStyles.put(name, sf);
            String linkID = style.getLinkStyleID();
            if (linkID != null) {
                ParagraphAndRunStyle linkStyle = this.getStyleFont(linkID);
                sf.setLinkStyle(linkStyle);
            }
        } else if (STStyleType.TABLE.equals(style.getType())) {
            StyleTable tblBaseStyle = baseStyle != null ? (StyleTable)this.usedStyles.get(baseStyle) : null;
            this.usedStyles.put(name, new StyleTable(tblBaseStyle, this.getStandardStyleFont(), this.themeColors, cts, this, name));
        } else if (STStyleType.NUMBERING.equals(style.getType())) {
            Util.LOGGER.info((Object)("### Unhandled STYLE: " + name + " " + String.valueOf(style.getType()) + " " + (ctrpr != null)));
        }
    }
}

