/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf.records.bitmap;

import com.inet.emf.EMFReader;
import com.inet.emf.EmfUtil;

public class BitmapInfoHeader
implements EMFReader {
    private int width;
    private int height;
    private int planes;
    private int bitCount;
    private Compression compression;
    private int imageSize;
    private int xPelsPerMeter;
    private int yPelsPerMeter;
    private int colorUsed;
    private int colorImportant;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPlanes() {
        return this.planes;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public int getImageSize() {
        return this.imageSize;
    }

    public int getResolutionX() {
        return this.xPelsPerMeter;
    }

    public int getResolutionY() {
        return this.yPelsPerMeter;
    }

    public int getColorUsed() {
        return this.colorUsed;
    }

    public int getColorImportant() {
        return this.colorImportant;
    }

    @Override
    public int read(byte[] source, int offset) {
        int headerSize = EmfUtil.read4BytesInteger(source, offset);
        this.width = EmfUtil.read4BytesInteger(source, offset + 4);
        this.height = EmfUtil.read4BytesInteger(source, offset + 8);
        this.planes = EmfUtil.read2BytesInteger(source, offset + 12);
        this.bitCount = EmfUtil.read2BytesInteger(source, offset + 14);
        this.compression = Compression.getValue(EmfUtil.read2BytesInteger(source, offset + 16));
        this.imageSize = EmfUtil.read2BytesInteger(source, offset + 20);
        this.xPelsPerMeter = EmfUtil.read2BytesInteger(source, offset + 24);
        this.yPelsPerMeter = EmfUtil.read2BytesInteger(source, offset + 28);
        this.colorUsed = EmfUtil.read2BytesInteger(source, offset + 32);
        this.colorImportant = EmfUtil.read2BytesInteger(source, offset + 36);
        return headerSize;
    }

    public String toString() {
        return "BitmapInfoHeader{width=" + this.width + ", height=" + this.height + ", planes=" + this.planes + ", bitCount=" + this.bitCount + ", compression=" + String.valueOf((Object)this.compression) + ", imageSize=" + this.imageSize + ", xPelsPerMeter=" + this.xPelsPerMeter + ", yPelsPerMeter=" + this.yPelsPerMeter + ", colorUsed=" + this.colorUsed + ", colorImportant=" + this.colorImportant + "}";
    }

    public static enum Compression {
        BI_RGB(0),
        BI_RLE8(1),
        BI_RLE4(2),
        BI_BITFIELDS(3),
        BI_JPEG(4),
        BI_PNG(5),
        BI_CMYK(11),
        BI_CMYKRLE8(12),
        BI_CMYKRLE4(13);

        private final int id;

        private Compression(int id) {
            this.id = id;
        }

        public static Compression getValue(int id) {
            for (Compression value : Compression.values()) {
                if (value.id != id) continue;
                return value;
            }
            EmfUtil.getLogger().debug((Object)("PenStyleOptional with the id " + id + " didn't exist"));
            return BI_RGB;
        }
    }
}

