/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf;

import com.inet.emf.EmfGraphic;
import com.inet.emf.EmfUtil;
import com.inet.emf.GraphicObject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;

public class EmfRecordExecutor
implements EmfGraphic {
    private Graphics2D graphics2D;
    private Path2D path;
    private Path2D selectedPath;
    private GraphicObject[] graphicObjects;
    private BufferedImage image;
    private int windingRule = 0;
    private Paint background;
    private Paint foreground;
    private Point viewportExtEx;
    private Point windowExtEx;
    private boolean shouldUse;

    public void setViewportExtEx(Point viewportExtEx) {
        this.viewportExtEx = viewportExtEx;
    }

    public void setWindowExtEx(Point windowExtEx) {
        this.windowExtEx = windowExtEx;
    }

    public void setShouldUse(boolean shouldUse) {
        this.shouldUse = shouldUse;
    }

    @Override
    public void setBackground(Paint background) {
        this.background = background;
    }

    @Override
    public void setForeground(Paint foreground) {
        this.foreground = foreground;
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.graphics2D.setStroke(stroke);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Path2D getPath() {
        return this.path;
    }

    public void setWindingRule(int rule) {
        if (0 == rule || 1 == rule) {
            this.windingRule = rule;
        } else {
            EmfUtil.getLogger().warn((Object)("The winding rule " + rule + " didn't exist."));
        }
    }

    public void createPath() {
        this.path = new Path2D.Double();
        this.path.setWindingRule(this.windingRule);
    }

    public void setGraphicObject(int index, GraphicObject graphicObject) {
        if (index == 0) {
            EmfUtil.getLogger().error((Object)"Records wasn't read");
            return;
        }
        if (this.graphicObjects.length < index) {
            EmfUtil.getLogger().error((Object)("The object with the id " + index + " is to high."));
            return;
        }
        if (graphicObject == null && this.graphicObjects[index] == null) {
            EmfUtil.getLogger().warn((Object)("The object with the id " + index + " cann't delete."));
        }
        this.graphicObjects[index] = graphicObject;
    }

    public void selectObject(int index) {
        if (this.graphicObjects.length < index || index < 0) {
            EmfUtil.getLogger().warn((Object)("The object with the id " + index + " didn't exist."));
        }
        this.graphicObjects[index].changeGraphics(this);
    }

    public void selectObject(GraphicObject graphicObject) {
        graphicObject.changeGraphics(this);
    }

    public void selectPath() {
        this.selectedPath = this.path;
    }

    public void initialize(int width, int height, int numOfGraphicObject) {
        this.image = new BufferedImage(width, height, 2);
        this.graphics2D = (Graphics2D)this.image.getGraphics();
        this.graphicObjects = new GraphicObject[numOfGraphicObject];
        this.graphics2D.setColor(Color.WHITE);
        this.graphics2D.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
    }

    public void drawPath() {
        if (this.selectedPath == null) {
            EmfUtil.getLogger().warn((Object)"Cann't paint path");
        }
        this.setGraphicsSpec();
        this.graphics2D.setPaint(this.foreground);
        this.graphics2D.draw(this.selectedPath);
        this.resetGraphics();
    }

    public void fillPath() {
        if (this.selectedPath == null) {
            EmfUtil.getLogger().warn((Object)"Cann't paint filled path");
        }
        this.setGraphicsSpec();
        this.graphics2D.setPaint(this.background);
        this.graphics2D.fill(this.selectedPath);
        this.resetGraphics();
    }

    public void drawImage(BufferedImage image, Rectangle dest) {
        this.graphics2D.drawImage(image, dest.x, dest.y, dest.width, dest.height, null);
    }

    private void setGraphicsSpec() {
        AffineTransform transform = this.getTransform();
        if (transform != null) {
            this.graphics2D.setTransform(transform);
        }
    }

    private void resetGraphics() {
        AffineTransform transform = this.getTransform();
        if (transform != null) {
            try {
                this.graphics2D.setTransform(transform.createInverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    }

    private AffineTransform getTransform() {
        if (this.shouldUse && this.viewportExtEx != null && this.windowExtEx != null) {
            double scaleX = this.viewportExtEx.getX() / this.windowExtEx.getX();
            double scaleY = this.viewportExtEx.getY() / this.windowExtEx.getY();
            return new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
        }
        return null;
    }
}

