/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.view.paragraph;

import com.inet.docx.document.elements.subelements.Positionable;
import com.inet.docx.document.elements.subelements.TextRowElement;

public class RowTextPiece
extends Positionable {
    private String text;
    private double width;
    private TextRowElement parent;
    private int startIndex;
    private double lineFactor;
    private boolean isEmpty;
    private boolean isBounded = false;

    public RowTextPiece(String text, double width, double relativeStart, TextRowElement parent, int startIndex, double lineFactor) {
        this.parent = parent;
        this.text = text;
        this.width = width;
        this.startIndex = startIndex;
        this.lineFactor = lineFactor;
        this.isEmpty = text == null || text.trim().length() == 0;
        this.setRelativeStart(relativeStart);
    }

    public String getText() {
        return this.text;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    public TextRowElement getParent() {
        return this.parent;
    }

    @Override
    public double getHeight() {
        return this.parent.getRenderFont().getRenderDimensions().getRowHeight() * this.lineFactor;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public double getBaseline() {
        return this.parent.getRenderFont().getRenderDimensions().getBaselineHeight();
    }

    public void setBounded(boolean bounded) {
        this.isBounded = bounded;
    }

    public boolean isBounded() {
        return this.isBounded;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public String toString() {
        return "RowTextPiece{text='" + this.text + "', parent=" + String.valueOf(this.parent) + "}";
    }
}

