/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.layout;

import com.inet.docx.document.elements.subelements.Break;
import com.inet.docx.document.elements.subelements.drawing.Anchor;
import com.inet.docx.document.table.TableData;
import com.inet.docx.layout.AnchorManager;
import com.inet.docx.layout.LayoutArea;
import com.inet.docx.layout.Layouter;
import com.inet.docx.layout.LayouterResult;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.RenderContext;
import com.inet.docx.view.drawing.BorderLineExternalWidths;
import com.inet.docx.view.table.CellPageBreakPosition;
import com.inet.docx.view.table.TablePageBreakPosition;
import com.inet.docx.view.table.TableView;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJcTable;

public class TableLayouter
implements Layouter<TableView> {
    private TableData tableData;
    private TableView view;

    public TableLayouter(TableData tableData) {
        this.tableData = tableData;
    }

    @Override
    public LayouterResult<TableView> doLayouter(CellPageBreakPosition startBreak, CellPageBreakPosition endBreak, LayoutArea layoutArea, RenderContext context, AnchorManager anchors, boolean isFirstPageContent) {
        TablePageBreakPosition actualStart;
        TablePageBreakPosition start = startBreak != null ? startBreak.getTableBreakInfo() : null;
        TablePageBreakPosition end = endBreak != null ? endBreak.getTableBreakInfo() : null;
        TablePageBreakPosition tablePageBreakPosition = actualStart = start != null && !start.isRestartOnNextPage() ? start : null;
        if (this.view == null || !this.view.isSameSubtable(start, end)) {
            this.view = new TableView(this.tableData, layoutArea.getX(), layoutArea.getWidth(), actualStart, end, context);
        }
        TableView resultView = this.view;
        TablePageBreakPosition breakPosition = null;
        if (layoutArea.getHeight() <= this.view.getHeight() && context.getContextType().canBreakPage()) {
            TablePageBreakPosition nextPosition;
            TablePageBreakPosition breakStart = breakPosition = this.view.calculateNextBreak(layoutArea.getHeight(), start);
            if (breakPosition != null && !breakPosition.hasDisplayableContent() && !(nextPosition = new TablePageBreakPosition(this.tableData.getColumnCount(), breakStart.getBreakRow() - 1)).equals(start)) {
                breakPosition = nextPosition;
            }
            if (breakPosition == null || breakPosition.getBreakRow() >= 0) {
                resultView = breakPosition == null || breakPosition.getBreakRow() >= 0 ? new TableView(this.view, layoutArea.getX(), layoutArea.getWidth(), actualStart, breakPosition, context) : null;
                this.view = new TableView(this.view, layoutArea.getX(), layoutArea.getWidth(), breakPosition, null, context);
            } else {
                resultView = null;
                breakPosition = new TablePageBreakPosition();
            }
        }
        boolean oddPage = context.getInSectionPageNumber() % 2 != 0;
        this.applyPosition(resultView, layoutArea, context.getPageLayout(), oddPage);
        return new TableLayouterResult(breakPosition == null ? null : new CellPageBreakPosition(this.tableData, breakPosition, true), resultView);
    }

    private void applyPosition(TableView table, LayoutArea layoutArea, PageProperties pageLayout, boolean oddPage) {
        double pageY;
        if (table == null) {
            return;
        }
        TableData source = table.getSource();
        Anchor anchorHorizontal = source.getHorizontalAnchor();
        Anchor anchorVertical = source.getVerticalAnchor();
        double x = layoutArea.getX();
        double y = layoutArea.getY();
        BorderLineExternalWidths borderLineWidths = source.getBorderLineExternalWidths();
        double pageX = anchorHorizontal == null ? x : anchorHorizontal.getPositionValue(pageLayout, table.getWidth(), x, oddPage, borderLineWidths);
        double d = pageY = anchorVertical == null ? y : anchorVertical.getPositionValue(pageLayout, table.getHeight(), y, oddPage, borderLineWidths);
        if (anchorHorizontal == null) {
            if (source.getTableJustification() != null) {
                STJcTable.Enum tjc = source.getTableJustification();
                if (tjc == STJcTable.CENTER) {
                    pageX += (layoutArea.getWidth() - (double)source.getWidth()) / 2.0;
                } else if (tjc == STJcTable.RIGHT) {
                    pageX += layoutArea.getWidth() - (double)source.getWidth();
                }
            } else {
                pageX += (double)source.getTableIndent();
            }
        }
        table.setPageX(pageX);
        table.setPageY(pageY);
    }

    private class TableLayouterResult
    implements LayouterResult<TableView> {
        private final CellPageBreakPosition cellPageBreakPosition;
        private final TableView pageElement;

        public TableLayouterResult(CellPageBreakPosition cellPageBreakPosition, TableView pageElement) {
            this.cellPageBreakPosition = cellPageBreakPosition;
            this.pageElement = pageElement;
        }

        @Override
        public CellPageBreakPosition getBreakPosition() {
            return this.cellPageBreakPosition;
        }

        @Override
        public TableView getPageView() {
            return this.pageElement;
        }

        @Override
        public boolean needPageRelayout() {
            return false;
        }

        @Override
        public Break.BreakType getBreakType() {
            return null;
        }
    }
}

