/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.utilities;

import com.inet.docx.document.utilities.Util;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;

public class ParseOperations {
    public static Map<String, String> splitKeyValuePairs(String[] toSplit, char separator) {
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        for (String singleSplit : toSplit) {
            int splitIndex = singleSplit.indexOf(separator);
            if (splitIndex <= -1) continue;
            String key = singleSplit.substring(0, splitIndex);
            keyValueMap.put(key, singleSplit.substring(splitIndex + 1));
        }
        return keyValueMap;
    }

    @SuppressFBWarnings(value={"REDOS"}, justification="TODO")
    public static double handleValues(String in) {
        if (in == null || in.isEmpty()) {
            return 0.0;
        }
        if (in.matches("[+-]?([0-9]*[.])?[0-9]+")) {
            return Double.parseDouble(in);
        }
        if (in.matches(";")) {
            return ParseOperations.handleValues(in.split(";")[0]);
        }
        in = in.toLowerCase();
        for (String supportedUnit : Util.getSupportedUnit().keySet()) {
            if (!in.endsWith(supportedUnit)) continue;
            double factor = Util.SUPPORTED_UNIT.get(supportedUnit);
            return ParseOperations.handleValues(in.replace(supportedUnit, "")) * factor;
        }
        Util.LOGGER.error((Object)("Not supported unit. The value is " + in));
        return 0.0;
    }
}

