/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.table;

import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.style.CellBorder;
import com.inet.docx.document.elements.style.CellStyle;
import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.elements.style.StyleTable;
import com.inet.docx.document.elements.subelements.drawing.Anchor;
import com.inet.docx.document.elements.subelements.table.TableBorder;
import com.inet.docx.document.elements.subelements.table.TableCell;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.layout.Layouter;
import com.inet.docx.layout.TableLayouter;
import com.inet.docx.view.drawing.BorderLineExternalWidths;
import com.inet.docx.view.drawing.DrawingFactory;
import com.inet.docx.view.table.TableView;
import java.awt.Color;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.List;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTCnf;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJcTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTextDirection;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class TableData
implements DocumentElement {
    private TableCell[][] matrix;
    private StyleTable styleTable;
    private CellStyle defaultCellStyle;
    private int[] columnSizes;
    private int tableIndent;
    private STJcTable.Enum tjc;
    private Insets defaultMargins;
    private Anchor verticalAnchor;
    private Anchor horizontalAnchor;
    private int repeatingHeaderRow;
    private TableBorder borders;
    private boolean excelStyle = false;

    private TableData() {
    }

    public TableData(int[] columnSizes, int numberOfRows, int repeatingHeaderRow, Anchor horizontalAnchor, Anchor verticalAnchor, STJcTable.Enum tjc, Insets defaultMargins, int tableIndent, StyleTable styleTable, CellStyle defaultCellStyle) {
        this.repeatingHeaderRow = repeatingHeaderRow;
        this.matrix = new TableCell[columnSizes.length][numberOfRows];
        this.columnSizes = columnSizes;
        this.horizontalAnchor = horizontalAnchor;
        this.verticalAnchor = verticalAnchor;
        this.tjc = tjc;
        this.defaultMargins = defaultMargins;
        this.tableIndent = tableIndent;
        this.styleTable = styleTable;
        this.defaultCellStyle = defaultCellStyle;
    }

    public void setBorders(TableBorder borders) {
        this.borders = borders;
    }

    public BorderLineExternalWidths getBorderLineExternalWidths() {
        if (this.borders == null) {
            return new BorderLineExternalWidths(0.0);
        }
        double left = this.getLineWidthFrom(this.borders.getLeftLine());
        double right = this.getLineWidthFrom(this.borders.getRightLine());
        double top = this.getLineWidthFrom(this.borders.getTopLine());
        double bottom = this.getLineWidthFrom(this.borders.getBottomLine());
        return new BorderLineExternalWidths(left, right, top, bottom);
    }

    private double getLineWidthFrom(LineProperties line) {
        return line == null ? 0.0 : Integer.valueOf(line.getWidth()).doubleValue();
    }

    public boolean isExcelStyle() {
        return this.excelStyle;
    }

    public void setExcelStyle(boolean excelStyle) {
        this.excelStyle = excelStyle;
    }

    public int getRepeatingHeaderRowCount() {
        return this.repeatingHeaderRow;
    }

    @Override
    public boolean isKeepParagraphTogetherWithNextParagraph() {
        return false;
    }

    public STJcTable.Enum getTableJustification() {
        return this.tjc;
    }

    public int getTableIndent() {
        return this.tableIndent;
    }

    public int getWidth() {
        int width = 0;
        for (int colWidth : this.columnSizes) {
            width += colWidth;
        }
        return width;
    }

    public int getColumnCount() {
        return this.columnSizes.length;
    }

    public int getColumnSize(int column) {
        return this.columnSizes[column];
    }

    public int getRowCount() {
        return this.matrix[0].length;
    }

    public Point2D getAnchorOffset() {
        double x = this.horizontalAnchor != null ? this.horizontalAnchor.getOffsetValue() : 0.0;
        double y = this.verticalAnchor != null ? this.verticalAnchor.getOffsetValue() : 0.0;
        return new Point2D.Double(x, y);
    }

    public void addCell(TableCell tableCell) {
        for (int col = Math.max(tableCell.getStartColumn(), 0); col <= Math.min(tableCell.getEndColumn(), this.getColumnCount() - 1); ++col) {
            for (int row = Math.max(tableCell.getStartRow(), 0); row <= Math.min(tableCell.getEndRow(), this.getRowCount() - 1); ++row) {
                this.matrix[col][row] = tableCell;
            }
        }
        this.completeCellBorders(tableCell);
    }

    public TableCell addCell(int rowNumber, CTTc tc, List<StyleTable.CellType> cellStyleTypes, HashMap<String, Color> themeColors) {
        int i;
        TableCell tcInternal;
        int currentColumnStart = -1;
        int currentColumnEnd = -1;
        boolean verticalMerge = false;
        for (int i2 = 0; i2 < this.matrix.length; ++i2) {
            if (this.matrix[i2][rowNumber] != null) continue;
            currentColumnStart = currentColumnEnd = i2;
            break;
        }
        STTextDirection.Enum textDirection = null;
        CellStyle cellStyle = null;
        Color bgColor = null;
        CTTcPr tcpr = null;
        if (tc != null && tc.isSetTcPr()) {
            CTVerticalJc vertAlign;
            CTShd shd;
            CTTcMar mar;
            List<StyleTable.CellType> internalCellStyleTypes;
            tcpr = tc.getTcPr();
            if (tcpr.isSetTextDirection()) {
                textDirection = tcpr.getTextDirection().getVal();
            }
            if (tcpr.isSetGridSpan()) {
                currentColumnEnd += tcpr.getGridSpan().getVal().intValue() - 1;
            } else if (tcpr.isSetHMerge()) {
                ++currentColumnEnd;
            }
            CTCnf cnf = tcpr.getCnfStyle();
            if (cnf != null && (internalCellStyleTypes = this.styleTable.getCellTypesForCnfKey(cnf.getVal())) != null) {
                if (cellStyleTypes != null) {
                    for (StyleTable.CellType ct : cellStyleTypes) {
                        if (internalCellStyleTypes.contains((Object)ct)) continue;
                        internalCellStyleTypes.add(ct);
                    }
                }
                cellStyleTypes = internalCellStyleTypes;
            }
            cellStyle = cellStyleTypes != null ? this.styleTable.getCellStyle(cellStyleTypes).clone() : this.defaultCellStyle.clone();
            if (tcpr.isSetVMerge() && !STMerge.RESTART.equals(tcpr.getVMerge().getVal())) {
                verticalMerge = true;
            }
            if ((mar = tcpr.getTcMar()) != null) {
                cellStyle.setMargin(new Insets(Util.getValueFromWidth(mar.getTop()), Util.getValueFromWidth(mar.getLeft()), Util.getValueFromWidth(mar.getBottom()), Util.getValueFromWidth(mar.getRight())));
            }
            if (tcpr.isSetTcBorders()) {
                cellStyle.setBorder(new CellBorder(cellStyle.getBorder(), tcpr.getTcBorders(), null));
            }
            if ((shd = tcpr.getShd()) != null) {
                STShd.Enum shdVal = shd.getVal();
                Object color = shd.getFill();
                if (shdVal == STShd.CLEAR && "auto".equals(color)) {
                    bgColor = Color.WHITE;
                } else {
                    if (color == null) {
                        color = shd.getColor();
                    }
                    bgColor = Util.getColor(shdVal, color, color, shd.getThemeFill(), themeColors);
                }
            }
            if ((vertAlign = tcpr.getVAlign()) != null) {
                STVerticalJc.Enum vA = vertAlign.getVal();
                cellStyle.setVerticalAlign(vA);
            }
        } else {
            cellStyle = cellStyleTypes != null ? this.styleTable.getCellStyle(cellStyleTypes) : this.defaultCellStyle.clone();
        }
        if (cellStyle.getMargin() == null) {
            cellStyle.setMargin(this.defaultMargins);
        }
        if (verticalMerge) {
            tcInternal = this.matrix[currentColumnStart][rowNumber - 1];
            CellBorder cbCell = tcInternal.getCellStyle().getBorder();
            cbCell.setBottomLine(cellStyle.getBorder().getBottomLine());
        } else {
            tcInternal = new TableCell(this, currentColumnStart, rowNumber, cellStyle);
        }
        int width = 0;
        int n = i = currentColumnStart < 0 ? 0 : currentColumnStart;
        while (i <= currentColumnEnd) {
            this.matrix[i][rowNumber] = tcInternal;
            width += this.columnSizes[i];
            ++i;
        }
        if (width == 0 && tcpr != null && tcpr.isSetTcW()) {
            width = Util.getInt(tcpr.getTcW().getW());
        }
        if (bgColor != null) {
            tcInternal.setBackgroundColor(bgColor);
        }
        tcInternal.setWidth(width);
        tcInternal.setTextDirection(textDirection);
        tcInternal.setEndColumn(currentColumnEnd);
        tcInternal.setEndRow(rowNumber);
        this.completeCellBorders(tcInternal);
        return tcInternal;
    }

    private void completeCellBorders(TableCell tc) {
        CellBorder cb;
        if (!(tc == null || tc.getCellStyle() == null || tc.getCellStyle().getBorder() == null || DrawingFactory.isPrintable((cb = tc.getCellStyle().getBorder().clone()).getTopLine()) && DrawingFactory.isPrintable(cb.getBottomLine()) && DrawingFactory.isPrintable(cb.getRightLine()) && DrawingFactory.isPrintable(cb.getLeftLine()))) {
            int startY = tc.getStartRow();
            int endY = tc.getStartRow();
            int startX = tc.getStartColumn();
            int endX = tc.getStartColumn();
            if (this.borders != null) {
                LineProperties lb;
                if (!DrawingFactory.isPrintable(cb.getTopLine())) {
                    lb = startY > 0 ? this.borders.getInsideHorizontal() : this.borders.getTopLine();
                    cb.setTopLine(lb);
                }
                if (!DrawingFactory.isPrintable(cb.getBottomLine())) {
                    lb = endY < this.getRowCount() - 1 ? this.borders.getInsideHorizontal() : this.borders.getBottomLine();
                    cb.setBottomLine(lb);
                }
                if (!DrawingFactory.isPrintable(cb.getRightLine())) {
                    lb = endX < this.getColumnCount() - 1 ? this.borders.getInsideVertical() : this.borders.getRightLine();
                    cb.setRightLine(lb);
                }
                if (!DrawingFactory.isPrintable(cb.getLeftLine())) {
                    lb = startX > 0 ? this.borders.getInsideVertical() : this.borders.getLeftLine();
                    cb.setLeftLine(lb);
                }
            }
            tc.getCellStyle().setBorder(cb);
        }
    }

    public TableCell getCell(int column, int row) {
        return this.matrix[column][row];
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public DocumentElement clone() {
        TableData td = new TableData();
        td.verticalAnchor = this.verticalAnchor;
        td.horizontalAnchor = this.horizontalAnchor;
        td.tjc = this.tjc;
        td.defaultMargins = this.defaultMargins;
        td.tableIndent = this.tableIndent;
        td.columnSizes = this.columnSizes;
        td.matrix = new TableCell[this.columnSizes.length][this.getRowCount()];
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.columnSizes.length; ++column) {
                TableCell tca = this.getCell(column, row);
                tca = tca.getStartRow() == row && tca.getStartColumn() == column ? tca.clone(td) : td.getCell(tca.getStartColumn(), tca.getStartRow());
                td.matrix[column][row] = tca;
            }
        }
        return td;
    }

    @Override
    public Layouter<TableView> getLayouter() {
        return new TableLayouter(this);
    }

    @Override
    public Spacing getSpacing() {
        return null;
    }

    public String toString() {
        return "Table " + this.getColumnCount() + "x" + this.getRowCount();
    }

    public Anchor getVerticalAnchor() {
        return this.verticalAnchor;
    }

    public Anchor getHorizontalAnchor() {
        return this.horizontalAnchor;
    }
}

